<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('midias', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->string('type'); // image or video
            $table->string('path');
            $table->foreignId('empresa_id')->constrained()->onDelete('cascade');
            $table->string('equipment_serial')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('midias');
    }
};
