<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            // Vínculo com empresa (franquia ou cliente)
            $table->foreignId('empresa_id')
                  ->nullable()
                  ->after('email')
                  ->constrained('empresas')
                  ->onDelete('restrict');
            
            // Status do cadastro (pendente, aprovado, rejeitado)
            $table->enum('status_cadastro', ['pendente', 'aprovado', 'rejeitado'])
                  ->default('pendente')
                  ->after('empresa_id')
                  ->comment('Status de aprovação do cadastro');
            
            // Quem aprovou o cadastro
            $table->foreignId('aprovado_por')
                  ->nullable()
                  ->after('status_cadastro')
                  ->constrained('users')
                  ->onDelete('set null');
            
            // Quando foi aprovado
            $table->timestamp('aprovado_em')
                  ->nullable()
                  ->after('aprovado_por');
            
            // Motivo da rejeição (se aplicável)
            $table->text('motivo_rejeicao')
                  ->nullable()
                  ->after('aprovado_em');
            
            // Índices para performance
            $table->index('empresa_id');
            $table->index('status_cadastro');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropForeign(['empresa_id']);
            $table->dropForeign(['aprovado_por']);
            $table->dropIndex(['empresa_id']);
            $table->dropIndex(['status_cadastro']);
            $table->dropColumn([
                'empresa_id',
                'status_cadastro',
                'aprovado_por',
                'aprovado_em',
                'motivo_rejeicao'
            ]);
        });
    }
};
