<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('publicacoes', function (Blueprint $table) {
            // Tipo de alcance da publicação
            $table->enum('tipo_alcance', ['todos', 'serial_especifico', 'grupo'])
                  ->default('todos')
                  ->after('status')
                  ->comment('Define se a publicação é para todos equipamentos, serial específico ou grupo');
            
            // Serial específico do equipamento (quando tipo_alcance = 'serial_especifico')
            $table->string('equipment_serial', 255)
                  ->nullable()
                  ->after('tipo_alcance')
                  ->comment('Serial do equipamento específico (opcional)');
            
            // ID do grupo de equipamentos (quando tipo_alcance = 'grupo')
            $table->unsignedBigInteger('grupo_equipamentos_id')
                  ->nullable()
                  ->after('equipment_serial')
                  ->comment('ID do grupo de equipamentos (opcional)');
            
            // Índices para performance
            $table->index('tipo_alcance');
            $table->index('equipment_serial');
            $table->index('grupo_equipamentos_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('publicacoes', function (Blueprint $table) {
            $table->dropIndex(['tipo_alcance']);
            $table->dropIndex(['equipment_serial']);
            $table->dropIndex(['grupo_equipamentos_id']);
            
            $table->dropColumn(['tipo_alcance', 'equipment_serial', 'grupo_equipamentos_id']);
        });
    }
};
