<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('publicacoes', function (Blueprint $table) {
            // Total de visualizações (incrementado via API externa)
            $table->unsignedBigInteger('total_visualizacoes')->default(0)->after('impressoes_contratadas');
            
            // Tipo da mídia (duplicado do criativo para facilitar consultas)
            // Valores: 'imagem' ou 'video'
            $table->enum('tipo_midia', ['imagem', 'video'])->nullable()->after('total_visualizacoes');
            
            // Posição de exibição (1 a 6)
            // Posição única por equipamento (serial) ou por empresa
            $table->unsignedTinyInteger('posicao')->nullable()->after('tipo_midia')
                  ->comment('Posição de 1 a 6 para exibição');
            
            // Índice para performance em consultas de visualizações
            $table->index('total_visualizacoes');
            $table->index('posicao');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('publicacoes', function (Blueprint $table) {
            $table->dropIndex(['total_visualizacoes']);
            $table->dropIndex(['posicao']);
            $table->dropColumn(['total_visualizacoes', 'tipo_midia', 'posicao']);
        });
    }
};
