<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('auditoria_splash', function (Blueprint $table) {
            $table->id();
            $table->string('hs_serial')->nullable()->comment('Serial do hotspot');
            $table->string('cl_mac_address')->nullable()->comment('MAC address do cliente');
            $table->string('pag_click')->nullable()->comment('Página clicada');
            $table->string('imagem')->nullable()->comment('Nome da imagem exibida');
            $table->string('dsc_identity')->nullable()->comment('Identity do equipamento');
            $table->timestamp('created_at')->nullable();

            $table->index('hs_serial');
            $table->index('created_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('auditoria_splash');
    }
};
