<?php

namespace Database\Seeders;

use App\Models\Empresa;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class FormatosPermitidosSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $franquias = Empresa::where('tipo_empresa', 'franquia')->get();
        
        echo "🎨 CONFIGURANDO FORMATOS PERMITIDOS POR FRANQUIA...\n\n";
        
        foreach ($franquias as $franquia) {
            echo "🏢 {$franquia->name}:\n";
            
            if ($franquia->name == 'FreeFi São Paulo') {
                // SP: Todos os formatos habilitados
                $formatos = [
                    ['formato' => 'jpg', 'ativo' => true],
                    ['formato' => 'png', 'ativo' => true],
                    ['formato' => 'gif', 'ativo' => true],
                    ['formato' => 'mp4', 'ativo' => true],
                    ['formato' => 'html', 'ativo' => true],
                ];
                
                echo "  ✅ Todos os formatos habilitados (JPG, PNG, GIF, MP4, HTML)\n";
                
            } elseif ($franquia->name == 'FreeFi Rio de Janeiro') {
                // RJ: Sem vídeo MP4
                $formatos = [
                    ['formato' => 'jpg', 'ativo' => true],
                    ['formato' => 'png', 'ativo' => true],
                    ['formato' => 'gif', 'ativo' => true],
                    ['formato' => 'mp4', 'ativo' => false], // Desabilitado
                    ['formato' => 'html', 'ativo' => true],
                ];
                
                echo "  ✅ JPG, PNG, GIF, HTML\n";
                echo "  ❌ MP4 desabilitado\n";
                
            } elseif ($franquia->name == 'FreeFi Minas Gerais') {
                // MG: Apenas imagens básicas
                $formatos = [
                    ['formato' => 'jpg', 'ativo' => true],
                    ['formato' => 'png', 'ativo' => true],
                    ['formato' => 'gif', 'ativo' => false], // Desabilitado
                    ['formato' => 'mp4', 'ativo' => false], // Desabilitado
                    ['formato' => 'html', 'ativo' => false], // Desabilitado
                ];
                
                echo "  ✅ Apenas JPG, PNG\n";
                echo "  ❌ GIF, MP4, HTML desabilitados\n";
                
            } else {
                // Bahia (desativada): Configuração padrão mínima
                $formatos = [
                    ['formato' => 'jpg', 'ativo' => true],
                    ['formato' => 'png', 'ativo' => true],
                    ['formato' => 'gif', 'ativo' => false],
                    ['formato' => 'mp4', 'ativo' => false],
                    ['formato' => 'html', 'ativo' => false],
                ];
                
                echo "  ✅ JPG, PNG (franquia desativada)\n";
            }
            
            // Inserir formatos
            foreach ($formatos as $formato) {
                DB::table('franquia_formatos_permitidos')->insert([
                    'franquia_id' => $franquia->id,
                    'formato' => $formato['formato'],
                    'ativo' => $formato['ativo'],
                    'created_at' => now(),
                    'updated_at' => now(),
                ]);
            }
            
            echo "\n";
        }
        
        echo "📊 RESUMO:\n";
        echo "   • Total de configurações: " . DB::table('franquia_formatos_permitidos')->count() . "\n";
        echo "   • Formatos ativos: " . DB::table('franquia_formatos_permitidos')->where('ativo', true)->count() . "\n";
        echo "   • Formatos desabilitados: " . DB::table('franquia_formatos_permitidos')->where('ativo', false)->count() . "\n";
        echo "\n";
        echo "💡 VALIDAÇÃO DE UPLOAD:\n";
        echo "   • SP pode fazer upload de TODOS os formatos\n";
        echo "   • RJ NÃO pode fazer upload de MP4\n";
        echo "   • MG pode apenas JPG e PNG\n";
    }
}
