<?php

namespace Database\Seeders;

use App\Models\Hotspot;
use App\Models\Empresa;
use Illuminate\Database\Seeder;

class HotspotSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Verifica se existem empresas
        $empresas = Empresa::all();
        
        if ($empresas->isEmpty()) {
            $this->command->error('Nenhuma empresa encontrada. Por favor, crie empresas primeiro.');
            return;
        }

        $this->command->info('Criando hotspots...');

        // Criar 15 hotspots de teste
        Hotspot::factory()->count(15)->create();

        $this->command->info('15 hotspots criados com sucesso!');
    }
}
