# 🧪 Teste Manual - Modal de Analytics

**Objetivo:** Testar se o modal de analytics carrega e exibe dados corretamente  
**Data:** 03 de Novembro de 2025  
**Tempo Estimado:** 10 minutos

---

## 📋 Pré-requisitos

✅ Servidor rodando em http://localhost:8082  
✅ Usuário autenticado no sistema  
✅ Pelo menos 1 publicação criada  

---

## 🎯 Cenário de Teste

### Teste 1: Verificar se o Modal Abre

1. Acesse: http://localhost:8082/publicacoes
2. Localize uma publicação na listagem
3. No card da publicação, procure o **ícone de relógio** 🕐 ao lado das visualizações
4. Clique no ícone de relógio

**Resultado Esperado:**
- ✅ Modal deve abrir
- ✅ Título do modal: "Visualizações: [Nome da Publicação]"
- ✅ Exibe spinner de carregamento inicialmente

**Status:** ⬜ PASS | ⬜ FAIL

---

### Teste 2: Verificar Carregamento dos Dados

Após o modal abrir (Teste 1):

1. Aguarde 1-2 segundos
2. Observe se o spinner desaparece
3. Verifique se os dados são exibidos

**Resultado Esperado:**
- ✅ Spinner desaparece
- ✅ Cards de estatísticas aparecem
- ✅ Dados numéricos são exibidos

**Status:** ⬜ PASS | ⬜ FAIL

---

### Teste 3: Verificar Estrutura dos Dados

No modal aberto, verifique se os seguintes elementos estão presentes:

**Card de Impressões/Visualizações:**
- ✅ Ícone de olho (👁️)
- ✅ Número total de impressões
- ✅ Usuários únicos (se houver dados detalhados)

**Card de Cliques:**
- ✅ Ícone de mouse (🖱️)
- ✅ Número total de cliques
- ✅ Taxa de CTR (%)

**Outros Elementos:**
- ✅ Botão "Ver Estatísticas Completas"
- ✅ Botão "Fechar"

**Status:** ⬜ PASS | ⬜ FAIL

---

### Teste 4: Verificar Endpoint AJAX (DevTools)

1. Abra o DevTools do navegador (F12)
2. Vá para a aba **Network**
3. Clique no ícone de relógio de uma publicação
4. Observe a requisição AJAX

**Resultado Esperado:**
- ✅ Requisição para `/publicacoes/{id}/analytics-json`
- ✅ Status Code: **200 OK**
- ✅ Response Type: **application/json**
- ✅ Tempo de resposta: **< 1 segundo**

**Status:** ⬜ PASS | ⬜ FAIL

---

### Teste 5: Verificar JSON Retornado

Ainda no DevTools (Network):

1. Clique na requisição `analytics-json`
2. Vá para aba **Response** ou **Preview**
3. Verifique a estrutura do JSON

**Estrutura Esperada:**
```json
{
  "publicacao": {
    "id": 1,
    "titulo": "Nome da Publicação",
    "status": "ativa",
    "data_inicio": "2025-11-01",
    "data_fim": "2025-11-30"
  },
  "stats": {
    "total_visualizacoes": 100,
    "total_impressoes": 100,
    "total_usuarios_unicos": 0,
    "total_cliques": 0,
    "ctr": 0,
    "media_diaria_impressoes": 10.5,
    "media_diaria_cliques": 0,
    "usando_dados_detalhados": false
  },
  "impressoes_recentes": [],
  "logs_acesso": [],
  "total_logs": 0
}
```

**Validações:**
- ✅ Todos os campos estão presentes
- ✅ Tipos de dados corretos (números são números, não strings)
- ✅ `total_impressoes` >= 0
- ✅ `ctr` é um número entre 0 e 100

**Status:** ⬜ PASS | ⬜ FAIL

---

### Teste 6: Testar com Publicação SEM Dados

1. Crie uma nova publicação
2. **Não gere** nenhuma impressão ou clique
3. Clique no ícone de relógio da nova publicação

**Resultado Esperado:**
- ✅ Modal abre normalmente
- ✅ Exibe valores zerados (0)
- ✅ Mensagem indicando ausência de dados
- ✅ Sem erros JavaScript no console

**Status:** ⬜ PASS | ⬜ FAIL

---

### Teste 7: Testar com Publicação COM Dados

1. Use uma publicação que tenha impressões/cliques
2. Clique no ícone de relógio

**Resultado Esperado:**
- ✅ Modal exibe números > 0
- ✅ CTR calculado corretamente (cliques/impressões * 100)
- ✅ Médias diárias calculadas
- ✅ Se `usando_dados_detalhados === true`, exibe dados da tabela `publicacao_impressoes`
- ✅ Se `usando_dados_detalhados === false`, usa `total_visualizacoes`

**Status:** ⬜ PASS | ⬜ FAIL

---

### Teste 8: Botão "Ver Estatísticas Completas"

No modal aberto:

1. Clique no botão **"Ver Estatísticas Completas"**

**Resultado Esperado:**
- ✅ Abre nova aba/janela
- ✅ URL: `/publicacoes/{id}/estatisticas`
- ✅ Página carrega com gráficos e tabelas detalhadas

**Status:** ⬜ PASS | ⬜ FAIL

---

### Teste 9: Testar Múltiplas Publicações

1. Abra o modal da Publicação 1
2. Feche o modal
3. Abra o modal da Publicação 2
4. Verifique se os dados são diferentes

**Resultado Esperado:**
- ✅ Cada modal exibe dados da publicação correta
- ✅ Título do modal muda para cada publicação
- ✅ Link "Ver Estatísticas Completas" aponta para URL correta

**Status:** ⬜ PASS | ⬜ FAIL

---

### Teste 10: Verificar Console do Navegador

Durante todos os testes acima:

1. Mantenha o Console do DevTools aberto (F12 → Console)
2. Observe se aparecem erros

**Resultado Esperado:**
- ✅ **Nenhum erro JavaScript**
- ✅ **Nenhum erro 404 ou 500**
- ✅ Apenas logs informativos (se houver)

**Status:** ⬜ PASS | ⬜ FAIL

---

## 📊 Checklist de Validação Técnica

### Endpoint `/publicacoes/{id}/analytics-json`

| Validação | Esperado | Status |
|-----------|----------|--------|
| **Status Code** | 200 OK | ⬜ |
| **Content-Type** | application/json | ⬜ |
| **Tempo de Resposta** | < 1 segundo | ⬜ |
| **Tamanho Response** | < 100 KB | ⬜ |

### Estrutura JSON

| Campo | Tipo | Obrigatório | Status |
|-------|------|-------------|--------|
| `publicacao.id` | integer | ✅ | ⬜ |
| `publicacao.titulo` | string | ✅ | ⬜ |
| `publicacao.status` | string | ✅ | ⬜ |
| `stats.total_impressoes` | integer | ✅ | ⬜ |
| `stats.total_cliques` | integer | ✅ | ⬜ |
| `stats.ctr` | float | ✅ | ⬜ |
| `stats.usando_dados_detalhados` | boolean | ✅ | ⬜ |
| `impressoes_recentes` | array | ✅ | ⬜ |
| `logs_acesso` | array | ✅ | ⬜ |

### Cálculos

| Cálculo | Fórmula | Status |
|---------|---------|--------|
| **CTR** | (cliques / impressões) * 100 | ⬜ |
| **Média Diária Impressões** | impressões / dias decorridos | ⬜ |
| **Média Diária Cliques** | cliques / dias decorridos | ⬜ |

---

## 🐛 Troubleshooting

### Problema: Modal não abre

**Possíveis Causas:**
1. JavaScript não carregado
2. Bootstrap não inicializado
3. Erro no atributo `data-publicacao-id`

**Solução:**
```javascript
// Verificar no Console
document.getElementById('analyticsModal')
```

### Problema: Spinner não desaparece

**Possíveis Causas:**
1. Requisição AJAX falhou
2. Erro 500 no backend
3. JSON inválido retornado

**Solução:**
```javascript
// Verificar no Console
fetch('/publicacoes/1/analytics-json')
  .then(r => r.json())
  .then(console.log)
  .catch(console.error)
```

### Problema: Dados zerados mesmo com visualizações

**Possíveis Causas:**
1. `track_impressoes` = false
2. `track_cliques` = false  
3. Dados não salvos na tabela `publicacao_impressoes`

**Solução:**
```sql
-- Verificar configuração
SELECT id, titulo, track_impressoes, track_cliques, total_visualizacoes 
FROM publicacoes 
WHERE id = 1;

-- Verificar dados detalhados
SELECT * FROM publicacao_impressoes WHERE publicacao_id = 1;
```

### Problema: CTR incorreto

**Possíveis Causas:**
1. Divisão por zero
2. Lógica de cálculo errada

**Solução:**
```javascript
// Fórmula correta
const ctr = impressoes > 0 ? (cliques / impressoes) * 100 : 0;
```

---

## 📝 Relatório de Teste

**Testador:** _______________  
**Data:** ___/___/_____  
**Hora:** ___:___  

### Resumo

| Categoria | Total | Pass | Fail |
|-----------|-------|------|------|
| **Testes Funcionais** | 10 | ___ | ___ |
| **Validações Técnicas** | 4 | ___ | ___ |
| **Estrutura JSON** | 9 | ___ | ___ |
| **Cálculos** | 3 | ___ | ___ |
| **TOTAL** | 26 | ___ | ___ |

### Taxa de Sucesso

```
Sucesso = (Pass / Total) * 100
       = (___  / 26) * 100
       = ____%
```

### Observações

```
___________________________________________________________
___________________________________________________________
___________________________________________________________
___________________________________________________________
```

### Screenshot de Evidência

📸 Anexar screenshot do modal aberto mostrando dados carregados

---

## ✅ Critérios de Aceitação

Para o modal ser considerado **APROVADO**, deve atender:

- ✅ 100% dos Testes Funcionais (10/10)
- ✅ 100% das Validações Técnicas (4/4)
- ✅ 100% da Estrutura JSON (9/9)
- ✅ Nenhum erro JavaScript no console
- ✅ Tempo de resposta < 1 segundo

**Status Final:** ⬜ APROVADO | ⬜ REPROVADO

---

## 📚 Referências

- **Endpoint:** `PublicacaoController@analyticsJson`
- **View:** `resources/views/publicacoes/index.blade.php` (linha 460)
- **Route:** `routes/web.php` (publicacoes.analyticsJson)
- **JavaScript:** Inline no final da view index.blade.php

---

**Última atualização:** 03/11/2025 17:50 UTC  
**Mantido por:** Equipe FreeFi Admin
