#!/bin/bash

###############################################################################
# Script: Executar Testes Dusk do Modal de Analytics
# Descrição: Testa o modal de analytics no navegador real com Chrome
# Autor: Equipe FreeFi
# Data: 03/11/2025
###############################################################################

# Cores
GREEN='\033[0;32m'
BLUE='\033[0;34m'
YELLOW='\033[1;33m'
RED='\033[0;31m'
NC='\033[0m'

# Diretório do projeto
PROJECT_DIR="/var/www/html/laravel/admin/freefi_admin"
cd "$PROJECT_DIR" || exit 1

echo -e "${BLUE}╔═══════════════════════════════════════════════════════════════╗${NC}"
echo -e "${BLUE}║    TESTE DUSK - MODAL DE ANALYTICS (NAVEGADOR REAL)          ║${NC}"
echo -e "${BLUE}╚═══════════════════════════════════════════════════════════════╝${NC}"
echo ""

###############################################################################
# FASE 1: Verificar ChromeDriver
###############################################################################

echo -e "${YELLOW}[1/4] Verificando ChromeDriver...${NC}"
echo ""

if ! command -v chromedriver &> /dev/null; then
    echo -e "${YELLOW}ChromeDriver não encontrado. Instalando...${NC}"
    php artisan dusk:chrome-driver --detect
    echo ""
fi

CHROME_VERSION=$(chromedriver --version 2>/dev/null | head -1 || echo "Não instalado")
echo -e "  ChromeDriver: $CHROME_VERSION"
echo ""

###############################################################################
# FASE 2: Preparar Ambiente
###############################################################################

echo -e "${YELLOW}[2/4] Preparando ambiente de testes...${NC}"
echo ""

# Limpar screenshots antigos
rm -rf tests/Browser/screenshots/*.png 2>/dev/null
mkdir -p tests/Browser/screenshots

# Limpar caches
php artisan config:clear --quiet
php artisan view:clear --quiet

# Garantir que o servidor está rodando
if ! curl -s http://localhost:8082 > /dev/null; then
    echo -e "${RED}❌ ERRO: Servidor não está rodando em http://localhost:8082${NC}"
    echo ""
    echo "Por favor, inicie o servidor:"
    echo "  docker-compose up -d"
    echo ""
    exit 1
fi

echo -e "${GREEN}✓ Ambiente preparado${NC}"
echo ""

###############################################################################
# FASE 3: Executar Testes Dusk
###############################################################################

echo -e "${YELLOW}[3/4] Executando testes Dusk do Modal...${NC}"
echo ""
echo "  Isso pode levar alguns minutos..."
echo "  O Chrome será aberto automaticamente"
echo ""

# Executar via Docker se disponível
if docker-compose ps | grep -q "freefi_admin_app"; then
    echo "  Executando via Docker..."
    docker-compose exec -T app php artisan dusk tests/Browser/PublicacaoAnalyticsModalDuskTest.php
    RESULT=$?
else
    echo "  Executando diretamente..."
    php artisan dusk tests/Browser/PublicacaoAnalyticsModalDuskTest.php
    RESULT=$?
fi

echo ""

###############################################################################
# FASE 4: Resultados
###############################################################################

echo -e "${YELLOW}[4/4] Analisando resultados...${NC}"
echo ""

# Contar screenshots gerados
SCREENSHOTS=$(ls -1 tests/Browser/screenshots/*.png 2>/dev/null | wc -l)
echo "  Screenshots gerados: $SCREENSHOTS"

# Listar screenshots
if [ $SCREENSHOTS -gt 0 ]; then
    echo ""
    echo "  Screenshots disponíveis em: tests/Browser/screenshots/"
    ls -1 tests/Browser/screenshots/*.png | sed 's/^/    - /'
fi

echo ""
echo -e "${BLUE}╔═══════════════════════════════════════════════════════════════╗${NC}"
echo -e "${BLUE}║                        RESULTADO FINAL                        ║${NC}"
echo -e "${BLUE}╚═══════════════════════════════════════════════════════════════╝${NC}"
echo ""

if [ $RESULT -eq 0 ]; then
    echo -e "${GREEN}╔═══════════════════════════════════════════════════════════════╗${NC}"
    echo -e "${GREEN}║          ✅ TODOS OS TESTES PASSARAM COM SUCESSO!            ║${NC}"
    echo -e "${GREEN}║                                                               ║${NC}"
    echo -e "${GREEN}║  O modal de analytics está funcionando PERFEITAMENTE!        ║${NC}"
    echo -e "${GREEN}╚═══════════════════════════════════════════════════════════════╝${NC}"
    echo ""
    echo "✅ Modal abre corretamente"
    echo "✅ Dados carregam via AJAX"
    echo "✅ Informações exibidas corretamente"
    echo "✅ Performance adequada"
    echo "✅ Sem erros JavaScript"
    echo ""
    exit 0
else
    echo -e "${RED}╔═══════════════════════════════════════════════════════════════╗${NC}"
    echo -e "${RED}║         ❌ ALGUNS TESTES FALHARAM - AÇÃO NECESSÁRIA!         ║${NC}"
    echo -e "${RED}╚═══════════════════════════════════════════════════════════════╝${NC}"
    echo ""
    echo "Verifique:"
    echo "  1. Logs acima para detalhes dos erros"
    echo "  2. Screenshots em tests/Browser/screenshots/"
    echo "  3. Console do navegador (se disponível)"
    echo ""
    echo "Possíveis problemas:"
    echo "  - Endpoint /analytics-json não retorna dados"
    echo "  - JavaScript com erros"
    echo "  - Timeout no carregamento AJAX"
    echo "  - Modal não inicializa corretamente"
    echo ""
    exit 1
fi

###############################################################################
# Informações Adicionais
###############################################################################

echo "📊 RELATÓRIO DETALHADO:"
echo ""
echo "  Arquivo de teste:"
echo "    tests/Browser/PublicacaoAnalyticsModalDuskTest.php"
echo ""
echo "  Total de testes: 15"
echo "    1. Modal abre ao clicar"
echo "    2. Spinner aparece"
echo "    3. Dados carregam"
echo "    4. Título correto"
echo "    5. Cards presentes"
echo "    6. Números exibidos"
echo "    7. Botão estatísticas completas"
echo "    8. Botão fechar"
echo "    9. Múltiplas publicações"
echo "    10. Performance < 2s"
echo "    11. JSON válido"
echo "    12. Sem erros console"
echo "    13. Responsivo mobile"
echo "    14. Clicar fora fecha"
echo "    15. Ícone clicável"
echo ""
echo "  Para executar apenas um teste específico:"
echo "    php artisan dusk --filter=test_modal_abre_ao_clicar_no_icone_relogio"
echo ""
