# 📋 Atualizações Necessárias - Frontend Hotspot

## 🎯 Objetivo
Atualizar as chamadas de API do frontend para a nova estrutura Laravel.

---

## 🔄 Alterações Necessárias

### **1. Caminho das Imagens de Publicidade**

**❌ ANTIGO:**
```javascript
var imageUrl = "http://172.233.21.57/adm/anexos/" + response.imagem;
```

**✅ NOVO:**
```javascript
var imageUrl = "http://172.233.21.57:8082/storage/" + response.imagem;
```

**📍 Arquivos a modificar:**
- `flash/hotspot/index.html` (linha ~165)

**💡 Explicação:**
- As imagens agora estão no storage do Laravel na porta 8082
- O path completo já vem da API (ex: `midias/907f8514402b80b689c6bfb6beb4d091.jpg`)

---

### **2. API de Splash (Publicações)**

**Status:** ✅ **Não precisa alterar**

A URL continua a mesma e funcionando:
```javascript
url: 'http://172.233.21.57/splash/splash_api.php'
```

**Resposta da API (agora com mais campos):**
```json
{
    "imagem": "midias/907f8514402b80b689c6bfb6beb4d091.jpg",
    "formato": "jpg",
    "titulo": "Instruções de Acesso",
    "link_destino": "#",
    "habilitar_clique": true
}
```

---

### **3. API de Auditoria (Rastreamento)**

**Status:** ✅ **Não precisa alterar**

A URL continua a mesma e funcionando:
```javascript
url: 'http://172.233.21.57/splash/audit_splash.php?confirma=y'
```

---

### **4. APIs de Cadastro e Consulta**

**⚠️ ATENÇÃO:** Estas APIs ainda NÃO foram modernizadas:

```javascript
// Cadastro de usuário
http://172.233.21.57/api/api.php

// Consulta por CPF/CNPJ
http://172.233.21.57/api/consulta.php?cpf_cnpj=...

// Consulta por MAC
http://172.233.21.57/consulta.php?mac=...

// Termos de uso
http://172.233.21.57/splash/tuso.php
```

**📝 Recomendação:** Estas APIs devem ser analisadas e migradas futuramente para Laravel.

---

### **5. Sistema de Assinatura (Porta 8080)**

**⚠️ ATENÇÃO:** Sistema em outra aplicação:

```javascript
http://172.233.21.57:8080/executar.php?acao=assinar
http://172.233.21.57:8080/confirmacao.php
http://172.233.21.57:8080/contrato.php
```

**📝 Recomendação:** Verificar se este sistema precisa ser integrado ao Laravel.

---

## 📝 Resumo das Mudanças Imediatas

### ✏️ Alterar em `flash/hotspot/index.html`:

**Linha ~165:**
```javascript
// DE:
var imageUrl = "http://172.233.21.57/adm/anexos/" + response.imagem;

// PARA:
var imageUrl = "http://172.233.21.57:8082/storage/" + response.imagem;
```

---

## ✅ Checklist de Validação

Após fazer a alteração, testar:

- [ ] As imagens de publicidade carregam corretamente
- [ ] O modal de publicidade abre normalmente
- [ ] A auditoria está sendo gravada no banco (`auditoria_splash`)
- [ ] Não há erros 404 no console do navegador

---

## 🔍 Campos Adicionais Disponíveis

A nova API retorna campos extras que podem ser usados no frontend:

```javascript
response.formato          // "jpg", "png", "mp4", etc
response.titulo           // Título da publicação
response.link_destino     // URL de destino (se clicar)
response.habilitar_clique // true/false
```

**💡 Sugestão de melhoria futura:**
Usar `response.habilitar_clique` para tornar a imagem clicável apenas quando permitido.

---

## 📊 Status das APIs

| API | Status | Porta | Observação |
|-----|--------|-------|------------|
| `/splash/splash_api.php` | ✅ Modernizado | 80 | Conecta no Laravel MySQL |
| `/splash/audit_splash.php` | ✅ Modernizado | 80 | Grava em `auditoria_splash` |
| `/api/api.php` | ⚠️ Legado | 80 | Precisa migrar |
| `/api/consulta.php` | ⚠️ Legado | 80 | Precisa migrar |
| `/consulta.php` | ⚠️ Legado | 80 | Precisa migrar |
| `/splash/tuso.php` | ⚠️ Legado | 80 | Precisa migrar |
| Assinatura | ⚠️ Separado | 8080 | Sistema independente |

---

**Última atualização:** 21/10/2025
**Versão:** 1.0
