# 🚀 DEPLOY IMEDIATO - PASSO A PASSO

**Servidor:** 172.233.21.57
**Usuário:** root
**Porta:** 8082
**Rede:** root_mikrotik_net (existente)

---

## ✅ ETAPA 1: PREPARAR SERVIDOR (10 minutos)

### Opção A: Copiar e executar script automatizado

```bash
# Do seu computador local, copiar script para o servidor:
scp scripts/setup-production-server.sh root@172.233.21.57:/tmp/

# SSH no servidor e executar:
ssh root@172.233.21.57
bash /tmp/setup-production-server.sh
```

### Opção B: Executar comandos manualmente

```bash
# SSH no servidor
ssh root@172.233.21.57

# Criar diretório
mkdir -p /var/www/freefi
cd /var/www/freefi

# Clonar repositório
git clone https://github.com/freefi-com-br/freefiadm.git .

# Configurar .env
cp .env.production.example .env
nano .env
```

**Edite o .env e configure:**
```env
APP_DEBUG=false
DB_PASSWORD=SENHA_SEGURA_AQUI
DB_ROOT_PASSWORD=SENHA_ROOT_AQUI
MAIL_USERNAME=seu_email@dominio.com
MAIL_PASSWORD=sua_senha_email
```

```bash
# Gerar APP_KEY
docker compose run --rm app php artisan key:generate

# Criar diretórios e permissões
mkdir -p storage/framework/{sessions,views,cache}
mkdir -p storage/logs bootstrap/cache
chown -R www-data:www-data storage bootstrap/cache
chmod -R 775 storage bootstrap/cache
```

---

## ✅ ETAPA 2: SUBIR CONTAINERS (5 minutos)

```bash
# No servidor: /var/www/freefi

# Build e subir containers
docker compose build
docker compose up -d

# Verificar se subiram
docker compose ps

# Deve mostrar:
# - freefi_admin-app-1     (running)
# - freefi_admin-db-1      (running/healthy)
# - freefi_admin-nginx-1   (running)
# - freefi_admin-phpmyadmin-1 (running)
```

---

## ✅ ETAPA 3: CONFIGURAR BANCO DE DADOS (2 minutos)

```bash
# No servidor: /var/www/freefi

# Rodar migrations
docker compose exec app php artisan migrate --force

# Criar link do storage
docker compose exec app php artisan storage:link

# (Opcional) Criar usuário admin seed
docker compose exec app php artisan db:seed --class=AdminUserSeeder --force
```

---

## ✅ ETAPA 4: TESTAR APLICAÇÃO (2 minutos)

```bash
# No servidor:
curl http://localhost:8082

# Do seu computador:
curl http://172.233.21.57:8082

# Ou abrir no navegador:
# http://172.233.21.57:8082
```

**Se funcionar, você verá a página inicial do FreeFi Admin!** ✅

---

## ✅ ETAPA 5: CONFIGURAR DEPLOY AUTOMÁTICO (Opcional)

Se quiser deploy automático via GitHub Actions:

### 5.1. Gerar chave SSH para deploy (no servidor)

```bash
# No servidor:
ssh-keygen -t rsa -b 4096 -C "deploy@freefi" -f ~/.ssh/freefi_deploy -N ""

# Adicionar ao authorized_keys
cat ~/.ssh/freefi_deploy.pub >> ~/.ssh/authorized_keys

# Copiar chave privada
cat ~/.ssh/freefi_deploy
# Copiar TODO o conteúdo (incluindo BEGIN e END)
```

### 5.2. Configurar Secrets no GitHub

Acesse: https://github.com/freefi-com-br/freefiadm/settings/secrets/actions

Adicione 6 secrets:

| Nome | Valor |
|------|-------|
| `SSH_HOST` | `172.233.21.57` |
| `SSH_USERNAME` | `root` |
| `SSH_PORT` | `22` |
| `SSH_PRIVATE_KEY` | [Conteúdo de ~/.ssh/freefi_deploy] |
| `PROJECT_PATH` | `/var/www/freefi` |
| `GH_PAT` | [GitHub Personal Access Token]* |

*Para criar GH_PAT:
1. GitHub > Settings > Developer settings > Personal access tokens > Tokens (classic)
2. Generate new token
3. Scopes: `repo` (all) + `write:packages` + `read:packages`
4. Copiar o token

### 5.3. Testar Deploy Automático

```bash
# No seu computador local:
cd /var/www/html/laravel/admin/freefi_admin

# Fazer qualquer mudança
echo "# Deploy teste" >> README.md

# Commitar e push
git add README.md
git commit -m "test: Deploy automático"
git push origin main
```

Acompanhe em: https://github.com/freefi-com-br/freefiadm/actions

---

## 📊 VERIFICAÇÕES PÓS-DEPLOY

### Containers rodando?
```bash
docker compose ps
# Todos devem estar "Up" ou "healthy"
```

### Rede correta?
```bash
docker network inspect root_mikrotik_net
# Deve listar os containers do freefi_admin
```

### Logs sem erros?
```bash
docker compose logs app
docker compose logs nginx
docker compose logs db
```

### Aplicação acessível?
```bash
# Teste local
curl -I http://localhost:8082

# Teste externo
curl -I http://172.233.21.57:8082

# Deve retornar: HTTP/1.1 200 OK
```

### Banco de dados funcionando?
```bash
docker compose exec app php artisan migrate:status
# Deve mostrar todas as migrations como "Ran"
```

### PhpMyAdmin acessível?
```bash
# Abrir no navegador:
# http://172.233.21.57:8081

# Login:
# Servidor: db
# Usuário: root
# Senha: [DB_ROOT_PASSWORD do .env]
```

---

## 🐛 TROUBLESHOOTING

### Containers não sobem

```bash
# Ver logs detalhados
docker compose logs

# Verificar portas em uso
netstat -tulpn | grep -E "8082|8081"

# Se porta ocupada, mudar no docker-compose.yml
```

### Erro de permissão

```bash
cd /var/www/freefi
chown -R www-data:www-data storage bootstrap/cache
chmod -R 775 storage bootstrap/cache
```

### Erro de conexão com banco

```bash
# Verificar se container db está rodando
docker compose ps db

# Ver logs do banco
docker compose logs db

# Verificar credenciais no .env
cat .env | grep DB_
```

### Erro 500 na aplicação

```bash
# Ver logs do Laravel
docker compose logs app

# Limpar caches
docker compose exec app php artisan cache:clear
docker compose exec app php artisan config:clear
docker compose exec app php artisan view:clear
```

### Rede root_mikrotik_net não existe

```bash
# Criar a rede
docker network create root_mikrotik_net

# Restart dos containers
docker compose down
docker compose up -d
```

---

## 🔄 COMANDOS ÚTEIS

### Reiniciar aplicação
```bash
cd /var/www/freefi
docker compose restart
```

### Rebuild completo
```bash
cd /var/www/freefi
docker compose down
docker compose build --no-cache
docker compose up -d
```

### Ver logs em tempo real
```bash
docker compose logs -f app
```

### Entrar no container para debug
```bash
docker compose exec app bash
```

### Backup do banco
```bash
docker compose exec db mysqldump -u root -p adm_freefi > backup_$(date +%Y%m%d).sql
```

### Atualizar código manualmente
```bash
cd /var/www/freefi
git pull origin main
docker compose restart
docker compose exec app php artisan migrate --force
docker compose exec app php artisan cache:clear
```

---

## ✅ CHECKLIST FINAL

Antes de considerar concluído:

- [ ] Containers todos rodando (docker compose ps)
- [ ] Aplicação acessível em http://172.233.21.57:8082
- [ ] Login funciona
- [ ] Página inicial carrega corretamente
- [ ] PhpMyAdmin acessível em http://172.233.21.57:8081
- [ ] Migrations rodaram sem erro
- [ ] Storage link criado
- [ ] Logs sem erros críticos
- [ ] .env configurado com credenciais SEGURAS (não as expostas!)
- [ ] APP_DEBUG=false no .env

---

## 🎯 DEPLOY ESTÁ PRONTO!

**Aplicação rodando em:** http://172.233.21.57:8082

**Próximos passos (opcional):**
1. Configurar domínio (freefi.seudominio.com.br)
2. Configurar SSL/HTTPS
3. Configurar backup automático
4. Implementar monitoramento

---

**Precisa de ajuda? Me chame!** 🤝
