# 📁 Flash - MikroTik Hotspot

Esta pasta centraliza **todos os arquivos, documentação e automação** relacionados ao hotspot do MikroTik.

---

## 📂 Estrutura de Diretórios

```
flash/
├── README.md                          # Este arquivo
├── hotspot/                           # 🎯 Arquivos do frontend do hotspot
│   ├── index.html                     # Página principal
│   ├── cadastro.html                  # Formulário de cadastro
│   ├── login.html                     # Página de login
│   ├── css/                           # Estilos
│   ├── js/                            # Scripts JavaScript
│   ├── img/                           # Imagens locais
│   └── ...
├── deploy/                            # 🚀 Scripts de deploy automatizado
│   ├── deploy-mikrotik-simple.sh     # ✅ Script principal (usar este)
│   ├── deploy-mikrotik-configured.sh # Versão com sshpass
│   └── deploy-mikrotik.sh            # Versão genérica
├── ATUALIZACOES-NECESSARIAS.md       # 📝 Log de alterações necessárias
├── RESUMO-ATUALIZACAO.md             # 📊 Resumo das atualizações feitas
├── DEPLOY-QUICKSTART.md              # 🚀 Guia rápido de deploy
└── DEPLOY-MIKROTIK-GUIDE.md          # 📖 Documentação completa de deploy
```

---

## 🎯 Arquivos Principais

### **Frontend do Hotspot**
📁 `hotspot/` - Contém todos os arquivos HTML/CSS/JS que rodam no MikroTik

**Última atualização:**
- `index.html` (linha 165) - Caminho das imagens atualizado para novo storage Laravel

### **Scripts de Deploy**
📁 `deploy/` - Automação para enviar atualizações ao MikroTik

**Como usar:**
```bash
cd flash/deploy
bash deploy-mikrotik-simple.sh
```

### **Documentação**
📄 Todos os arquivos `.md` nesta pasta explicam:
- ✅ O que foi alterado
- ✅ Como fazer deploy
- ✅ Como testar
- ✅ Como reverter (rollback)

---

## 🚀 Como Fazer Deploy

### **Método Rápido:**

```bash
# 1. Certifique-se que está conectado na VPN
ping 1.2.0.237

# 2. Entre na pasta de deploy
cd /var/www/html/laravel/admin/freefi_admin/flash/deploy

# 3. Execute o script
bash deploy-mikrotik-simple.sh

# 4. Informe a senha quando solicitado: Delta46.capiba2!
```

Mais detalhes: [`DEPLOY-QUICKSTART.md`](./DEPLOY-QUICKSTART.md)

---

## 📝 Histórico de Alterações

### **21/10/2025 - Modernização Backend**

**Backend:**
- ✅ Atualizado PHP 5.6 → PHP 8.3
- ✅ Container LAMP modernizado
- ✅ APIs conectando no banco Laravel MySQL 8.0

**Frontend (hotspot/):**
- ✅ Atualizado caminho das imagens:
  - ❌ Antigo: `http://172.233.21.57/adm/anexos/`
  - ✅ Novo: `http://172.233.21.57:8082/storage/`

**Arquivo alterado:**
- `hotspot/index.html` (linha 165)

**APIs Modernizadas:**
- ✅ `/splash/splash_api.php` - Busca publicações do banco Laravel
- ✅ `/splash/audit_splash.php` - Registra auditoria no banco Laravel

---

## 🔍 Configurações do Ambiente

### **MikroTik (via VPN)**
- **IP:** `1.2.0.237`
- **Usuário:** `admin`
- **Senha:** `Delta46.capiba2!`
- **Destino:** `/flash/hotspot/`

### **Servidor Laravel**
- **IP:** `172.233.21.57`
- **Porta Admin:** `8082`
- **Porta Splash (APIs):** `80`
- **Storage:** `8082/storage/`

### **APIs Antigas (Legadas)**
Ainda não migradas para Laravel:
- `/api/api.php` - Cadastro
- `/api/consulta.php` - Consulta CPF/CNPJ
- `/consulta.php` - Consulta MAC
- `/splash/tuso.php` - Termos de uso
- Porta `8080` - Sistema de assinatura

---

## 📋 Checklist de Validação

Após fazer deploy, verificar:

### No MikroTik:
- [ ] Arquivos foram transferidos (`ssh admin@1.2.0.237 "ls -lh /flash/hotspot/"`)
- [ ] Backup foi criado
- [ ] `index.html` contém código atualizado

### No Hotspot:
- [ ] Conectar no WiFi
- [ ] Página de login carrega
- [ ] Modal de publicidade funciona
- [ ] Imagens carregam do novo caminho

### No Servidor Laravel:
- [ ] Auditoria está sendo gravada (`auditoria_splash`)
- [ ] APIs splash retornam dados corretos

---

## 🆘 Problemas Comuns

### Deploy não funciona
```bash
# Verificar VPN
ping 1.2.0.237

# Testar SSH
ssh admin@1.2.0.237
```

### Imagens não carregam
- Verificar se o caminho está correto no `index.html`
- Deve ser: `http://172.233.21.57:8082/storage/`

### Rollback (Reverter)
```bash
ssh admin@1.2.0.237
ls /flash/hotspot_backup_*
tar -xzf /flash/hotspot_backup_YYYYMMDD_HHMMSS.tar.gz -C /flash
```

---

## 📚 Documentação Completa

- [`DEPLOY-QUICKSTART.md`](./DEPLOY-QUICKSTART.md) - Guia rápido
- [`DEPLOY-MIKROTIK-GUIDE.md`](./DEPLOY-MIKROTIK-GUIDE.md) - Guia completo
- [`ATUALIZACOES-NECESSARIAS.md`](./ATUALIZACOES-NECESSARIAS.md) - Detalhes técnicos
- [`RESUMO-ATUALIZACAO.md`](./RESUMO-ATUALIZACAO.md) - Resumo executivo

---

## 🔐 Segurança

⚠️ **Importante:**
- Arquivos com credenciais (`.env.deploy`) não devem ser versionados
- Use chave SSH ao invés de senha para deploy automático
- Mantenha backups regulares

---

## 📞 Suporte

Para questões sobre:
- **Deploy:** Ver `DEPLOY-MIKROTIK-GUIDE.md`
- **Frontend:** Ver `hotspot/` e arquivos HTML
- **APIs:** Ver documentação do Laravel

---

**Última atualização:** 21/10/2025
**Versão:** 1.0
**Status:** ✅ Operacional
