# 🚀 Script de Deploy - MikroTik Hotspot FreeFi

## 📋 Descrição

Script automatizado completo para deploy do hotspot FreeFi no MikroTik com logging avançado.

---

## ✨ Funcionalidades

- ✅ **Log Dual**: Arquivo local + mensagens no /log do MikroTik
- ✅ **Nome Inteligente**: `SERIAL_YYYYMMDD_HHMMSS.txt`
- ✅ **Registro Detalhado**: Cada arquivo transferido com status (sucesso/falha)
- ✅ **Backup Automático**: Cria backup antes de qualquer alteração
- ✅ **Validação Pós-Deploy**: Verifica se index.html foi atualizado corretamente
- ✅ **Estatísticas Completas**: Tempo total, arquivos, tamanho, erros
- ✅ **Tratamento de Erros**: Captura e registra falhas individuais

---

## 🎯 Uso

### **Pré-requisitos**

1. **VPN Conectada**: O MikroTik (1.2.0.237) só é acessível via VPN
2. **Expect Instalado**: `sudo apt-get install expect`
3. **Permissões**: Script deve estar executável

### **Comando Rápido**

```bash
cd /var/www/html/laravel/admin/freefi_admin/flash/deploy
expect deploy-production.expect
```

### **Verificar VPN antes do deploy**

```bash
ping -c 3 1.2.0.237
```

Se o ping falhar, conecte na VPN primeiro!

---

## 📊 Exemplo de Saída

```
═══════════════════════════════════════════════════════════════════════
  DEPLOY MIKROTIK HOTSPOT - FREEFI
═══════════════════════════════════════════════════════════════════════

🔍 Verificando conectividade com MikroTik...
✓ MikroTik online

📡 Obtendo serial do MikroTik...
✓ Serial do MikroTik: C45D4E7F8A2B

📝 Arquivo de log: C45D4E7F8A2B_20251021_203355.txt

[2025-10-21 20:33:56] 🔍 Verificando conectividade...
[2025-10-21 20:33:57] ✓ MikroTik online (ping OK)

[2025-10-21 20:33:58] 📤 Enviando mensagem de início para log do MikroTik...
[2025-10-21 20:33:59] ✓ Mensagem registrada no /log do MikroTik

[2025-10-21 20:34:00] 💾 Criando backup do hotspot atual...
[2025-10-21 20:34:05] ✓ Backup criado: hotspot_backup_20251021_203400.tar.gz

[2025-10-21 20:34:06] 🗑️  Limpando diretório de destino...
[2025-10-21 20:34:08] ✓ Diretório /flash/hotspot limpo e recriado

[2025-10-21 20:34:09] 📦 Iniciando transferência de arquivos...

[2025-10-21 20:34:10] ✓ index.html (12KB) - OK
[2025-10-21 20:34:11] ✓ cadastro.html (17KB) - OK
[2025-10-21 20:34:12] ✓ login.html (5KB) - OK
...
[2025-10-21 20:36:15] ✓ js/jquery.min.js (85KB) - OK

[2025-10-21 20:36:16] ✓ Transferência concluída

[2025-10-21 20:36:17] 🔍 Executando validações...

[2025-10-21 20:36:18] ✓ index.html contém '8082/storage' (linha 165)
[2025-10-21 20:36:19] ✓ Total de arquivos no destino: 191

[2025-10-21 20:36:20] 📤 Enviando mensagem de conclusão para log do MikroTik...
[2025-10-21 20:36:21] ✓ Mensagem registrada no /log do MikroTik

═══════════════════════════════════════════════════════════════════════
RESUMO DO DEPLOY
═══════════════════════════════════════════════════════════════════════
Data/Hora Início: 2025-10-21 20:33:55
Data/Hora Fim: 2025-10-21 20:36:21
Tempo Total: 00:02:26
Total de Arquivos: 191
Arquivos com Sucesso: 191
Arquivos com Falha: 0
Tamanho Total: 2.48 MB
Validação index.html: ✓ OK
Status Final: SUCESSO
═══════════════════════════════════════════════════════════════════════

═══════════════════════════════════════════════════════════════════════
  DEPLOY CONCLUÍDO!
═══════════════════════════════════════════════════════════════════════

📊 Resumo:
   • Tempo Total: 00:02:26
   • Arquivos: 191 OK / 0 falhas
   • Tamanho: 2.48 MB
   • Status: SUCESSO

📝 Log completo salvo em: C45D4E7F8A2B_20251021_203355.txt
📋 Log no MikroTik: /log print where message~"DEPLOY"

═══════════════════════════════════════════════════════════════════════
```

---

## 📝 Arquivo de Log Gerado

### **Nomenclatura**
```
SERIAL_YYYYMMDD_HHMMSS.txt
```

**Exemplo:**
```
C45D4E7F8A2B_20251021_203355.txt
```

### **Conteúdo do Log**

O arquivo de log contém:
- ✅ Cabeçalho com informações do deploy
- ✅ Timestamp de cada operação
- ✅ Lista completa de arquivos transferidos
- ✅ Status individual de cada arquivo (✓ OK ou ✗ FALHOU)
- ✅ Resultado das validações
- ✅ Resumo final com estatísticas

### **Exemplo de Log com Falha**

```
[2025-10-21 20:35:45] ✓ img/logo.png (17KB) - OK
[2025-10-21 20:35:46] ✗ img/banner.jpg - FALHOU (timeout)
[2025-10-21 20:35:47] ✓ js/jquery.min.js (85KB) - OK

...

RESUMO DO DEPLOY
===============================================================================
...
Arquivos com Falha: 1
Arquivos Falhados:
  - img/banner.jpg (timeout)
...
Status Final: SUCESSO (com avisos)
```

---

## 📋 Logs no MikroTik

O script registra 2 mensagens no `/log` do MikroTik:

### **1. Início do Deploy**
```
DEPLOY INICIADO - FreeFi Hotspot - 2025-10-21 20:33:55
```

### **2. Fim do Deploy**
```
DEPLOY CONCLUÍDO - Status: SUCESSO - Tempo: 00:02:26 - Arquivos: 191 OK / 0 falhas
```

### **Como visualizar no MikroTik**

```bash
# SSH no MikroTik
ssh admin@1.2.0.237

# Filtrar logs de deploy
/log print where message~"DEPLOY"
```

---

## 🔍 Validações Executadas

1. **Conectividade**: Ping no MikroTik antes de iniciar
2. **Serial**: Obtém serial do equipamento via SSH
3. **Backup**: Verifica criação do backup antes de limpar
4. **Conteúdo**: Valida linha 165 do index.html (8082/storage)
5. **Arquivos**: Conta total de arquivos transferidos

---

## 🎯 Status do Deploy

O script pode retornar 3 status:

| Status | Descrição |
|--------|-----------|
| **SUCESSO** | Todos os arquivos transferidos com sucesso, validações OK |
| **SUCESSO (com avisos)** | Deploy concluído mas alguns arquivos falharam |
| **ERRO** | Validação crítica falhou (ex: index.html não atualizado) |

---

## 🆘 Troubleshooting

### **Problema: VPN não conectada**
```
✗ ERRO: MikroTik não responde ao ping
  Verifique se a VPN está conectada
```
**Solução:** Conecte na VPN antes de executar

---

### **Problema: Timeout ao obter serial**
```
⚠ Timeout ao conectar via SSH
✓ Serial do MikroTik: 1_2_0_237
```
**Solução:** Script continua usando IP como serial (funciona normalmente)

---

### **Problema: Arquivo não transferido**
```
[2025-10-21 20:35:46] ✗ img/banner.jpg - FALHOU (timeout)
```
**Solução:** Executar deploy novamente ou transferir arquivo manualmente

---

### **Problema: Validação falhou**
```
[2025-10-21 20:36:18] ✗ ERRO: index.html NÃO contém '8082/storage'
Status Final: ERRO
```
**Solução:** Verificar se `flash/hotspot/index.html` está correto localmente

---

## 🔄 Rollback (Reverter Deploy)

Se algo der errado, você pode restaurar o backup:

```bash
# SSH no MikroTik
ssh admin@1.2.0.237

# Listar backups disponíveis
ls -lh /flash/hotspot_backup_*.tar.gz

# Restaurar backup específico (substitua a data)
tar -xzf /flash/hotspot_backup_20251021_203400.tar.gz -C /flash

# Verificar restauração
ls -lh /flash/hotspot/
```

---

## 📚 Comparação com Scripts Antigos

| Recurso | upload.sh (antigo) | deploy-production.expect (novo) |
|---------|-------------------|--------------------------------|
| Log local | ✅ upload.txt | ✅ SERIAL_DATA.txt |
| Log no MikroTik | ❌ | ✅ /log info |
| Serial no nome | ❌ | ✅ |
| Validação pós-deploy | ❌ | ✅ |
| Tratamento de erros | Parcial | ✅ Completo |
| Estatísticas | Básicas | ✅ Avançadas |

---

## 🎓 Detalhes Técnicos

### **Tecnologias**
- **Expect**: Automação de interação SSH/SCP
- **SCP**: Transferência de arquivos
- **SFTP**: Manipulação de diretórios
- **SSH**: Execução de comandos remotos

### **Fluxo de Execução**
1. Ping → Conectividade
2. SSH → Obter serial
3. Criar log local
4. SSH → Enviar log início no MikroTik
5. SSH → Criar backup
6. SFTP → Limpar /flash/hotspot
7. SCP → Upload recursivo
8. SSH → Validar index.html
9. SSH → Contar arquivos
10. SSH → Enviar log fim no MikroTik
11. Escrever resumo no log local

---

## 📞 Suporte

- **Documentação Completa**: Ver `../DEPLOY-MIKROTIK-GUIDE.md`
- **Guia Rápido**: Ver `../DEPLOY-QUICKSTART.md`
- **Logs de Alterações**: Ver `../ATUALIZACOES-NECESSARIAS.md`

---

**Última atualização:** 21/10/2025
**Versão:** 2.0
**Status:** ✅ Pronto para produção
