#!/bin/bash

###############################################################################
# Script de Deploy com Debug Completo - MikroTik Hotspot
# Usa sshpass para automação
# Uso: bash deploy-debug.sh
###############################################################################

set -e

# Cores
RED='\033[0;31m'
GREEN='\033[0;32m'
YELLOW='\033[1;33m'
BLUE='\033[0;34m'
CYAN='\033[0;36m'
NC='\033[0m'

# Configurações
MIKROTIK_IP="1.2.0.237"
MIKROTIK_USER="admin"
MIKROTIK_PASSWORD="Delta46.capiba2!"
MIKROTIK_DEST="flash/hotspot"
LOCAL_DIR="../hotspot"

# Criar arquivo de log
TIMESTAMP=$(date +%Y%m%d_%H%M%S)
LOGFILE="deploy_log_${TIMESTAMP}.txt"

echo -e "${BLUE}╔════════════════════════════════════════════════════════════════════╗${NC}"
echo -e "${BLUE}║  DEPLOY MIKROTIK - FREEFI HOTSPOT (AUTOMATIZADO + DEBUG)          ║${NC}"
echo -e "${BLUE}╚════════════════════════════════════════════════════════════════════╝${NC}"
echo ""
echo "📝 Log será salvo em: $LOGFILE"
echo ""

# Iniciar log
echo "=== DEPLOY MIKROTIK HOTSPOT - $TIMESTAMP ===" > "$LOGFILE"
echo "" >> "$LOGFILE"

# Teste de conectividade
echo -e "${CYAN}[1/7]${NC} Testando conexão com MikroTik..."
echo "[1/7] Testando conexão..." >> "$LOGFILE"
if ping -c 1 -W 2 $MIKROTIK_IP &>/dev/null; then
    echo -e "${GREEN}✓${NC} MikroTik acessível via VPN"
    echo "OK: MikroTik acessível" >> "$LOGFILE"
else
    echo -e "${RED}✗${NC} MikroTik não responde ao ping"
    echo "ERRO: MikroTik não responde ao ping" >> "$LOGFILE"
    exit 1
fi
echo "" >> "$LOGFILE"
echo ""

# DEBUG: Estado ANTES do deploy
echo -e "${CYAN}[2/7]${NC} 🔍 DEBUG - Estado ANTES do deploy..."
echo "[2/7] === ESTADO ANTES DO DEPLOY ===" >> "$LOGFILE"

echo -e "${YELLOW}📁 Arquivos atuais (últimos 10):${NC}"
sshpass -p "$MIKROTIK_PASSWORD" ssh -o StrictHostKeyChecking=no $MIKROTIK_USER@$MIKROTIK_IP "ls -l /flash/hotspot/" | head -15 | tee -a "$LOGFILE"
echo ""

echo -e "${YELLOW}🔢 Total de arquivos:${NC}"
TOTAL_BEFORE=$(sshpass -p "$MIKROTIK_PASSWORD" ssh -o StrictHostKeyChecking=no $MIKROTIK_USER@$MIKROTIK_IP "ls -R /flash/hotspot/ 2>/dev/null | grep -v '^$' | grep -v ':$' | wc -l")
echo "Total de arquivos ANTES: $TOTAL_BEFORE" | tee -a "$LOGFILE"
echo ""

echo -e "${YELLOW}📄 Verificando index.html atual:${NC}"
sshpass -p "$MIKROTIK_PASSWORD" ssh -o StrictHostKeyChecking=no $MIKROTIK_USER@$MIKROTIK_IP "ls -l /flash/hotspot/index.html 2>/dev/null" | tee -a "$LOGFILE"
echo ""
echo "" >> "$LOGFILE"

# Criar backup
echo -e "${CYAN}[3/7]${NC} Criando backup no MikroTik..."
echo "[3/7] Criando backup..." >> "$LOGFILE"

BACKUP_CMD='BACKUP_NAME="hotspot_backup_$(date +%Y%m%d_%H%M%S)" && tar -czf "/flash/${BACKUP_NAME}.tar.gz" -C /flash hotspot 2>/dev/null && echo "✓ Backup criado: ${BACKUP_NAME}.tar.gz" || echo "⚠ Sem backup anterior"'
sshpass -p "$MIKROTIK_PASSWORD" ssh -o StrictHostKeyChecking=no $MIKROTIK_USER@$MIKROTIK_IP "$BACKUP_CMD" | tee -a "$LOGFILE"

echo -e "${GREEN}✓${NC} Backup criado"
echo "" >> "$LOGFILE"
echo ""

# Transferir arquivos
echo -e "${CYAN}[4/7]${NC} Transferindo arquivos..."
echo "[4/7] Transferindo arquivos via rsync..." >> "$LOGFILE"
echo "" >> "$LOGFILE"

sshpass -p "$MIKROTIK_PASSWORD" rsync -avz --progress \
    --exclude="*.md" \
    --exclude="*.backup" \
    --exclude=".git" \
    --exclude="_errors.txt" \
    --exclude="*.log" \
    -e "ssh -o StrictHostKeyChecking=no" \
    "$LOCAL_DIR/" "$MIKROTIK_USER@$MIKROTIK_IP:/$MIKROTIK_DEST/"

if [ $? -eq 0 ]; then
    echo -e "${GREEN}✓${NC} Arquivos transferidos com sucesso"
    echo "OK: Arquivos transferidos com sucesso" >> "$LOGFILE"
else
    echo -e "${RED}✗${NC} Erro na transferência"
    echo "ERRO: Falha na transferência de arquivos" >> "$LOGFILE"
    exit 1
fi
echo "" >> "$LOGFILE"
echo ""

# DEBUG: Estado DEPOIS do deploy
echo -e "${CYAN}[5/7]${NC} 🔍 DEBUG - Estado DEPOIS do deploy..."
echo "[5/7] === ESTADO DEPOIS DO DEPLOY ===" >> "$LOGFILE"

echo -e "${YELLOW}📊 Espaço em disco:${NC}"
sshpass -p "$MIKROTIK_PASSWORD" ssh -o StrictHostKeyChecking=no $MIKROTIK_USER@$MIKROTIK_IP "df -h /flash" | tee -a "$LOGFILE"
echo ""

echo -e "${YELLOW}📁 Arquivos atualizados (últimos 10):${NC}"
sshpass -p "$MIKROTIK_PASSWORD" ssh -o StrictHostKeyChecking=no $MIKROTIK_USER@$MIKROTIK_IP "ls -lht /flash/hotspot/ | head -10" | tee -a "$LOGFILE"
echo ""

echo -e "${YELLOW}🔢 Total de arquivos:${NC}"
TOTAL_AFTER=$(sshpass -p "$MIKROTIK_PASSWORD" ssh -o StrictHostKeyChecking=no $MIKROTIK_USER@$MIKROTIK_IP "find /flash/hotspot -type f 2>/dev/null | wc -l")
echo "Total de arquivos DEPOIS: $TOTAL_AFTER" | tee -a "$LOGFILE"
echo "Diferença: $((TOTAL_AFTER - TOTAL_BEFORE)) arquivos" | tee -a "$LOGFILE"
echo ""

echo -e "${YELLOW}📄 Conteúdo linha 165 index.html (DEPOIS):${NC}"
sshpass -p "$MIKROTIK_PASSWORD" ssh -o StrictHostKeyChecking=no $MIKROTIK_USER@$MIKROTIK_IP "sed -n '165p' /flash/hotspot/index.html" | tee -a "$LOGFILE"
echo ""
echo "" >> "$LOGFILE"

# Validar deploy
echo -e "${CYAN}[6/7]${NC} Validando deploy..."
echo "[6/7] Validando deploy..." >> "$LOGFILE"

if sshpass -p "$MIKROTIK_PASSWORD" ssh -o StrictHostKeyChecking=no $MIKROTIK_USER@$MIKROTIK_IP "grep -q '8082/storage' /flash/hotspot/index.html"; then
    echo -e "${GREEN}✓${NC} Arquivo index.html atualizado corretamente!"
    echo "OK: Validação passou - index.html contém '8082/storage'" >> "$LOGFILE"
else
    echo -e "${RED}✗${NC} Validação falhou"
    echo "ERRO: Validação falhou - index.html NÃO contém '8082/storage'" >> "$LOGFILE"
fi
echo "" >> "$LOGFILE"
echo ""

# Listar backups criados
echo -e "${CYAN}[7/7]${NC} Listando backups disponíveis..."
echo "[7/7] Backups disponíveis para rollback:" >> "$LOGFILE"
sshpass -p "$MIKROTIK_PASSWORD" ssh -o StrictHostKeyChecking=no $MIKROTIK_USER@$MIKROTIK_IP "ls -lh /flash/hotspot_backup_*.tar.gz 2>/dev/null | tail -5" | tee -a "$LOGFILE"
echo ""

# Finalizar log
echo "" >> "$LOGFILE"
echo "=== FIM DO DEPLOY ===" >> "$LOGFILE"

echo -e "${GREEN}╔════════════════════════════════════════════════════════════════════╗${NC}"
echo -e "${GREEN}║  DEPLOY CONCLUÍDO!                                                 ║${NC}"
echo -e "${GREEN}╚════════════════════════════════════════════════════════════════════╝${NC}"
echo ""
echo -e "${CYAN}📝 Log completo salvo em:${NC} $LOGFILE"
echo -e "${CYAN}📊 Arquivos transferidos:${NC} $TOTAL_AFTER arquivos"
echo -e "${CYAN}🗓️  Data:${NC} $(date '+%Y-%m-%d %H:%M:%S')"
echo ""
