#!/bin/bash

###############################################################################
# Script de Deploy Simples - MikroTik Hotspot
# MikroTik IP: 1.2.0.237 (via VPN)
# Uso: bash deploy-mikrotik-simple.sh
###############################################################################

set -e

# Cores
GREEN='\033[0;32m'
YELLOW='\033[1;33m'
BLUE='\033[0;34m'
CYAN='\033[0;36m'
NC='\033[0m'

# Configurações
MIKROTIK_IP="1.2.0.237"
MIKROTIK_USER="admin"
MIKROTIK_DEST="flash/hotspot"
LOCAL_DIR="../hotspot"  # Relativo à pasta flash/deploy/

echo -e "${BLUE}╔════════════════════════════════════════════════════════════════════╗${NC}"
echo -e "${BLUE}║  DEPLOY MIKROTIK - FREEFI HOTSPOT                                 ║${NC}"
echo -e "${BLUE}╚════════════════════════════════════════════════════════════════════╝${NC}"
echo ""

# Verificar se diretório local existe
if [ ! -d "$LOCAL_DIR" ]; then
    echo -e "${YELLOW}Erro: Diretório $LOCAL_DIR não encontrado!${NC}"
    echo "Execute este script do diretório raiz do projeto"
    exit 1
fi

echo -e "${CYAN}[1/5]${NC} Testando conexão com MikroTik..."
if ping -c 1 -W 2 $MIKROTIK_IP &>/dev/null; then
    echo -e "${GREEN}✓${NC} MikroTik acessível via VPN"
else
    echo -e "${YELLOW}✗${NC} MikroTik não responde ao ping"
    echo "Verifique se a VPN está conectada"
    exit 1
fi

echo ""
echo -e "${CYAN}[2/5]${NC} Arquivos que serão enviados:"
echo ""
find "$LOCAL_DIR" -type f -name "*.html" -o -name "*.css" -o -name "*.js" | head -10 | while read file; do
    rel_path="${file#$LOCAL_DIR/}"
    echo "  📄 $rel_path"
done
echo "  ... e outros"
echo ""

echo -e "${YELLOW}════════════════════════════════════════════════════════════════════${NC}"
echo -e "${YELLOW}  Destino: $MIKROTIK_USER@$MIKROTIK_IP:/$MIKROTIK_DEST${NC}"
echo -e "${YELLOW}  Total de arquivos: $(find "$LOCAL_DIR" -type f | wc -l)${NC}"
echo -e "${YELLOW}════════════════════════════════════════════════════════════════════${NC}"
echo ""

read -p "Deseja continuar com o deploy? (s/n): " -n 1 -r
echo
if [[ ! $REPLY =~ ^[Ss]$ ]]; then
    echo "Deploy cancelado"
    exit 0
fi

echo ""
echo -e "${CYAN}[3/5]${NC} Criando backup no MikroTik..."
echo "Senha: Delta46.capiba2!"
echo ""

ssh -o StrictHostKeyChecking=no "$MIKROTIK_USER@$MIKROTIK_IP" << 'EOF'
    BACKUP_NAME="hotspot_backup_$(date +%Y%m%d_%H%M%S)"

    if [ -d "/flash/hotspot" ]; then
        tar -czf "/flash/${BACKUP_NAME}.tar.gz" -C /flash hotspot 2>/dev/null && \
        echo "✓ Backup criado: /flash/${BACKUP_NAME}.tar.gz" || \
        echo "⚠ Não foi possível criar backup (continuando...)"
    else
        echo "⚠ Diretório /flash/hotspot não existe, será criado"
        mkdir -p /flash/hotspot
    fi
EOF

echo ""
echo -e "${CYAN}[4/5]${NC} Transferindo arquivos..."
echo "Usando rsync (será solicitada a senha novamente)..."
echo ""

if command -v rsync &> /dev/null; then
    rsync -avz --progress \
        --exclude="*.md" \
        --exclude="*.backup" \
        --exclude=".git" \
        --exclude="_errors.txt" \
        --exclude="*.log" \
        -e "ssh -o StrictHostKeyChecking=no" \
        "$LOCAL_DIR/" "$MIKROTIK_USER@$MIKROTIK_IP:/$MIKROTIK_DEST/"
else
    echo "rsync não encontrado, usando scp..."
    scp -r -o StrictHostKeyChecking=no "$LOCAL_DIR"/* "$MIKROTIK_USER@$MIKROTIK_IP:/$MIKROTIK_DEST/"
fi

if [ $? -eq 0 ]; then
    echo -e "${GREEN}✓ Arquivos transferidos com sucesso!${NC}"
else
    echo -e "${YELLOW}✗ Houve problemas na transferência${NC}"
    exit 1
fi

echo ""
echo -e "${CYAN}[5/5]${NC} Verificando deployment..."
echo ""

ssh -o StrictHostKeyChecking=no "$MIKROTIK_USER@$MIKROTIK_IP" << 'EOF'
    if [ -f "/flash/hotspot/index.html" ]; then
        if grep -q "8082/storage" "/flash/hotspot/index.html"; then
            echo "✓ Arquivo index.html atualizado corretamente!"
        else
            echo "⚠ Arquivo transferido mas pode estar com código antigo"
        fi
    else
        echo "✗ Arquivo index.html não encontrado!"
    fi

    echo ""
    echo "Arquivos no MikroTik:"
    ls -lh /flash/hotspot/*.html 2>/dev/null | awk '{print "  ", $9, "-", $5}'
EOF

echo ""
echo -e "${GREEN}╔════════════════════════════════════════════════════════════════════╗${NC}"
echo -e "${GREEN}║  DEPLOY CONCLUÍDO!                                                 ║${NC}"
echo -e "${GREEN}╚════════════════════════════════════════════════════════════════════╝${NC}"
echo ""
echo -e "${CYAN}Servidor:${NC} $MIKROTIK_IP"
echo -e "${CYAN}Data:${NC} $(date '+%Y-%m-%d %H:%M:%S')"
echo ""
echo -e "${YELLOW}Próximos passos:${NC}"
echo "  1. Teste o hotspot conectando na rede WiFi do MikroTik"
echo "  2. Verifique se as imagens de publicidade carregam"
echo "  3. Confirme se está usando o caminho novo: http://172.233.21.57:8082/storage/"
echo ""
