<div class="row">
    <!-- Hotspot -->
    @if(!isset($customization))
    <div class="col-md-12 mb-3">
        <label for="hotspot_id" class="form-label">Hotspot *</label>
        <select name="hotspot_id" id="hotspot_id" class="form-select @error('hotspot_id') is-invalid @enderror" required>
            <option value="">Selecione um hotspot</option>
            @foreach($hotspots as $hotspot)
                <option value="{{ $hotspot->id }}" {{ old('hotspot_id') == $hotspot->id ? 'selected' : '' }}>
                    {{ $hotspot->serial }} @if($hotspot->nome) - {{ $hotspot->nome }} @endif
                </option>
            @endforeach
        </select>
        @error('hotspot_id')<div class="invalid-feedback">{{ $message }}</div>@enderror
    </div>
    @else
    <div class="col-md-12 mb-3">
        <label class="form-label">Hotspot</label>
        <input type="text" class="form-control" value="{{ $customization->hotspot->serial }}" disabled>
    </div>
    @endif

    <!-- Marca -->
    <div class="col-md-6 mb-3">
        <label for="brand_name" class="form-label">Nome da Marca</label>
        <input type="text" name="brand_name" id="brand_name"
               class="form-control @error('brand_name') is-invalid @enderror"
               value="{{ old('brand_name', $customization->brand_name ?? 'freefi.com.br') }}">
        @error('brand_name')<div class="invalid-feedback">{{ $message }}</div>@enderror
    </div>

    <!-- Logo URL -->
    <div class="col-md-6 mb-3">
        <label for="logo_url" class="form-label">URL do Logo</label>
        <input type="text" name="logo_url" id="logo_url"
               class="form-control @error('logo_url') is-invalid @enderror"
               value="{{ old('logo_url', $customization->logo_url ?? 'img/logo.png') }}">
        @error('logo_url')<div class="invalid-feedback">{{ $message }}</div>@enderror
    </div>

    <!-- Welcome Title -->
    <div class="col-md-12 mb-3">
        <label for="welcome_title" class="form-label">Título de Boas-Vindas</label>
        <input type="text" name="welcome_title" id="welcome_title"
               class="form-control @error('welcome_title') is-invalid @enderror"
               value="{{ old('welcome_title', $customization->welcome_title ?? 'Bem-vindo ao WiFi Gratuito') }}">
        @error('welcome_title')<div class="invalid-feedback">{{ $message }}</div>@enderror
    </div>

    <!-- Cores -->
    <div class="col-md-3 mb-3">
        <label for="primary_color" class="form-label">Cor Primária</label>
        <input type="color" name="primary_color" id="primary_color"
               class="form-control form-control-color"
               value="{{ old('primary_color', $customization->primary_color ?? '#3e4d59') }}">
    </div>

    <div class="col-md-3 mb-3">
        <label for="primary_hover_color" class="form-label">Cor Hover</label>
        <input type="color" name="primary_hover_color" id="primary_hover_color"
               class="form-control form-control-color"
               value="{{ old('primary_hover_color', $customization->primary_hover_color ?? '#36434e') }}">
    </div>

    <!-- Tempos -->
    <div class="col-md-3 mb-3">
        <label for="modal_countdown_seconds" class="form-label">Contagem Regressiva (s)</label>
        <input type="number" name="modal_countdown_seconds" id="modal_countdown_seconds"
               class="form-control"
               value="{{ old('modal_countdown_seconds', $customization->modal_countdown_seconds ?? 10) }}"
               min="1" max="60">
    </div>

    <div class="col-md-3 mb-3">
        <label for="banner_rotation_seconds" class="form-label">Rotação Banner (s)</label>
        <input type="number" name="banner_rotation_seconds" id="banner_rotation_seconds"
               class="form-control"
               value="{{ old('banner_rotation_seconds', $customization->banner_rotation_seconds ?? 6) }}"
               min="1" max="60">
    </div>

    <!-- Opções Booleanas -->
    <div class="col-md-12 mb-3">
        <div class="form-check form-switch">
            <input type="hidden" name="enable_advertisement" value="0">
            <input type="checkbox" name="enable_advertisement" value="1"
                   class="form-check-input" id="enable_advertisement"
                   {{ old('enable_advertisement', $customization->enable_advertisement ?? true) ? 'checked' : '' }}>
            <label class="form-check-label" for="enable_advertisement">Habilitar Propagandas</label>
        </div>
    </div>

    <div class="col-md-12 mb-3">
        <div class="form-check form-switch">
            <input type="hidden" name="is_active" value="0">
            <input type="checkbox" name="is_active" value="1"
                   class="form-check-input" id="is_active"
                   {{ old('is_active', $customization->is_active ?? true) ? 'checked' : '' }}>
            <label class="form-check-label" for="is_active">Personalização Ativa</label>
        </div>
    </div>

    <!-- CSS Customizado -->
    <div class="col-md-6 mb-3">
        <label for="custom_css" class="form-label">CSS Customizado</label>
        <textarea name="custom_css" id="custom_css" rows="5"
                  class="form-control font-monospace"
                  placeholder="/* Seu CSS customizado aqui */">{{ old('custom_css', $customization->custom_css ?? '') }}</textarea>
    </div>

    <!-- JS Customizado -->
    <div class="col-md-6 mb-3">
        <label for="custom_js" class="form-label">JavaScript Customizado</label>
        <textarea name="custom_js" id="custom_js" rows="5"
                  class="form-control font-monospace"
                  placeholder="// Seu JavaScript customizado aqui">{{ old('custom_js', $customization->custom_js ?? '') }}</textarea>
    </div>
</div>
