<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Novo Cadastro Pendente</title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #f4f7fa;
            margin: 0;
            padding: 0;
        }
        .email-container {
            max-width: 600px;
            margin: 40px auto;
            background-color: #ffffff;
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 4px 12px rgba(0,0,0,0.1);
        }
        .email-header {
            background: linear-gradient(135deg, #ffc107 0%, #ff9800 100%);
            padding: 40px 30px;
            text-align: center;
            color: #ffffff;
        }
        .email-header h1 {
            margin: 0;
            font-size: 28px;
            font-weight: 600;
        }
        .email-header .icon {
            font-size: 64px;
            margin-bottom: 10px;
        }
        .email-body {
            padding: 40px 30px;
            color: #333333;
            line-height: 1.8;
        }
        .email-body h2 {
            color: #ff9800;
            font-size: 22px;
            margin-top: 0;
            margin-bottom: 20px;
        }
        .info-box {
            background-color: #fff8e1;
            border-left: 4px solid #ffc107;
            padding: 20px;
            margin: 25px 0;
            border-radius: 4px;
        }
        .info-box p {
            margin: 8px 0;
            font-size: 14px;
            color: #5d4037;
        }
        .info-box strong {
            color: #bf360c;
            font-weight: 600;
        }
        .badge {
            display: inline-block;
            padding: 4px 10px;
            border-radius: 4px;
            font-size: 12px;
            font-weight: 600;
            text-transform: uppercase;
        }
        .badge-matriz {
            background-color: #0d6efd;
            color: white;
        }
        .badge-franquia {
            background-color: #0dcaf0;
            color: white;
        }
        .badge-cliente {
            background-color: #6c757d;
            color: white;
        }
        .cta-button {
            display: inline-block;
            background: linear-gradient(135deg, #ffc107 0%, #ff9800 100%);
            color: #ffffff;
            padding: 14px 32px;
            text-decoration: none;
            border-radius: 6px;
            font-weight: 600;
            font-size: 16px;
            margin: 20px 0;
            transition: transform 0.2s;
        }
        .cta-button:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(255, 193, 7, 0.4);
        }
        .email-footer {
            background-color: #f8f9fa;
            padding: 30px;
            text-align: center;
            color: #6c757d;
            font-size: 14px;
            border-top: 1px solid #dee2e6;
        }
        .email-footer p {
            margin: 8px 0;
        }
        .divider {
            height: 1px;
            background-color: #dee2e6;
            margin: 30px 0;
        }
        .urgent-badge {
            background-color: #dc3545;
            color: white;
            padding: 8px 16px;
            border-radius: 20px;
            font-size: 13px;
            font-weight: 600;
            display: inline-block;
            margin-bottom: 20px;
        }
        @media only screen and (max-width: 600px) {
            .email-container {
                margin: 20px;
            }
            .email-header, .email-body {
                padding: 30px 20px;
            }
            .email-header h1 {
                font-size: 24px;
            }
        }
    </style>
</head>
<body>
    <div class="email-container">
        <!-- Header -->
        <div class="email-header">
            <div class="icon">🔔</div>
            <h1>Novo Cadastro Aguardando Aprovação</h1>
        </div>

        <!-- Body -->
        <div class="email-body">
            <center>
                <span class="urgent-badge">⚠️ REQUER AÇÃO IMEDIATA</span>
            </center>

            <h2>Olá, Administrador!</h2>
            
            <p>
                Um novo usuário realizou cadastro no sistema FreeFi Admin e está 
                <strong>aguardando aprovação</strong> para ter acesso ao sistema.
            </p>

            <div class="info-box">
                <p><strong>👤 Nome:</strong> {{ $userName }}</p>
                <p><strong>📧 E-mail:</strong> {{ $userEmail }}</p>
                <p><strong>🏢 Empresa:</strong> {{ $empresaNome }}</p>
                <p>
                    <strong>📂 Tipo:</strong> 
                    @if($empresaTipo === 'matriz')
                        <span class="badge badge-matriz">👑 Matriz</span>
                    @elseif($empresaTipo === 'franquia')
                        <span class="badge badge-franquia">🏢 Franquia</span>
                    @else
                        <span class="badge badge-cliente">🏪 Cliente</span>
                    @endif
                </p>
                <p><strong>📱 Telefone:</strong> {{ $telefone }}</p>
                <p><strong>📅 Data do Cadastro:</strong> {{ $dataCadastro }}</p>
                <p><strong>⏳ Status:</strong> <span style="color: #ff9800; font-weight: 600;">Pendente</span></p>
            </div>

            <div class="divider"></div>

            <p>
                Para aprovar ou rejeitar este cadastro, acesse o painel de gerenciamento 
                de usuários no sistema:
            </p>

            <center>
                <a href="{{ $usersUrl }}" class="cta-button">
                    Gerenciar Cadastro
                </a>
            </center>

            <p style="color: #6c757d; font-size: 14px; margin-top: 30px;">
                <strong>⚡ Ação Necessária:</strong><br>
                • Revisar os dados do novo usuário<br>
                • Verificar a empresa vinculada<br>
                • Aprovar ou rejeitar o cadastro<br>
                • O usuário receberá um e-mail com a decisão
            </p>
        </div>

        <!-- Footer -->
        <div class="email-footer">
            <p><strong>FreeFi Admin</strong></p>
            <p>Sistema de Gerenciamento de Franquias</p>
            <p style="margin-top: 20px; font-size: 12px; color: #868e96;">
                Este é um e-mail automático, por favor não responda.<br>
                Enviado automaticamente quando um novo cadastro é realizado.
            </p>
        </div>
    </div>
</body>
</html>
