@extends('layouts.master')
@section('title', 'Dashboard de Estatísticas')

@push('styles')
<style>
.stat-card {
    border-left: 4px solid;
    transition: transform 0.2s, box-shadow 0.2s;
}
.stat-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 20px rgba(0,0,0,0.1);
}
.stat-card.primary { border-left-color: #4680ff; }
.stat-card.success { border-left-color: #2ed8b6; }
.stat-card.warning { border-left-color: #ffb64d; }
.stat-card.danger { border-left-color: #ff5370; }
.stat-card.info { border-left-color: #00bcd4; }
.stat-card.purple { border-left-color: #a389d4; }

.chart-container {
    position: relative;
    height: 350px;
}

.ranking-item {
    transition: all 0.2s;
}
.ranking-item:hover {
    background-color: #f8f9fa;
    transform: translateX(5px);
}
</style>
@endpush

@section('main-content')
    <div class="container-fluid">
        <!-- Breadcrumb -->
        <div class="row m-1">
            <div class="col-12">
                <h5><i class="ph-duotone ph-chart-bar f-s-16 me-2"></i>Dashboard de Estatísticas</h5>
                <ul class="app-line-breadcrumbs mb-3">
                    <li class="active">
                        <a href="#" class="f-s-14 f-w-500">Estatísticas Gerais</a>
                    </li>
                </ul>
            </div>
        </div>

        <!-- Filtros -->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <form method="GET" action="{{ route('estatisticas.dashboard') }}" class="row g-3">
                            <div class="col-md-3">
                                <label class="form-label">Data Início</label>
                                <input type="date" 
                                       name="data_inicio" 
                                       class="form-control" 
                                       value="{{ request('data_inicio', now()->subDays(30)->format('Y-m-d')) }}">
                            </div>
                            <div class="col-md-3">
                                <label class="form-label">Data Fim</label>
                                <input type="date" 
                                       name="data_fim" 
                                       class="form-control" 
                                       value="{{ request('data_fim', now()->format('Y-m-d')) }}">
                            </div>
                            <div class="col-md-3">
                                <label class="form-label">Franquia</label>
                                <select name="franquia_id" class="form-control">
                                    <option value="">Todas</option>
                                    @foreach($franquias ?? [] as $franquia)
                                        <option value="{{ $franquia->id }}" 
                                                {{ request('franquia_id') == $franquia->id ? 'selected' : '' }}>
                                            {{ $franquia->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-3 d-flex align-items-end">
                                <button type="submit" class="btn btn-primary w-100">
                                    <i class="ph-duotone ph-magnifying-glass me-2"></i>Filtrar
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <!-- Cards Resumo -->
        <div class="row">
            <div class="col-md-2">
                <div class="card stat-card primary">
                    <div class="card-body">
                        <div class="text-center">
                            <div class="text-primary mb-2">
                                <i class="ph-duotone ph-eye" style="font-size: 2.5rem;"></i>
                            </div>
                            <h6 class="text-muted mb-1">Impressões</h6>
                            <h3 class="mb-0">{{ number_format($stats['total_impressoes'] ?? 0, 0, ',', '.') }}</h3>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-2">
                <div class="card stat-card success">
                    <div class="card-body">
                        <div class="text-center">
                            <div class="text-success mb-2">
                                <i class="ph-duotone ph-cursor-click" style="font-size: 2.5rem;"></i>
                            </div>
                            <h6 class="text-muted mb-1">Cliques</h6>
                            <h3 class="mb-0">{{ number_format($stats['total_cliques'] ?? 0, 0, ',', '.') }}</h3>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-2">
                <div class="card stat-card warning">
                    <div class="card-body">
                        <div class="text-center">
                            <div class="text-warning mb-2">
                                <i class="ph-duotone ph-target" style="font-size: 2.5rem;"></i>
                            </div>
                            <h6 class="text-muted mb-1">CTR Médio</h6>
                            <h3 class="mb-0">{{ number_format($stats['ctr_geral'] ?? 0, 2, ',', '.') }}%</h3>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-2">
                <div class="card stat-card info">
                    <div class="card-body">
                        <div class="text-center">
                            <div class="text-info mb-2">
                                <i class="ph-duotone ph-broadcast" style="font-size: 2.5rem;"></i>
                            </div>
                            <h6 class="text-muted mb-1">Publicações</h6>
                            <h3 class="mb-0">{{ $stats['total_publicacoes'] ?? 0 }}</h3>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-2">
                <div class="card stat-card purple">
                    <div class="card-body">
                        <div class="text-center">
                            <div class="text-purple mb-2">
                                <i class="ph-duotone ph-wifi-high" style="font-size: 2.5rem;"></i>
                            </div>
                            <h6 class="text-muted mb-1">Hotspots</h6>
                            <h3 class="mb-0">{{ $stats['hotspots_ativos'] ?? 0 }}</h3>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-2">
                <div class="card stat-card danger">
                    <div class="card-body">
                        <div class="text-center">
                            <div class="text-danger mb-2">
                                <i class="ph-duotone ph-trending-up" style="font-size: 2.5rem;"></i>
                            </div>
                            <h6 class="text-muted mb-1">Média/Dia</h6>
                            <h3 class="mb-0">{{ number_format($stats['media_impressoes_diaria'] ?? 0, 0, ',', '.') }}</h3>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Gráficos Principais -->
        <div class="row">
            <!-- Gráfico de Evolução Temporal -->
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0">
                            <i class="ph-duotone ph-chart-line me-2"></i>
                            Evolução de Impressões e Cliques
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="chart-container">
                            <canvas id="evolucaoChart"></canvas>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Gráfico de CTR por Publicação -->
            <div class="col-md-4">
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0">
                            <i class="ph-duotone ph-chart-donut me-2"></i>
                            Distribuição de Cliques
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="chart-container">
                            <canvas id="distribuicaoChart"></canvas>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Rankings -->
        <div class="row">
            <!-- Top Publicações -->
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h5 class="mb-0">
                            <i class="ph-duotone ph-trophy me-2"></i>
                            Top 10 Publicações
                        </h5>
                        <a href="{{ route('estatisticas.por-publicacao') }}" class="btn btn-sm btn-outline-primary">
                            Ver Todas
                        </a>
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table table-hover mb-0">
                                <thead>
                                    <tr>
                                        <th width="50">#</th>
                                        <th>Publicação</th>
                                        <th class="text-end">Impressões</th>
                                        <th class="text-end">Cliques</th>
                                        <th class="text-end">CTR</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($stats['top_publicacoes'] ?? [] as $index => $pub)
                                    <tr class="ranking-item">
                                        <td>
                                            @if($index === 0)
                                                <span style="font-size: 1.5rem;">🥇</span>
                                            @elseif($index === 1)
                                                <span style="font-size: 1.5rem;">🥈</span>
                                            @elseif($index === 2)
                                                <span style="font-size: 1.5rem;">🥉</span>
                                            @else
                                                <span class="text-muted">{{ $index + 1 }}</span>
                                            @endif
                                        </td>
                                        <td>
                                            <strong>{{ Str::limit($pub->titulo, 40) }}</strong>
                                            <small class="text-muted d-block">
                                                {{ $pub->cliente_name ?? 'N/A' }}
                                            </small>
                                        </td>
                                        <td class="text-end">
                                            <span class="badge bg-primary">
                                                {{ number_format($pub->total_impressoes, 0, ',', '.') }}
                                            </span>
                                        </td>
                                        <td class="text-end">
                                            <span class="badge bg-success">
                                                {{ number_format($pub->total_cliques, 0, ',', '.') }}
                                            </span>
                                        </td>
                                        <td class="text-end">
                                            @php
                                                $ctr = $pub->total_impressoes > 0 
                                                    ? ($pub->total_cliques / $pub->total_impressoes) * 100 
                                                    : 0;
                                            @endphp
                                            <span class="badge bg-{{ $ctr >= 5 ? 'success' : ($ctr >= 2 ? 'warning' : 'secondary') }}">
                                                {{ number_format($ctr, 2, ',', '.') }}%
                                            </span>
                                        </td>
                                    </tr>
                                    @empty
                                    <tr>
                                        <td colspan="5" class="text-center text-muted py-4">
                                            <i class="ph-duotone ph-info me-2"></i>
                                            Nenhum dado disponível no período selecionado
                                        </td>
                                    </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Top Hotspots -->
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h5 class="mb-0">
                            <i class="ph-duotone ph-medal me-2"></i>
                            Top 10 Hotspots
                        </h5>
                        <a href="{{ route('estatisticas.por-hotspot') }}" class="btn btn-sm btn-outline-primary">
                            Ver Todos
                        </a>
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table table-hover mb-0">
                                <thead>
                                    <tr>
                                        <th width="50">#</th>
                                        <th>Serial</th>
                                        <th class="text-end">Impressões</th>
                                        <th class="text-end">Cliques</th>
                                        <th class="text-end">CTR</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($stats['top_hotspots'] ?? [] as $index => $hotspot)
                                    <tr class="ranking-item">
                                        <td>
                                            @if($index === 0)
                                                <span style="font-size: 1.5rem;">🥇</span>
                                            @elseif($index === 1)
                                                <span style="font-size: 1.5rem;">🥈</span>
                                            @elseif($index === 2)
                                                <span style="font-size: 1.5rem;">🥉</span>
                                            @else
                                                <span class="text-muted">{{ $index + 1 }}</span>
                                            @endif
                                        </td>
                                        <td>
                                            <strong>{{ $hotspot->serial }}</strong>
                                            <small class="text-muted d-block">
                                                {{ $hotspot->marca ?? 'N/A' }}
                                            </small>
                                        </td>
                                        <td class="text-end">
                                            <span class="badge bg-primary">
                                                {{ number_format($hotspot->total_impressoes, 0, ',', '.') }}
                                            </span>
                                        </td>
                                        <td class="text-end">
                                            <span class="badge bg-success">
                                                {{ number_format($hotspot->total_cliques, 0, ',', '.') }}
                                            </span>
                                        </td>
                                        <td class="text-end">
                                            @php
                                                $ctr = $hotspot->total_impressoes > 0 
                                                    ? ($hotspot->total_cliques / $hotspot->total_impressoes) * 100 
                                                    : 0;
                                            @endphp
                                            <span class="badge bg-{{ $ctr >= 5 ? 'success' : ($ctr >= 2 ? 'warning' : 'secondary') }}">
                                                {{ number_format($ctr, 2, ',', '.') }}%
                                            </span>
                                        </td>
                                    </tr>
                                    @empty
                                    <tr>
                                        <td colspan="5" class="text-center text-muted py-4">
                                            <i class="ph-duotone ph-info me-2"></i>
                                            Nenhum dado disponível no período selecionado
                                        </td>
                                    </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.0/dist/chart.umd.min.js"></script>
<script>
    // Cores
    const colors = {
        primary: '#4680ff',
        success: '#2ed8b6',
        warning: '#ffb64d',
        danger: '#ff5370',
        info: '#00bcd4',
        purple: '#a389d4'
    };

    // Dados dos gráficos
    const graficosData = @json($stats['graficos'] ?? []);

    // Gráfico de Evolução
    const ctxEvolucao = document.getElementById('evolucaoChart');
    if (ctxEvolucao && graficosData.impressoes_diarias) {
        new Chart(ctxEvolucao, {
            type: 'line',
            data: {
                labels: graficosData.impressoes_diarias.map(d => {
                    const date = new Date(d.data);
                    return date.toLocaleDateString('pt-BR', { day: '2-digit', month: '2-digit' });
                }),
                datasets: [
                    {
                        label: 'Impressões',
                        data: graficosData.impressoes_diarias.map(d => d.total),
                        borderColor: colors.primary,
                        backgroundColor: colors.primary + '20',
                        tension: 0.4,
                        fill: true
                    },
                    {
                        label: 'Cliques',
                        data: graficosData.cliques_diarios.map(d => d.total),
                        borderColor: colors.success,
                        backgroundColor: colors.success + '20',
                        tension: 0.4,
                        fill: true
                    }
                ]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        display: true,
                        position: 'top'
                    },
                    tooltip: {
                        mode: 'index',
                        intersect: false
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: {
                            precision: 0
                        }
                    }
                }
            }
        });
    }

    // Gráfico de Distribuição
    const ctxDistribuicao = document.getElementById('distribuicaoChart');
    if (ctxDistribuicao && graficosData.ctr_por_publicacao) {
        const topPublicacoes = graficosData.ctr_por_publicacao.slice(0, 5);
        
        new Chart(ctxDistribuicao, {
            type: 'doughnut',
            data: {
                labels: topPublicacoes.map(p => p.titulo.substring(0, 20) + '...'),
                datasets: [{
                    data: topPublicacoes.map(p => p.total_cliques),
                    backgroundColor: [
                        colors.primary,
                        colors.success,
                        colors.warning,
                        colors.info,
                        colors.purple
                    ],
                    borderWidth: 2,
                    borderColor: '#fff'
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        display: true,
                        position: 'bottom'
                    },
                    tooltip: {
                        callbacks: {
                            label: function(context) {
                                const total = context.dataset.data.reduce((a, b) => a + b, 0);
                                const percentage = ((context.parsed / total) * 100).toFixed(1);
                                return context.label + ': ' + context.parsed.toLocaleString('pt-BR') + ' cliques (' + percentage + '%)';
                            }
                        }
                    }
                }
            }
        });
    }
</script>
@endpush
