@extends('layouts.master')
@section('title', 'Relatório por Hotspot')

@section('main-content')
    <div class="container-fluid">
        <!-- Breadcrumb -->
        <div class="row m-1">
            <div class="col-12">
                <h5><i class="ph-duotone ph-wifi-high f-s-16 me-2"></i>Relatório por Hotspot</h5>
                <ul class="app-line-breadcrumbs mb-3">
                    <li>
                        <a href="{{ route('estatisticas.dashboard') }}" class="f-s-14 f-w-500">
                            <span>Dashboard</span>
                        </a>
                    </li>
                    <li class="active">
                        <a href="#" class="f-s-14 f-w-500">Por Hotspot</a>
                    </li>
                </ul>
            </div>
        </div>

        <!-- Filtros -->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <form method="GET" action="{{ route('estatisticas.por-hotspot') }}" class="row g-3">
                            <div class="col-md-3">
                                <label class="form-label">Data Início</label>
                                <input type="date" 
                                       name="data_inicio" 
                                       class="form-control" 
                                       value="{{ request('data_inicio', now()->subDays(30)->format('Y-m-d')) }}">
                            </div>
                            <div class="col-md-3">
                                <label class="form-label">Data Fim</label>
                                <input type="date" 
                                       name="data_fim" 
                                       class="form-control" 
                                       value="{{ request('data_fim', now()->format('Y-m-d')) }}">
                            </div>
                            <div class="col-md-3">
                                <label class="form-label">Marca</label>
                                <select name="marca" class="form-control">
                                    <option value="">Todas</option>
                                    <option value="MikroTik" {{ request('marca') == 'MikroTik' ? 'selected' : '' }}>MikroTik</option>
                                    <option value="Ubiquiti" {{ request('marca') == 'Ubiquiti' ? 'selected' : '' }}>Ubiquiti</option>
                                    <option value="TP-Link" {{ request('marca') == 'TP-Link' ? 'selected' : '' }}>TP-Link</option>
                                </select>
                            </div>
                            <div class="col-md-3 d-flex align-items-end">
                                <button type="submit" class="btn btn-primary w-100">
                                    <i class="ph-duotone ph-magnifying-glass me-2"></i>Filtrar
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <!-- Cards Resumo -->
        <div class="row">
            <div class="col-md-4">
                <div class="card border-left-primary">
                    <div class="card-body">
                        <div class="d-flex justify-content-between">
                            <div>
                                <h6 class="text-muted mb-1">Total de Hotspots</h6>
                                <h3 class="mb-0">{{ $stats['total_hotspots'] ?? 0 }}</h3>
                            </div>
                            <div class="text-primary">
                                <i class="ph-duotone ph-wifi-high" style="font-size: 2.5rem;"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card border-left-success">
                    <div class="card-body">
                        <div class="d-flex justify-content-between">
                            <div>
                                <h6 class="text-muted mb-1">Média de Impressões</h6>
                                <h3 class="mb-0">{{ number_format($stats['media_impressoes'] ?? 0, 0, ',', '.') }}</h3>
                            </div>
                            <div class="text-success">
                                <i class="ph-duotone ph-chart-bar" style="font-size: 2.5rem;"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card border-left-warning">
                    <div class="card-body">
                        <div class="d-flex justify-content-between">
                            <div>
                                <h6 class="text-muted mb-1">CTR Médio</h6>
                                <h3 class="mb-0">{{ number_format($stats['ctr_medio'] ?? 0, 2, ',', '.') }}%</h3>
                            </div>
                            <div class="text-warning">
                                <i class="ph-duotone ph-target" style="font-size: 2.5rem;"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Tabela de Relatório -->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h5 class="mb-0">Performance por Hotspot</h5>
                        <div>
                            <button class="btn btn-sm btn-outline-success" onclick="exportarExcel()">
                                <i class="ph-duotone ph-file-xls me-1"></i>Exportar Excel
                            </button>
                        </div>
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table table-hover mb-0">
                                <thead class="table-light">
                                    <tr>
                                        <th>#</th>
                                        <th>Serial</th>
                                        <th>Marca/Modelo</th>
                                        <th>Cliente</th>
                                        <th>Status</th>
                                        <th class="text-end">Impressões</th>
                                        <th class="text-end">Cliques</th>
                                        <th class="text-end">CTR</th>
                                        <th class="text-end">Publicações</th>
                                        <th class="text-center">Performance</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($hotspots ?? [] as $index => $hotspot)
                                    <tr>
                                        <td>
                                            @if($index === 0)
                                                🥇
                                            @elseif($index === 1)
                                                🥈
                                            @elseif($index === 2)
                                                🥉
                                            @else
                                                {{ $index + 1 }}
                                            @endif
                                        </td>
                                        <td>
                                            <strong>{{ $hotspot->serial }}</strong>
                                        </td>
                                        <td>
                                            {{ $hotspot->marca ?? 'N/A' }}
                                            <small class="text-muted d-block">
                                                {{ $hotspot->modelo ?? '' }}
                                            </small>
                                        </td>
                                        <td>{{ $hotspot->cliente_name ?? 'N/A' }}</td>
                                        <td>
                                            <span class="badge bg-{{ $hotspot->status ? 'success' : 'secondary' }}">
                                                {{ $hotspot->status ? 'Ativo' : 'Inativo' }}
                                            </span>
                                        </td>
                                        <td class="text-end">
                                            <span class="badge bg-primary">
                                                {{ number_format($hotspot->total_impressoes ?? 0, 0, ',', '.') }}
                                            </span>
                                        </td>
                                        <td class="text-end">
                                            <span class="badge bg-success">
                                                {{ number_format($hotspot->total_cliques ?? 0, 0, ',', '.') }}
                                            </span>
                                        </td>
                                        <td class="text-end">
                                            @php
                                                $ctr = isset($hotspot->total_impressoes) && $hotspot->total_impressoes > 0 
                                                    ? ($hotspot->total_cliques / $hotspot->total_impressoes) * 100 
                                                    : 0;
                                            @endphp
                                            <span class="badge bg-{{ $ctr >= 5 ? 'success' : ($ctr >= 2 ? 'warning' : 'secondary') }}">
                                                {{ number_format($ctr, 2, ',', '.') }}%
                                            </span>
                                        </td>
                                        <td class="text-end">
                                            {{ $hotspot->publicacoes_count ?? 0 }}
                                        </td>
                                        <td class="text-center">
                                            @if($ctr >= 5)
                                                <span class="badge bg-success">Excelente</span>
                                            @elseif($ctr >= 2)
                                                <span class="badge bg-warning">Bom</span>
                                            @elseif($ctr > 0)
                                                <span class="badge bg-info">Regular</span>
                                            @else
                                                <span class="badge bg-secondary">Sem dados</span>
                                            @endif
                                        </td>
                                    </tr>
                                    @empty
                                    <tr>
                                        <td colspan="10" class="text-center text-muted py-5">
                                            <i class="ph-duotone ph-info me-2" style="font-size: 2rem;"></i>
                                            <p class="mb-0">Nenhum hotspot encontrado no período selecionado</p>
                                        </td>
                                    </tr>
                                    @endforelse
                                </tbody>
                                @if(isset($hotspots) && $hotspots->count() > 0)
                                <tfoot class="table-light">
                                    <tr>
                                        <th colspan="5" class="text-end">TOTAIS:</th>
                                        <th class="text-end">
                                            {{ number_format($hotspots->sum('total_impressoes') ?? 0, 0, ',', '.') }}
                                        </th>
                                        <th class="text-end">
                                            {{ number_format($hotspots->sum('total_cliques') ?? 0, 0, ',', '.') }}
                                        </th>
                                        <th class="text-end">
                                            @php
                                                $totalImp = $hotspots->sum('total_impressoes') ?? 0;
                                                $totalClq = $hotspots->sum('total_cliques') ?? 0;
                                                $ctrTotal = $totalImp > 0 ? ($totalClq / $totalImp) * 100 : 0;
                                            @endphp
                                            {{ number_format($ctrTotal, 2, ',', '.') }}%
                                        </th>
                                        <th colspan="2"></th>
                                    </tr>
                                </tfoot>
                                @endif
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
<script>
    function exportarExcel() {
        alert('Funcionalidade de exportação em desenvolvimento');
        // TODO: Implementar exportação Excel
    }
</script>
@endpush
