<!-- GEMINI_TEST_COMMENT_123 -->
@extends('layouts.master')
@section('title', isset($midia) ? 'Editar Mídia' : 'Criar Mídia')
@section('main-content')
    <div class="container-fluid">
        <!-- Breadcrumb start -->
        <div class="row m-1">
            <div class="col-12">
                <h5><i class="ph-duotone ph-image f-s-16 me-2"></i>@yield('title')</h5>
                <ul class="app-line-breadcrumbs mb-3">
                    <li class="">
                        <a href="{{ route('midias.index') }}" class="f-s-14 f-w-500">
                            <span>Mídias</span>
                        </a>
                    </li>
                    <li class="active">
                        <a href="#" class="f-s-14 f-w-500">@yield('title')</a>
                    </li>
                </ul>
            </div>
        </div>
        <!-- Breadcrumb end -->

        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <h5>Detalhes da Mídia</h5>
                    </div>
                    <div class="card-body">
                        <form class="app-form" action="{{ isset($midia) ? route('midias.update', $midia) : route('midias.store') }}" method="POST" enctype="multipart/form-data">
                            @csrf
                            @if(isset($midia))
                                @method('PUT')
                            @endif
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="mb-3">
                                        <label class="form-label">Título</label>
                                        <input type="text" name="title" class="form-control" placeholder="Título da Mídia" value="{{ old('title', $midia->title ?? '') }}" required>
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="mb-3">
                                        <label class="form-label">Tipo de Mídia</label>
                                        <select name="type" class="form-control" required>
                                            <option value="image" @if(old('type', $midia->tipo ?? $midia->type ?? '') == 'image') selected @endif>Imagem</option>
                                            <option value="video" @if(old('type', $midia->tipo ?? $midia->type ?? '') == 'video') selected @endif>Vídeo</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="mb-3">
                                        <label class="form-label">Arquivo de Mídia</label>
                                        <input type="file" name="media_file" class="form-control" @if(!isset($midia)) required @endif>
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="mb-3">
                                        <label class="form-label">Empresa</label>
                                        <select name="empresa_legado_id" class="form-control" required>
                                            @foreach($empresas as $empresa)
                                                <option value="{{ $empresa->id }}" @if(old('empresa_legado_id', $midia->empresa_legado_id ?? '') == $empresa->id) selected @endif>{{ $empresa->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="mb-3">
                                        <label class="form-label">Serial do Equipamento</label>
                                        <input type="text" name="equipment_serial" class="form-control" placeholder="Serial do Equipamento" value="{{ old('equipment_serial', $midia->equipment_serial ?? '') }}">
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="mb-3">
                                        <label class="form-label">Posição da Mídia (1-6)</label>
                                        <select name="position" class="form-control">
                                            <option value="">Selecionar Posição</option>
                                            @for ($i = 1; $i <= 6; $i++)
                                                <option value="{{ $i }}" @if(old('position', $midia->position ?? '') == $i) selected @endif>{{ $i }}</option>
                                            @endfor
                                        </select>
                                    </div>
                                </div>

                                <div class="col-12"><hr class="my-3"></div>

                                <div class="col-sm-6">
                                    <div class="mb-3">
                                        <label class="form-label">Data e Hora de Início</label>
                                        <input type="datetime-local" name="start_datetime" class="form-control" value="{{ old('start_datetime', isset($midia) ? \Carbon\Carbon::parse($midia->start_datetime)->format('Y-m-d\TH:i') : '') }}">
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="mb-3">
                                        <label class="form-label">Data e Hora de Encerramento</label>
                                        <input type="datetime-local" name="end_datetime" class="form-control" value="{{ old('end_datetime', isset($midia) ? \Carbon\Carbon::parse($midia->end_datetime)->format('Y-m-d\TH:i') : '') }}">
                                    </div>
                                </div>

                                <div class="col-12 text-end">
                                    <div class="btn-group" role="group">
                                        <button type="submit" class="btn btn-success"><i class="ph-duotone ph-floppy-disk me-2"></i>Salvar</button>
                                        <a href="{{ route('midias.index') }}" class="btn btn-secondary"><i class="ph-duotone ph-x-circle me-2"></i>Cancelar</a>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
