@extends('layouts.master')
@section('title', isset($permission) ? 'Edit Permission' : 'Create Permission')
@section('main-content')
    <div class="container-fluid">
        <!-- Breadcrumb start -->
        <div class="row m-1">
            <div class="col-12">
                <h5>@yield('title')</h5>
                <ul class="app-line-breadcrumbs mb-3">
                    <li class="">
                        <a href="{{ route('permissions.index') }}" class="f-s-14 f-w-500">
                            <span><i class="ph-duotone ph-key f-s-16"></i> Permissions</span>
                        </a>
                    </li>
                    <li class="active">
                        <a href="#" class="f-s-14 f-w-500">@yield('title')</a>
                    </li>
                </ul>
            </div>
        </div>
        <!-- Breadcrumb end -->

        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <h5>Permission Details</h5>
                    </div>
                    <div class="card-body">
                        <form class="app-form" action="{{ isset($permission) ? route('permissions.update', $permission) : route('permissions.store') }}" method="POST">
                            @csrf
                            @if(isset($permission))
                                @method('PUT')
                            @endif
                            <div class="row">
                                <div class="col-sm-6">
                                    <div class="mb-3">
                                        <label class="form-label">Name</label>
                                        <input type="text" name="name" class="form-control" placeholder="e.g., Create Users" value="{{ old('name', $permission->name ?? '') }}" required>
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="mb-3">
                                        <label class="form-label">Description</label>
                                        <input type="text" name="description" class="form-control" placeholder="A short description" value="{{ old('description', $permission->description ?? '') }}">
                                    </div>

                                </div>
                                <div class="col-sm-6">
                                    <div class="mb-3">
                                        <label class="form-label">Subsystem</label>
                                        <input type="text" name="subsystem" class="form-control" placeholder="e.g., Users" value="{{ old('subsystem', $permission->subsystem ?? '') }}" required>
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="mb-3">
                                        <label class="form-label">Action</label>
                                        <input type="text" name="action" class="form-control" placeholder="e.g., create" value="{{ old('action', $permission->action ?? '') }}" required>
                                    </div>
                                </div>

                                <div class="col-12 text-end">
                                    <button type="submit" class="btn btn-success">Submit</button>
                                    <a href="{{ route('permissions.index') }}" class="btn btn-secondary">Cancel</a>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
