@extends('layouts.master')
@section('title', 'Publicações')

@section('css')
<link rel="stylesheet" href="{{ asset('css/custom-badges.css') }}">
<style>
/* Bolinhas de status e vigência */
.status-dot {
    width: 12px !important;
    height: 12px !important;
    display: inline-block !important;
    border-radius: 50% !important;
    margin-right: 0.25rem;
    flex-shrink: 0;
}

.status-dot.bg-success {
    background-color: #198754 !important;
}

.status-dot.bg-warning {
    background-color: #ffc107 !important;
}

.status-dot.bg-danger {
    background-color: #dc3545 !important;
}

.status-dot.bg-secondary {
    background-color: #6c757d !important;
}

.status-dot.bg-primary {
    background-color: #0d6efd !important;
}

/* Popover período - título visível no dark mode */
.popover-header {
    background-color: #0d6efd !important;
    color: #ffffff !important;
    font-weight: 600;
}

/* Popover período - conteúdo alinhado em colunas */
.periodo-table {
    display: table;
    width: 100%;
    font-size: 13px;
}

.periodo-row {
    display: table-row;
}

.periodo-label {
    display: table-cell;
    padding: 4px 8px 4px 0;
    font-weight: 600;
    white-space: nowrap;
    width: 60px;
}

.periodo-value {
    display: table-cell;
    padding: 4px 0;
}
</style>
@endsection

@section('main-content')
    <div class="container-fluid">
        <!-- Breadcrumb -->
        <div class="row m-1">
            <div class="col-12">
                <h5><i class="ph-duotone ph-broadcast f-s-16 me-2"></i>Publicações</h5>
                <ul class="app-line-breadcrumbs mb-3">
                    <li class="active">
                        <a href="#" class="f-s-14 f-w-500">Publicações</a>
                    </li>
                </ul>
            </div>
        </div>

        <!-- Cards de Estatísticas -->
        <div class="row">
            <div class="col-xl-3 col-md-6">
                <div class="card stats-card">
                    <div class="card-body">
                        <div class="d-flex align-items-center justify-content-between">
                            <div>
                                <h6 class="text-muted mb-2 f-w-500">Ativas</h6>
                                <h3 class="mb-0">{{ $stats['ativas'] }}</h3>
                            </div>
                            <div class="avatar avatar-md bg-light-success">
                                <i class="ph-duotone ph-play-circle f-s-24 text-success"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-3 col-md-6">
                <div class="card stats-card">
                    <div class="card-body">
                        <div class="d-flex align-items-center justify-content-between">
                            <div>
                                <h6 class="text-muted mb-2 f-w-500">Vigentes</h6>
                                <h3 class="mb-0">{{ $stats['vigentes'] }}</h3>
                            </div>
                            <div class="avatar avatar-md bg-light-primary">
                                <i class="ph-duotone ph-calendar-check f-s-24 text-primary"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-3 col-md-6">
                <div class="card stats-card">
                    <div class="card-body">
                        <div class="d-flex align-items-center justify-content-between">
                            <div>
                                <h6 class="text-muted mb-2 f-w-500">Pausadas</h6>
                                <h3 class="mb-0">{{ $stats['pausadas'] }}</h3>
                            </div>
                            <div class="avatar avatar-md bg-light-warning">
                                <i class="ph-duotone ph-pause-circle f-s-24 text-warning"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-3 col-md-6">
                <div class="card stats-card">
                    <div class="card-body">
                        <div class="d-flex align-items-center justify-content-between">
                            <div>
                                <h6 class="text-muted mb-2 f-w-500">Valor Total Ativas</h6>
                                <h3 class="mb-0">R$ {{ number_format($stats['valor_total_ativas'], 2, ',', '.') }}</h3>
                            </div>
                            <div class="avatar avatar-md bg-light-info">
                                <i class="ph-duotone ph-currency-circle-dollar f-s-24 text-info"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Filtros e Tabela -->
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <div class="d-flex align-items-center justify-content-between mb-2">
                            <h5 class="mb-0">Lista de Publicações</h5>
                            <a href="{{ route('publicacoes.create') }}" class="btn btn-primary btn-sm">
                                <i class="ph-duotone ph-plus me-2"></i>Nova Publicação
                            </a>
                        </div>
                        <!-- Legenda de Status e Vigência -->
                        <div class="d-flex align-items-center gap-3 mt-2 flex-wrap">
                            <div class="d-flex align-items-center gap-3">
                                <small class="text-muted me-2">Status:</small>
                                <span class="d-flex align-items-center">
                                    <span class="status-dot bg-success"></span>
                                    <small>Ativa</small>
                                </span>
                                <span class="d-flex align-items-center">
                                    <span class="status-dot bg-warning"></span>
                                    <small>Pausada</small>
                                </span>
                                <span class="d-flex align-items-center">
                                    <span class="status-dot bg-danger"></span>
                                    <small>Expirada</small>
                                </span>
                                <span class="d-flex align-items-center">
                                    <span class="status-dot bg-secondary"></span>
                                    <small>Cancelada</small>
                                </span>
                            </div>
                            
                            <div class="d-flex align-items-center gap-3 ms-3">
                                <small class="text-muted me-2">Vigência:</small>
                                <span class="d-flex align-items-center">
                                    <span class="status-dot bg-primary"></span>
                                    <small>Vigente (rodando agora)</small>
                                </span>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <!-- Filtros -->
                        <form method="GET" action="{{ route('publicacoes.index') }}" class="mb-3">
                            <div class="row g-3">
                                <div class="col-md-3">
                                    <input type="text" name="q" class="form-control" placeholder="Buscar por título..." value="{{ request('q') }}">
                                </div>
                                <div class="col-md-2">
                                    <select name="status" class="form-control">
                                        <option value="">Todos os status</option>
                                        <option value="ativa" @if(request('status') == 'ativa') selected @endif>Ativa</option>
                                        <option value="pausada" @if(request('status') == 'pausada') selected @endif>Pausada</option>
                                        <option value="expirada" @if(request('status') == 'expirada') selected @endif>Expirada</option>
                                        <option value="cancelada" @if(request('status') == 'cancelada') selected @endif>Cancelada</option>
                                    </select>
                                </div>
                                <div class="col-md-2">
                                    <select name="franquia_id" class="form-control">
                                        <option value="">Todas as franquias</option>
                                        @foreach($franquias as $franquia)
                                            <option value="{{ $franquia->id }}" @if(request('franquia_id') == $franquia->id) selected @endif>
                                                {{ $franquia->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-2">
                                    <select name="cliente_id" class="form-control">
                                        <option value="">Todos os clientes</option>
                                        @foreach($clientes as $cliente)
                                            <option value="{{ $cliente->id }}" @if(request('cliente_id') == $cliente->id) selected @endif>
                                                {{ $cliente->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-3">
                                    <div class="btn-group" role="group">
                                        <button type="submit" class="btn btn-primary">
                                            <i class="ph-duotone ph-funnel me-2"></i>Filtrar
                                        </button>
                                        <a href="{{ route('publicacoes.index') }}" class="btn btn-secondary">
                                            <i class="ph-duotone ph-x me-2"></i>Limpar
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </form>

                        <!-- Tabela -->
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Título</th>
                                        <th>Franquia</th>
                                        <th>Cliente</th>
                                        <th>Alcance</th>
                                        <th>Período</th>
                                        <th class="text-center">Visualizações</th>
                                        <th class="text-center" style="width: 1%;">Ações</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($publicacoes as $publicacao)
                                        <tr>
                                            <td>{{ $publicacao->id }}</td>
                                            
                                            <!-- Título com bolinha de status, ícone de tipo e posição -->
                                            <td>
                                                <div class="d-flex align-items-center">
                                                    @php
                                                        $statusColors = [
                                                            'ativa' => 'success',
                                                            'pausada' => 'warning',
                                                            'expirada' => 'danger',
                                                            'cancelada' => 'secondary',
                                                        ];
                                                        $statusColor = $statusColors[$publicacao->status] ?? 'secondary';
                                                    @endphp
                                                    <span class="badge bg-{{ $statusColor }} rounded-circle p-2 me-2" 
                                                          style="width: 10px; height: 10px;"
                                                          title="{{ ucfirst($publicacao->status) }}"></span>
                                                    <div>
                                                        <div class="d-flex align-items-center gap-2">
                                                            <a href="{{ route('publicacoes.edit', $publicacao) }}" 
                                                               class="text-dark text-decoration-none"
                                                               title="Clique para editar">
                                                                <strong>{{ $publicacao->titulo }}</strong>
                                                            </a>
                                                            
                                                            <!-- Ícone do tipo de mídia com modal de preview -->
                                                            @if($publicacao->criativo && $publicacao->criativo->path)
                                                                <a href="#" class="preview-criativo" 
                                                                   data-bs-toggle="modal" 
                                                                   data-bs-target="#previewModal"
                                                                   data-path="{{ Storage::url($publicacao->criativo->path) }}"
                                                                   data-title="{{ $publicacao->criativo->title }}"
                                                                   data-type="{{ $publicacao->tipo_midia }}"
                                                                   title="Clique para ver o preview"
                                                                   style="text-decoration: none; cursor: pointer;">
                                                                    @if($publicacao->tipo_midia === 'imagem')
                                                                        <i class="ph-duotone ph-image text-info" style="font-size: 18px;"></i>
                                                                    @elseif($publicacao->tipo_midia === 'video')
                                                                        <i class="ph-duotone ph-video text-purple" style="font-size: 18px;"></i>
                                                                    @elseif($publicacao->tipo_midia === 'html')
                                                                        <i class="ph-duotone ph-code text-warning" style="font-size: 18px;"></i>
                                                                    @endif
                                                                </a>
                                                            @elseif($publicacao->tipo_midia)
                                                                <!-- Ícone sem link caso não tenha criativo -->
                                                                @if($publicacao->tipo_midia === 'imagem')
                                                                    <i class="ph-duotone ph-image text-muted" style="font-size: 18px;" title="Imagem (sem criativo)"></i>
                                                                @elseif($publicacao->tipo_midia === 'video')
                                                                    <i class="ph-duotone ph-video text-muted" style="font-size: 18px;" title="Vídeo (sem criativo)"></i>
                                                                @elseif($publicacao->tipo_midia === 'html')
                                                                    <i class="ph-duotone ph-code text-muted" style="font-size: 18px;" title="HTML (sem criativo)"></i>
                                                                @endif
                                                            @endif
                                                            
                                                            <!-- Número da posição -->
                                                            @if($publicacao->posicao)
                                                                <span class="fw-bold text-dark mx-2" title="Posição {{ $publicacao->posicao }}">
                                                                    {{ $publicacao->posicao }}
                                                                </span>
                                                            @endif
                                                            
                                                            <!-- Bolinha de Status -->
                                                            @if($publicacao->status === 'ativa')
                                                                <span class="status-dot bg-success" title="Ativa"></span>
                                                            @elseif($publicacao->status === 'pausada')
                                                                <span class="status-dot bg-warning" title="Pausada"></span>
                                                            @elseif($publicacao->status === 'expirada')
                                                                <span class="status-dot bg-danger" title="Expirada"></span>
                                                            @elseif($publicacao->status === 'cancelada')
                                                                <span class="status-dot bg-secondary" title="Cancelada"></span>
                                                            @endif
                                                            
                                                            <!-- Bolinha de Vigência -->
                                                            @if($publicacao->isVigente())
                                                                <span class="status-dot bg-primary" title="Vigente (rodando agora)"></span>
                                                            @endif
                                                        </div>
                                                        @if($publicacao->criativo)
                                                            <small class="text-muted">{{ $publicacao->criativo->title }}</small>
                                                        @endif
                                                    </div>
                                                </div>
                                            </td>
                                            
                                            <td>{{ $publicacao->franquia?->name ?? '-' }}</td>
                                            <td>{{ $publicacao->cliente?->name ?? '-' }}</td>
                                            <td class="text-center">
                                                @php
                                                    $alcanceConfig = [
                                                        'todos' => ['color' => 'text-primary', 'icon' => 'ph-broadcast', 'size' => '20px'],
                                                        'serial_especifico' => ['color' => 'text-warning', 'icon' => 'ph-device-mobile', 'size' => '20px'],
                                                        'empresa' => ['color' => 'text-info', 'icon' => 'ph-buildings', 'size' => '20px'],
                                                    ];
                                                    $config = $alcanceConfig[$publicacao->tipo_alcance] ?? $alcanceConfig['todos'];
                                                @endphp
                                                
                                                <div class="d-flex align-items-center justify-content-center gap-2">
                                                    <i class="ph-fill {{ $config['icon'] }} {{ $config['color'] }}" 
                                                       style="font-size: {{ $config['size'] }};" 
                                                       title="{{ $publicacao->getTipoAlcanceLabel() }}"></i>
                                                    
                                                    @if($publicacao->tipo_alcance === 'serial_especifico')
                                                        <span class="fw-bold">{{ $publicacao->equipment_serial ?? '-' }}</span>
                                                    @elseif($publicacao->tipo_alcance === 'empresa')
                                                        <span class="fw-bold">{{ Str::limit($publicacao->empresaAlcance->name ?? '-', 15) }}</span>
                                                    @else
                                                        <span class="text-muted">Todos da franquia</span>
                                                    @endif
                                                </div>
                                            </td>
                                            <td class="text-center">
                                                <i class="ph-fill ph-clock text-primary" 
                                                   style="font-size: 20px; cursor: pointer;"
                                                   data-bs-toggle="popover" 
                                                   data-bs-trigger="hover focus"
                                                   data-bs-html="true"
                                                   data-bs-placement="top"
                                                   data-bs-title="Período da Publicação"
                                                   data-bs-content="<div class='periodo-table'><div class='periodo-row'><div class='periodo-label'>Início:</div><div class='periodo-value'>{{ $publicacao->data_inicio->format('d/m/Y H:i') }}</div></div><div class='periodo-row'><div class='periodo-label'>Fim:</div><div class='periodo-value'>{{ $publicacao->data_fim->format('d/m/Y H:i') }}</div></div><div class='periodo-row'><div class='periodo-label'>Duração:</div><div class='periodo-value'>{{ $publicacao->duracaoTotal() }} dias</div></div></div>">
                                                </i>
                                            </td>
                                            
                                            <!-- Total de Visualizações -->
                                            <td class="text-center">
                                                <a href="#" data-bs-toggle="modal" data-bs-target="#analyticsModal" data-publicacao-id="{{ $publicacao->id }}" data-publicacao-title="{{ $publicacao->titulo }}" dusk="analytics-button-{{ $publicacao->id }}">
                                                    <i class="ph-fill ph-chart-pie-slice"></i>
                                                </a>
                                                <span class="ms-2">{{ str_pad($publicacao->total_visualizacoes_auditoria ?? 0, 6, '0', STR_PAD_LEFT) }}</span>
                                            </td>
                                            
                                            <!-- Ações -->
                                            <td class="text-center">
                                                @if(in_array($publicacao->status, ['ativa', 'pausada']))
                                                    <a href="#" class="toggle-status-publicacao me-2" 
                                                       data-id="{{ $publicacao->id }}" 
                                                       title="{{ $publicacao->status === 'ativa' ? 'Pausar' : 'Ativar' }}">
                                                        @if($publicacao->status === 'ativa')
                                                            <i class="ph-bold ph-pause-circle text-warning"></i>
                                                        @else
                                                            <i class="ph-bold ph-play-circle text-success"></i>
                                                        @endif
                                                    </a>
                                                    <form id="toggle-status-form-{{ $publicacao->id }}" 
                                                          action="{{ route('publicacoes.toggleStatus', $publicacao) }}" 
                                                          method="POST" 
                                                          style="display: none;">
                                                        @csrf
                                                        @method('PATCH')
                                                    </form>
                                                @endif
                                                
                                                <a href="#" class="delete-publicacao" 
                                                   data-id="{{ $publicacao->id }}" 
                                                   title="Excluir">
                                                    <i class="ph-duotone ph-trash"></i>
                                                </a>
                                                <form id="delete-form-{{ $publicacao->id }}" 
                                                      action="{{ route('publicacoes.destroy', $publicacao) }}" 
                                                      method="POST" 
                                                      style="display: none;">
                                                    @csrf
                                                    @method('DELETE')
                                                </form>
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="8" class="text-center text-muted py-4">
                                                <i class="ph-duotone ph-broadcast f-s-48 mb-2"></i>
                                                <p>Nenhuma publicação encontrada.</p>
                                                <a href="{{ route('publicacoes.create') }}" class="btn btn-primary btn-sm">
                                                    <i class="ph-duotone ph-plus me-2"></i>Criar primeira publicação
                                                </a>
                                            </td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>

                        <!-- Paginação -->
                        <div class="d-flex justify-content-between align-items-center mt-4">
                            <div class="text-muted small">
                                @if($publicacoes->total() > 0)
                                    Mostrando {{ $publicacoes->firstItem() }} a {{ $publicacoes->lastItem() }} de {{ $publicacoes->total() }} publicações
                                @else
                                    Nenhuma publicação encontrada
                                @endif
                            </div>

                            @if($publicacoes->hasPages())
                                <div>
                                    {{ $publicacoes->links() }}
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Analytics Modal -->
    <div class="modal fade" id="analyticsModal" tabindex="-1" aria-labelledby="analyticsModalLabel" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title d-flex align-items-center gap-2" id="analyticsModalLabel">
                        <i class="ph-duotone ph-chart-line"></i>
                        <span>Visualizações da publicação</span>
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body" id="analyticsModalBody">
                    <div class="text-center py-5">
                        <div class="spinner-border text-primary" role="status">
                            <span class="visually-hidden">Carregando...</span>
                        </div>
                        <p class="mt-3 text-muted">Carregando estatísticas...</p>
                    </div>
                </div>
                <div class="modal-footer">
                    <a href="#" id="verEstatisticasCompletas" class="btn btn-primary" target="_blank">
                        <i class="ph-duotone ph-chart-bar me-2"></i>Ver Estatísticas Completas
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal de Preview do Criativo -->
    <div class="modal fade" id="previewModal" tabindex="-1" aria-labelledby="previewModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered preview-modal-dialog">
            <div class="modal-content preview-modal-content">
                <div class="modal-header border-0">
                    <h5 class="modal-title" id="previewModalLabel">
                        <i class="ph-duotone ph-images-square me-2"></i>
                        <span id="previewTitle">Preview do Criativo</span>
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body text-center p-4" id="previewBody" style="min-height: 400px;">
                    <!-- Preloader -->
                    <div class="preview-loader">
                        <i class="ph-duotone ph-circle-notch ph-spin f-s-48 mb-3"></i>
                        <p>Carregando preview...</p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @if(session('success'))
        <script>
            document.addEventListener('DOMContentLoaded', function() {
                alert('{{ session('success') }}');
            });
        </script>
    @endif
    
    <!-- Modal Preview Fix - Solução JavaScript Inline -->
    <script src="{{ asset('js/modal-preview-fix.js') }}"></script>
@endsection

@push('styles')
<style>
    .hover-scale {
        transition: transform 0.2s ease;
        cursor: pointer;
    }
    .hover-scale:hover {
        transform: scale(1.1);
        box-shadow: 0 4px 12px rgba(0,0,0,0.2);
    }
    
    /* Estilo do preloader */
    .preview-loader {
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        min-height: 400px;
    }
    
    /* Animação de rotação para o ícone */
    @keyframes spin {
        from {
            transform: rotate(0deg);
        }
        to {
            transform: rotate(360deg);
        }
    }
    
    .ph-spin {
        animation: spin 1s linear infinite;
        display: inline-block;
    }

    .analytics-card-col {
        display: flex;
    }

    .analytics-modal-card {
        background-color: #E8E0D3;
        border: none;
        color: #1E335C;
        height: 100%;
        display: flex;
        flex-direction: column;
    }
    .analytics-modal-card .card-title,
    .analytics-modal-card h3,
    .analytics-modal-card p,
    .analytics-modal-card small {
        color: #1E335C;
    }
    .analytics-modal-card .text-muted {
        color: rgba(30, 51, 92, 0.7) !important;
    }

    .analytics-modal-card .card-body {
        flex: 1 1 auto;
        display: flex;
        flex-direction: column;
        justify-content: space-between;
    }

    /* Modal backdrop mais escuro */
    #previewModal ~ .modal-backdrop {
        background-color: rgba(0, 0, 0, 0.9) !important;
    }

    .modal-backdrop.show {
        opacity: 1 !important;
    }
    
    /* Background do modal adaptado ao tema */
    .preview-modal-content {
        background: var(--bs-body-bg) !important;
    }

    /* Tema escuro: fundo preto semi-transparente */
    [data-pc-theme="dark"] .preview-modal-content,
    [data-theme="dark"] .preview-modal-content {
        background: rgba(0, 0, 0, 0.95) !important;
    }

    /* Sombra suave na imagem */
    #previewModal img {
        box-shadow: 0 10px 40px rgba(0, 0, 0, 0.3);
    }

    /* Tema escuro: sombra mais forte */
    [data-pc-theme="dark"] #previewModal img,
    [data-theme="dark"] #previewModal img {
        box-shadow: 0 10px 40px rgba(0, 0, 0, 0.7);
    }
    
    /* ============================================== */
    /* MODAL DIALOG - ESPECIFICIDADE MÁXIMA          */
    /* ============================================== */

    /* Sobrescrever Bootstrap com máxima especificidade */
    div#previewModal.modal .modal-dialog.modal-dialog-centered.preview-modal-dialog,
    #previewModal.show .modal-dialog.preview-modal-dialog,
    #previewModal .modal-dialog.preview-modal-dialog {
        max-width: 90vw !important;
        width: auto !important;
        margin: 1.75rem auto !important;
        display: flex !important;
        align-items: center !important;
        min-height: calc(100vh - 3.5rem) !important;
    }

    /* Modal content - FORÇAR LIMITAÇÃO COM ESPECIFICIDADE TRIPLA */
    div#previewModal.modal .modal-dialog .modal-content,
    #previewModal.show .modal-content,
    #previewModal .modal-content {
        width: auto !important;
        max-width: 100% !important;
        overflow: hidden !important;
        display: flex !important;
        flex-direction: column !important;
        box-sizing: border-box !important;
    }
    
    /* Modal body - PROTEÇÃO EXTRA COM ESPECIFICIDADE MÁXIMA */
    div#previewModal.modal .modal-body,
    #previewModal.show .modal-body,
    #previewModal .modal-body {
        width: auto !important;
        max-width: 100% !important;
        padding: 1.5rem !important;
        overflow: hidden !important;
        display: flex !important;
        justify-content: center !important;
        align-items: center !important;
        box-sizing: border-box !important;
        min-height: 400px !important;
    }

    /* Tema escuro: texto branco */
    [data-pc-theme="dark"] #previewModal .modal-body,
    [data-theme="dark"] #previewModal .modal-body {
        color: #fff !important;
    }

    /* Tema escuro: botão fechar branco */
    [data-pc-theme="dark"] #previewModal .btn-close,
    [data-theme="dark"] #previewModal .btn-close {
        filter: invert(1) grayscale(100%) brightness(200%);
    }
    
    /* Container wrapper para a imagem - LIMITAÇÃO FORÇADA */
    div#previewModal.modal .modal-body > *,
    #previewModal.show .modal-body > *,
    #previewModal .modal-body > * {
        max-width: 100% !important;
        max-height: 80vh !important;
        width: auto !important;
        height: auto !important;
        flex-shrink: 1 !important;
    }
    
    /* Imagem do preview - ESPECIFICIDADE MÁXIMA + PROTEÇÃO QUÁDRUPLA */
    div#previewModal.modal .modal-body img,
    #previewModal.show .modal-body img,
    #previewModal .modal-body img,
    #previewModal img {
        max-height: 80vh !important;
        max-width: 100% !important;
        width: auto !important;
        height: auto !important;
        display: block !important;
        margin: 0 auto !important;
        box-shadow: 0 10px 40px rgba(0, 0, 0, 0.5) !important;
        border-radius: 8px !important;
        object-fit: contain !important;
        flex-shrink: 1 !important;
    }
    
    /* Vídeo do preview - ESPECIFICIDADE MÁXIMA */
    div#previewModal.modal .modal-body video,
    #previewModal.show .modal-body video,
    #previewModal .modal-body video,
    #previewModal video {
        max-height: 80vh !important;
        max-width: 100% !important;
        width: auto !important;
        height: auto !important;
        display: block !important;
        margin: 0 auto !important;
        border-radius: 8px !important;
        object-fit: contain !important;
        flex-shrink: 1 !important;
    }
    
    /* Animação de fade in */
    @keyframes fadeIn {
        from {
            opacity: 0;
            transform: scale(0.9);
        }
        to {
            opacity: 1;
            transform: scale(1);
        }
    }
    
    /* Media queries para garantir responsividade em todos os dispositivos */
    @media (max-width: 768px) {
        div#previewModal.modal .modal-dialog.preview-modal-dialog,
        #previewModal .modal-dialog.preview-modal-dialog {
            max-width: 95vw !important;
            width: 95vw !important;
            margin: 0.5rem auto !important;
        }
        
        div#previewModal.modal .modal-content,
        #previewModal .modal-content {
            max-width: 100% !important;
        }
        
        div#previewModal.modal .modal-body,
        #previewModal .modal-body {
            padding: 0.5rem !important;
        }
        
        div#previewModal.modal img,
        div#previewModal.modal video,
        #previewModal img,
        #previewModal video {
            max-height: 70vh !important;
            border-radius: 4px !important;
        }
    }
    
    @media (max-width: 576px) {
        div#previewModal.modal .modal-dialog.preview-modal-dialog,
        #previewModal .modal-dialog.preview-modal-dialog {
            max-width: 100vw !important;
            width: 100vw !important;
            margin: 0 !important;
        }
        
        div#previewModal.modal .modal-content,
        #previewModal .modal-content {
            max-width: 100vw !important;
            border-radius: 0 !important;
        }
        
        div#previewModal.modal img,
        div#previewModal.modal video,
        #previewModal img,
        #previewModal video {
            max-height: 60vh !important;
            border-radius: 0 !important;
        }
    }

</style>
@endpush

@push('scripts')
<!-- Modal Preview Fix - Solução JavaScript Inline -->
<script src="{{ asset('js/modal-preview-fix.js') }}"></script>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        // Inicializar popovers do Bootstrap
        const popoverTriggerList = document.querySelectorAll('[data-bs-toggle="popover"]');
        const popoverList = [...popoverTriggerList].map(popoverTriggerEl => new bootstrap.Popover(popoverTriggerEl, {
            trigger: 'hover focus',
            html: true
        }));
        
        // Main page actions - using event delegation
        document.body.addEventListener('click', function(event) {
            // Delete publicacao
            const deleteBtn = event.target.closest('.delete-publicacao');
            if (deleteBtn) {
                event.preventDefault();
                let publicacaoId = deleteBtn.dataset.id;
                if (confirm('Tem certeza que deseja excluir esta publicação?')) {
                    document.getElementById('delete-form-' + publicacaoId).submit();
                }
            }

            // Toggle status
            const toggleBtn = event.target.closest('.toggle-status-publicacao');
            if (toggleBtn) {
                event.preventDefault();
                let publicacaoId = toggleBtn.dataset.id;
                document.getElementById('toggle-status-form-' + publicacaoId).submit();
            }
        });
        
        // Analytics Modal
        const analyticsModal = document.getElementById('analyticsModal');
        if(analyticsModal) {
            analyticsModal.addEventListener('show.bs.modal', function (event) {
                const button = event.relatedTarget;
                const publicacaoId = button.getAttribute('data-publicacao-id');
                const publicacaoTitle = button.getAttribute('data-publicacao-title');
                const modalTitle = document.querySelector('#analyticsModalLabel');
                const modalBody = document.querySelector('#analyticsModalBody');
                const linkEstatisticas = document.querySelector('#verEstatisticasCompletas');

                // Atualizar título do modal
                modalTitle.innerHTML = `
                    <i class="ph-duotone ph-chart-line"></i>
                    <span>Visualizações: ${publicacaoTitle}</span>
                `;

                // Atualizar link de estatísticas completas
                linkEstatisticas.href = `/publicacoes/${publicacaoId}/estatisticas`;

                // Mostrar loading
                modalBody.innerHTML = `
                    <div class="text-center py-5">
                        <div class="spinner-border text-primary" role="status">
                            <span class="visually-hidden">Carregando...</span>
                        </div>
                        <p class="mt-3 text-muted">Carregando estatísticas...</p>
                    </div>
                `;

                // Carregar dados via AJAX
                fetch(`/publicacoes/${publicacaoId}/analytics-json`)
                    .then(response => response.json())
                    .then(data => {
                        // Renderizar conteúdo
                        const html = `
                            <div class="row g-3">
                                <!-- Estatísticas Gerais -->
                                <div class="col-12 col-md-6 analytics-card-col">
                                    <div class="card border-0 shadow-sm analytics-modal-card w-100">
                                        <div class="card-body">
                                            <h6 class="card-title mb-3">
                                                <i class="ph-duotone ph-eye me-2 text-primary"></i>
                                                ${data.stats.usando_dados_detalhados ? 'Impressões' : 'Visualizações'}
                                            </h6>
                                            <h3 class="mb-0">${data.stats.total_impressoes.toLocaleString('pt-BR')}</h3>
                                            <small class="text-muted">
                                                ${data.stats.total_usuarios_unicos > 0 ? `
                                                    <i class="ph ph-users me-1"></i>
                                                    ${data.stats.total_usuarios_unicos.toLocaleString('pt-BR')} usuários únicos
                                                ` : `
                                                    <i class="ph ph-chart-line me-1"></i>
                                                    Total acumulado
                                                `}
                                            </small>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-12 col-md-6 analytics-card-col">
                                    <div class="card border-0 shadow-sm analytics-modal-card w-100">
                                        <div class="card-body">
                                            <h6 class="card-title mb-3">
                                                <i class="ph-duotone ph-cursor-click me-2 text-success"></i>
                                                Cliques
                                            </h6>
                                            <h3 class="mb-0">${data.stats.total_cliques.toLocaleString('pt-BR')}</h3>
                                            <small class="text-muted">
                                                <i class="ph ph-percent me-1"></i>
                                                CTR: ${data.stats.ctr}%
                                            </small>
                                        </div>
                                    </div>
                                </div>

                                <div class="w-100 d-none d-md-block"></div>

                                <div class="col-12 col-md-6 analytics-card-col">
                                    <div class="card border-0 shadow-sm analytics-modal-card w-100">
                                        <div class="card-body">
                                            <h6 class="card-title mb-3">
                                                <i class="ph-duotone ph-chart-line me-2 text-info"></i>
                                                Média Diária
                                            </h6>
                                            <p class="mb-1">
                                                <strong>${data.stats.media_diaria_impressoes.toLocaleString('pt-BR')}</strong> impressões/dia
                                            </p>
                                            <p class="mb-0">
                                                <strong>${data.stats.media_diaria_cliques.toLocaleString('pt-BR')}</strong> cliques/dia
                                            </p>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-12 col-md-6 analytics-card-col">
                                    <div class="card border-0 shadow-sm analytics-modal-card w-100">
                                        <div class="card-body">
                                            <h6 class="card-title mb-3">
                                                <i class="ph-duotone ph-calendar me-2 text-warning"></i>
                                                Período
                                            </h6>
                                            <p class="mb-1">
                                                <small class="text-muted">Início:</small> ${data.publicacao.data_inicio}
                                            </p>
                                            <p class="mb-0">
                                                <small class="text-muted">Fim:</small> ${data.publicacao.data_fim}
                                            </p>
                                        </div>
                                    </div>
                                </div>

                                <!-- Impressões Recentes -->
                                ${data.impressoes_recentes.length > 0 ? `
                                <div class="col-12">
                                    <div class="card border-0 shadow-sm analytics-modal-card">
                                        <div class="card-body">
                                            <h6 class="card-title mb-3">
                                                <i class="ph-duotone ph-chart-bar me-2"></i>
                                                Últimos 7 Dias
                                            </h6>
                                            <div class="table-responsive">
                                                <table class="table table-sm table-hover">
                                                    <thead>
                                                        <tr>
                                                            <th>Data</th>
                                                            <th class="text-end">Impressões</th>
                                                            <th class="text-end">Usuários</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        ${data.impressoes_recentes.map(item => `
                                                            <tr>
                                                                <td>${new Date(item.data).toLocaleDateString('pt-BR')}</td>
                                                                <td class="text-end">${item.total_impressoes.toLocaleString('pt-BR')}</td>
                                                                <td class="text-end">${item.total_usuarios.toLocaleString('pt-BR')}</td>
                                                            </tr>
                                                        `).join('')}
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                ` : (
                                data.stats.usando_dados_detalhados
                                    ? `
                                        <div class="col-12">
                                            <div class="alert alert-info mb-0">
                                                <i class="ph-duotone ph-info me-2"></i>
                                                Nenhuma impressão registrada nos últimos 7 dias.
                                            </div>
                                        </div>
                                    `
                                    : ''
                                )}

                                <!-- Lista de Usuários que Viram a Splash -->
                                ${data.logs_acesso && data.logs_acesso.length > 0 ? `
                                <div class="col-12">
                                    <div class="card border-0 shadow-sm analytics-modal-card">
                                        <div class="card-body">
                                            <h6 class="card-title mb-3">
                                                <i class="ph-duotone ph-users me-2"></i>
                                                Usuários que Visualizaram (${data.total_logs} total)
                                            </h6>
                                            <div class="table-responsive">
                                                <table class="table table-sm table-hover">
                                                    <thead>
                                                        <tr>
                                                            <th>Data/Hora</th>
                                                            <th>MAC</th>
                                                            <th>Hotspot</th>
                                                            <th>Origem</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        ${data.logs_acesso.map(log => `
                                                            <tr>
                                                                <td>
                                                                    <small>${log.created_at}</small>
                                                                </td>
                                                                <td>
                                                                    <code class="text-muted">${log.mac_parcial}</code>
                                                                </td>
                                                                <td>
                                                                    <small class="text-muted">${log.hotspot ?? 'N/A'}</small>
                                                                </td>
                                                                <td>
                                                                    ${(log.pag_click && log.pag_click !== '---')
                                                                        ? `<a href="${log.pag_click}" target="_blank" rel="noopener"><small>${log.pag_click}</small></a>`
                                                                        : (log.dispositivo
                                                                            ? `<small class="text-muted">${log.dispositivo}</small>`
                                                                            : '<small class="text-muted">---</small>')}
                                                                </td>
                                                            </tr>
                                                        `).join('')}
                                                    </tbody>
                                                </table>
                                            </div>
                                            ${data.total_logs > 10 ? `
                                                <div class="text-center mt-2">
                                                    <small class="text-muted">
                                                        Mostrando últimos 10 de ${data.total_logs} acessos
                                                    </small>
                                                </div>
                                            ` : ''}
                                        </div>
                                    </div>
                                </div>
                                ` : ''}
                            </div>
                        `;

                        modalBody.innerHTML = html;
                    })
                    .catch(error => {
                        console.error('Erro ao carregar analytics:', error);
                        modalBody.innerHTML = `
                            <div class="alert alert-danger">
                                <i class="ph-duotone ph-warning me-2"></i>
                                Erro ao carregar estatísticas. Tente novamente.
                            </div>
                        `;
                    });
            });
        }
        
        // Preview Modal - COM ESTILOS INLINE VIA JAVASCRIPT
        const previewModal = document.getElementById('previewModal');
        if(previewModal) {
            // Função para aplicar estilos FORÇADOS no modal
            function forceModalStyles(imageWidth = null) {
                const modalDialog = previewModal.querySelector('.modal-dialog');
                const modalContent = previewModal.querySelector('.modal-content');
                const modalBody = previewModal.querySelector('.modal-body');

                if (modalDialog) {
                    let targetWidth;

                    if (imageWidth) {
                        // Se temos a largura da imagem, usar ela + padding (aproximadamente 100px de header/padding)
                        const modalPadding = 100;
                        targetWidth = Math.min(imageWidth + modalPadding, window.innerWidth * 0.9);
                    } else {
                        // Fallback: 80% da largura da viewport
                        targetWidth = Math.floor(window.innerWidth * 0.80);
                    }

                    // FORÇAR estilos inline (maior prioridade)
                    modalDialog.style.cssText = `
                        max-width: ${targetWidth}px !important;
                        width: auto !important;
                        margin: 1.75rem auto !important;
                        display: flex !important;
                        align-items: center !important;
                        min-height: calc(100vh - 3.5rem) !important;
                    `;
                }

                if (modalContent) {
                    modalContent.style.cssText = `
                        max-width: 100% !important;
                        width: auto !important;
                        overflow: hidden !important;
                        box-sizing: border-box !important;
                    `;
                }

                if (modalBody) {
                    modalBody.style.cssText = `
                        max-width: 100% !important;
                        width: auto !important;
                        padding: 1.5rem !important;
                        overflow: hidden !important;
                        display: flex !important;
                        justify-content: center !important;
                        align-items: center !important;
                        box-sizing: border-box !important;
                        min-height: 400px !important;
                    `;
                }
            }
            
            previewModal.addEventListener('show.bs.modal', function (event) {
                const button = event.relatedTarget;
                const mediaPath = button.getAttribute('data-path');
                const mediaTitle = button.getAttribute('data-title');
                const mediaType = button.getAttribute('data-type');
                const modalBody = document.getElementById('previewBody');
                const modalTitle = document.getElementById('previewTitle');
                
                // Atualizar título
                modalTitle.textContent = mediaTitle || 'Preview do Criativo';
                
                // Mostrar preloader
                modalBody.innerHTML = `
                    <div class="preview-loader">
                        <i class="ph-duotone ph-circle-notch ph-spin f-s-48 text-white mb-3"></i>
                        <p class="text-white">Carregando preview...</p>
                    </div>
                `;
                
                // APLICAR estilos forçados no modal
                setTimeout(() => forceModalStyles(), 50);
                
                // Criar elemento de preview
                setTimeout(function() {
                    if (mediaType === 'imagem' || mediaType === 'image') {
                        const img = document.createElement('img');
                        img.src = mediaPath;
                        img.alt = mediaTitle;
                        
                        // APLICAR ESTILOS INLINE DIRETO NA IMAGEM (garante 100%)
                        img.style.cssText = `
                            max-width: 100% !important;
                            max-height: 75vh !important;
                            width: auto !important;
                            height: auto !important;
                            display: block !important;
                            margin: 0 auto !important;
                            object-fit: contain !important;
                            border-radius: 8px !important;
                            box-shadow: 0 10px 40px rgba(0, 0, 0, 0.5) !important;
                        `;
                        
                        img.onload = function() {
                            modalBody.innerHTML = '';
                            modalBody.appendChild(img);

                            // Obter largura natural da imagem
                            const imageNaturalWidth = img.naturalWidth;
                            const maxHeight = window.innerHeight * 0.75; // 75vh

                            // Calcular largura proporcional se a altura for limitada
                            let displayWidth = imageNaturalWidth;
                            if (img.naturalHeight > maxHeight) {
                                const aspectRatio = imageNaturalWidth / img.naturalHeight;
                                displayWidth = maxHeight * aspectRatio;
                            }

                            // RE-APLICAR estilos após inserção (garante que não foi sobrescrito)
                            img.style.cssText = `
                                max-width: 100% !important;
                                max-height: 75vh !important;
                                width: auto !important;
                                height: auto !important;
                                display: block !important;
                                margin: 0 auto !important;
                                object-fit: contain !important;
                                border-radius: 8px !important;
                                box-shadow: 0 10px 40px rgba(0, 0, 0, 0.5) !important;
                                animation: fadeIn 0.3s ease-in !important;
                            `;

                            // FORÇAR estilos do modal com a largura da imagem
                            forceModalStyles(displayWidth);

                            // Log para debug
                            console.log('🖼️ Imagem carregada:', {
                                naturalWidth: img.naturalWidth,
                                naturalHeight: img.naturalHeight,
                                displayWidth: displayWidth,
                                calculatedModalWidth: Math.min(displayWidth + 100, window.innerWidth * 0.9),
                                modalWidth: previewModal.querySelector('.modal-dialog').offsetWidth,
                                bodyWidth: modalBody.offsetWidth
                            });
                        };
                        
                        img.onerror = function() {
                            modalBody.innerHTML = '<div class="alert alert-danger">Erro ao carregar imagem</div>';
                        };
                        
                        modalBody.appendChild(img);
                    } else if (mediaType === 'video') {
                        const video = document.createElement('video');
                        video.src = mediaPath;
                        video.controls = true;
                        video.style.maxHeight = '80vh';
                        video.style.maxWidth = '100%';
                        video.style.borderRadius = '8px';
                        modalBody.innerHTML = '';
                        modalBody.appendChild(video);
                    }
                }, 100);
            });
            
            // Listener para redimensionamento de janela
            window.addEventListener('resize', function() {
                if (previewModal.classList.contains('show')) {
                    forceModalStyles();
                }
            });
            
            // Forçar estilos quando o modal terminar de abrir (evento shown)
            previewModal.addEventListener('shown.bs.modal', function() {
                forceModalStyles();
                
                // Re-aplicar estilos na imagem também
                const img = previewModal.querySelector('.modal-body img');
                if (img) {
                    img.style.cssText = `
                        max-width: 100% !important;
                        max-height: 75vh !important;
                        width: auto !important;
                        height: auto !important;
                        display: block !important;
                        margin: 0 auto !important;
                        object-fit: contain !important;
                        border-radius: 8px !important;
                        box-shadow: 0 10px 40px rgba(0, 0, 0, 0.5) !important;
                    `;
                }
            });
        }
    });
</script>
@endpush
