@extends('layouts.master')
@section('title', 'Publicação - ' . $publicacao->titulo)

@section('main-content')
    <div class="container-fluid">
        <!-- Breadcrumb -->
        <div class="row m-1">
            <div class="col-12">
                <h5><i class="ph-duotone ph-broadcast f-s-16 me-2"></i>Detalhes da Publicação</h5>
                <ul class="app-line-breadcrumbs mb-3">
                    <li>
                        <a href="{{ route('publicacoes.index') }}" class="f-s-14 f-w-500">
                            <span>Publicações</span>
                        </a>
                    </li>
                    <li class="active">
                        <a href="#" class="f-s-14 f-w-500">{{ \Illuminate\Support\Str::limit($publicacao->titulo, 30) }}</a>
                    </li>
                </ul>
            </div>
        </div>

        <div class="row">
            <div class="col-12">
                <div class="card card-campanha" style="background-color:#F7F3EC;border-color:#F7F3EC;color:#1E335C;">
                    <div class="card-body">
                        <div class="row align-items-center">
                            <div class="col-md-8">
                                <h4 class="mb-2" style="color:#1E335C;">{{ $publicacao->titulo }}</h4>
                                <p class="text-muted mb-2" style="color:rgba(30,51,92,0.75) !important;">
                                    <i class="ph-duotone ph-calendar me-1"></i>
                                    {{ $publicacao->data_inicio->format('d/m/Y') }} até {{ $publicacao->data_fim->format('d/m/Y') }}
                                    <span class="mx-2">•</span>
                                    <span class="badge bg-{{ $publicacao->status === 'ativa' ? 'success' : 'secondary' }}">
                                        {{ ucfirst($publicacao->status) }}
                                    </span>
                                </p>
                                <p class="text-muted mb-0" style="color:rgba(30,51,92,0.75) !important;">
                                    <i class="ph-duotone ph-user me-1"></i>
                                    <strong>Cliente:</strong> {{ $publicacao->cliente->name ?? 'N/A' }}
                                    <span class="mx-2">•</span>
                                    <strong>Franquia:</strong> {{ $publicacao->franquia->name ?? 'N/A' }}
                                </p>
                            </div>
                            <div class="col-md-4 text-end d-flex justify-content-end gap-2">
                                <a href="{{ route('publicacoes.estatisticas', $publicacao) }}" class="btn btn-outline-secondary">
                                    <i class="ph-duotone ph-chart-line me-1"></i>Ver detalhes da Campanha
                                </a>
                                <a href="{{ route('publicacoes.index') }}" class="btn btn-primary">
                                    <i class="ph-duotone ph-list me-1"></i>Publicações
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-3">
                <div class="card stat-card primary">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="text-muted mb-1">Visualizações</h6>
                                <h2 class="mb-0">{{ number_format($stats['total_visualizacoes'], 0, ',', '.') }}</h2>
                            </div>
                            <div class="text-primary">
                                <i class="ph-duotone ph-eye" style="font-size: 2.5rem;"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card stat-card success">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="text-muted mb-1">Cliques</h6>
                                <h2 class="mb-0">{{ number_format($stats['total_cliques'], 0, ',', '.') }}</h2>
                            </div>
                            <div class="text-success">
                                <i class="ph-duotone ph-cursor-click" style="font-size: 2.5rem;"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card stat-card warning">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="text-muted mb-1">CTR</h6>
                                <h2 class="mb-0">{{ number_format($stats['ctr'], 2, ',', '.') }}%</h2>
                            </div>
                            <div class="text-warning">
                                <i class="ph-duotone ph-target" style="font-size: 2.5rem;"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card stat-card info">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="text-muted mb-1">Walled Gardens Ativos</h6>
                                <h2 class="mb-0">{{ $stats['walled_gardens_ativos'] }}</h2>
                            </div>
                            <div class="text-info">
                                <i class="ph-duotone ph-shield-check" style="font-size: 2.5rem;"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0"><i class="ph-duotone ph-info me-2"></i>Informações Gerais</h5>
                    </div>
                    <div class="card-body">
                        <dl class="row mb-0">
                            <dt class="col-sm-3">Criativo</dt>
                            <dd class="col-sm-9">{{ $publicacao->criativo->title ?? 'N/A' }}</dd>

                            <dt class="col-sm-3">Link de Destino</dt>
                            <dd class="col-sm-9">
                                @if($publicacao->link_destino)
                                    <a href="{{ $publicacao->link_destino }}" target="_blank" rel="noopener">
                                        {{ $publicacao->link_destino }}
                                    </a>
                                @else
                                    <span class="text-muted">—</span>
                                @endif
                            </dd>

                            <dt class="col-sm-3">Tracking</dt>
                            <dd class="col-sm-9">
                                <span class="badge bg-{{ $publicacao->track_impressoes ? 'success' : 'secondary' }} me-2">
                                    Visualizações {{ $publicacao->track_impressoes ? 'habilitadas' : 'desabilitadas' }}
                                </span>
                                <span class="badge bg-{{ $publicacao->track_cliques ? 'success' : 'secondary' }}">
                                    Cliques {{ $publicacao->track_cliques ? 'habilitados' : 'desabilitados' }}
                                </span>
                            </dd>

                            <dt class="col-sm-3">Walled Gardens</dt>
                            <dd class="col-sm-9">
                                {{ $publicacao->walledGardens->count() }} configurado(s)
                                @if($publicacao->walledGardens->count() > 0)
                                    <br>
                                    <a href="{{ route('publicacoes.estatisticas', $publicacao) }}#walled-gardens">
                                        Ver detalhes nas estatísticas
                                    </a>
                                @endif
                            </dd>
                        </dl>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
