#!/bin/bash

# Script para executar todos os testes

echo "=================================="
echo "EXECUTANDO TESTES AUTOMATIZADOS"
echo "=================================="
echo ""

# Cores para output
GREEN='\033[0;32m'
RED='\033[0;31m'
YELLOW='\033[1;33m'
NC='\033[0m' # No Color

# Função para executar testes
run_tests() {
    local test_type=$1
    local command=$2
    
    echo -e "${YELLOW}[TEST] Executando: $test_type${NC}"
    eval $command
    
    if [ $? -eq 0 ]; then
        echo -e "${GREEN}[OK] $test_type passou!${NC}"
    else
        echo -e "${RED}[FAIL] $test_type falhou!${NC}"
    fi
    echo ""
}

# 1. Testes Unitários
run_tests "Testes Unitários" "php artisan test tests/Unit/PublicacaoEstatisticasTest.php"

# 2. Testes Feature
run_tests "Testes Feature" "php artisan test tests/Feature/PublicacaoEstatisticasFeatureTest.php"

# 3. Testes E2E (Dusk)
echo -e "${YELLOW}[TEST] Executando testes E2E com Dusk...${NC}"
php artisan dusk tests/Browser/PublicacaoEstatisticasTest.php
if [ $? -eq 0 ]; then
    echo -e "${GREEN}[OK] Testes E2E passaram!${NC}"
else
    echo -e "${RED}[FAIL] Testes E2E falharam!${NC}"
fi
echo ""

# 4. Coverage Report
echo -e "${YELLOW}[TEST] Gerando relatório de coverage...${NC}"
php artisan test --coverage --coverage-html=tests/coverage

echo ""
echo -e "${GREEN}=================================="
echo "TODOS OS TESTES CONCLUÍDOS!"
echo "==================================${NC}"
