# ============================================
# FreeFi - Script de Remoção (Limpeza)
# ============================================
# 
# PROPÓSITO:
# Remove scripts antigos e schedulers da API antiga
# Usa este script SOMENTE após confirmar que API nova funciona
#
# ⚠️ ATENÇÃO:
# Execute este script APENAS após validar que:
# 1. API nova está funcionando 100%
# 2. Tracking (impressões/cliques) está OK
# 3. Todos hotspots estão sincronizados
#
# RECOMENDAÇÃO:
# Aguardar 7 dias após migração antes de executar
#
# INSTALAÇÃO:
# 1. Copiar este arquivo para Mikrotik
# 2. Importar: /import 4_freefi_remove_old.rsc
# 3. Ou copiar/colar direto no Terminal
#
# DATA: 2025-10-20
# ============================================

:put ""
:put "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"
:put "⚠️  REMOÇÃO DE SCRIPTS ANTIGOS"
:put "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"
:put ""
:put "Este script irá REMOVER:"
:put "  - Scripts antigos da API PHP"
:put "  - Schedulers antigos"
:put "  - Arquivos temporários"
:put ""
:put "⚠️  CERTIFIQUE-SE que API nova está 100% funcional!"
:put ""
:put "Pressione CTRL+C para CANCELAR"
:put "Aguardando 10 segundos..."
:delay 10s

# ============================================
# LISTAR SCRIPTS ATUAIS (ANTES DA REMOÇÃO)
# ============================================

:put ""
:put "📋 Scripts atuais:"
/system script print

# ============================================
# REMOVER SCRIPTS ANTIGOS
# ============================================

:put ""
:put "🗑️  Removendo scripts antigos..."

# Lista de scripts antigos conhecidos (ajustar conforme necessário)
:local oldScripts {
  "freefi_old_splash";
  "splash_old";
  "api_splash";
  "audit_splash";
  "old_freefi";
}

:foreach scriptName in=$oldScripts do={
  :if ([/system script find name=$scriptName] != "") do={
    /system script remove [find name=$scriptName];
    :put ("  ✅ Removido: " . $scriptName);
  } else={
    :put ("  ℹ️  Não encontrado: " . $scriptName);
  }
}

# ============================================
# REMOVER SCHEDULERS ANTIGOS
# ============================================

:put ""
:put "🗑️  Removendo schedulers antigos..."

# Lista de schedulers antigos conhecidos
:local oldSchedulers {
  "freefi-old-scheduler";
  "splash-old";
  "api-old";
}

:foreach schedName in=$oldSchedulers do={
  :if ([/system scheduler find name=$schedName] != "") do={
    /system scheduler remove [find name=$schedName];
    :put ("  ✅ Removido: " . $schedName);
  } else={
    :put ("  ℹ️  Não encontrado: " . $schedName);
  }
}

# ============================================
# REMOVER ARQUIVOS TEMPORÁRIOS
# ============================================

:put ""
:put "🗑️  Removendo arquivos temporários..."

:local oldFiles {
  "splash_old.json";
  "ads_old.txt";
  "audit_old.log";
}

:foreach fileName in=$oldFiles do={
  :if ([/file find name=$fileName] != "") do={
    /file remove $fileName;
    :put ("  ✅ Removido: " . $fileName);
  } else={
    :put ("  ℹ️  Não encontrado: " . $fileName);
  }
}

# ============================================
# VALIDAÇÃO PÓS-REMOÇÃO
# ============================================

:put ""
:put "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"
:put "✅ LIMPEZA CONCLUÍDA!"
:put "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"
:put ""
:put "📋 Scripts ativos:"
/system script print where name~"freefi"
:put ""
:put "📋 Schedulers ativos:"
/system scheduler print where name~"freefi"
:put ""
:put "📋 Arquivos hotspot:"
/file print where name~"hotspot"
:put ""
:put "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"
:put "🎉 Mikrotik 100% migrado para API nova!"
:put "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"

# ============================================
# FIM DO SCRIPT
# ============================================
