<?php $__env->startSection('title', 'Estatísticas - ' . $publicacao->titulo); ?>

<?php $__env->startPush('styles'); ?>
<style>
.stat-card {
    border-left: 4px solid;
    transition: transform 0.2s, box-shadow 0.2s;
}
.stat-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 20px rgba(0,0,0,0.1);
}
.stat-card.primary { border-left-color: #4680ff; }
.stat-card.success { border-left-color: #2ed8b6; }
.stat-card.warning { border-left-color: #ffb64d; }
.stat-card.danger { border-left-color: #ff5370; }
.stat-card.info { border-left-color: #00bcd4; }

.card.card-campanha,
.card-campanha {
    background-color: #F7F3EC !important;
    border-color: #F7F3EC !important;
    color: #1E335C;
}
.card-campanha .card-body {
    background-color: transparent;
}
.card-campanha .card-body h4,
.card-campanha .card-body p,
.card-campanha .card-body span {
    color: #1E335C;
}
.card-campanha .badge {
    background-color: rgba(30, 51, 92, 0.12);
    color: #1E335C;
}
.card-campanha .text-muted {
    color: rgba(30, 51, 92, 0.75) !important;
}

.chart-container {
    position: relative;
    height: 300px;
}
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('main-content'); ?>
    <div class="container-fluid">
        <!-- Breadcrumb -->
        <div class="row m-1">
            <div class="col-12">
                <h5><i class="ph-duotone ph-chart-line f-s-16 me-2"></i>Estatísticas da Publicação</h5>
                <ul class="app-line-breadcrumbs mb-3">
                    <li>
                        <a href="<?php echo e(route('publicacoes.index')); ?>" class="f-s-14 f-w-500">
                            <span>Publicações</span>
                        </a>
                    </li>
                    <li>
                        <a href="<?php echo e(route('publicacoes.show', $publicacao)); ?>" class="f-s-14 f-w-500">
                            <span><?php echo e(Str::limit($publicacao->titulo, 30)); ?></span>
                        </a>
                    </li>
                    <li class="active">
                        <a href="#" class="f-s-14 f-w-500">Estatísticas</a>
                    </li>
                </ul>
            </div>
        </div>

        <!-- Info da Publicação -->
        <div class="row">
            <div class="col-12">
                <div class="card card-campanha" style="background-color:#F7F3EC;border-color:#F7F3EC;color:#1E335C;">
                    <div class="card-body">
                        <div class="row align-items-center">
                            <div class="col-md-8">
                                <h4 class="mb-2" style="color:#1E335C;"><?php echo e($publicacao->titulo); ?></h4>
                                <p class="text-muted mb-2" style="color:rgba(30,51,92,0.75) !important;">
                                    <i class="ph-duotone ph-calendar me-1"></i>
                                    <?php echo e($publicacao->data_inicio->format('d/m/Y')); ?> até <?php echo e($publicacao->data_fim->format('d/m/Y')); ?>

                                    <span class="mx-2">•</span>
                                    <span class="badge bg-<?php echo e($publicacao->status === 'ativa' ? 'success' : 'secondary'); ?>">
                                        <?php echo e(ucfirst($publicacao->status)); ?>

                                    </span>
                                </p>
                                <p class="text-muted mb-0" style="color:rgba(30,51,92,0.75) !important;">
                                    <i class="ph-duotone ph-user me-1"></i>
                                    <strong>Cliente:</strong> <?php echo e($publicacao->cliente->name ?? 'N/A'); ?>

                                    <span class="mx-2">•</span>
                                    <strong>Franquia:</strong> <?php echo e($publicacao->franquia->name ?? 'N/A'); ?>

                                </p>
                            </div>
                            <div class="col-md-4 text-end d-flex justify-content-end gap-2">
                                <a href="<?php echo e(route('publicacoes.show', $publicacao)); ?>" class="btn btn-outline-secondary">
                                    <i class="ph-duotone ph-file-text me-1"></i>Resumo da Campanha
                                </a>
                                <a href="<?php echo e(route('publicacoes.index')); ?>" class="btn btn-primary">
                                    <i class="ph-duotone ph-list me-1"></i>Publicações
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Cards de Estatísticas -->
        <div class="row">
            <div class="col-md-3">
                <div class="card stat-card primary">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="text-muted mb-1">Total de Visualizações</h6>
                                <h2 class="mb-0"><?php echo e(number_format($stats['total_impressoes'] ?? 0, 0, ',', '.')); ?></h2>
                            </div>
                            <div class="text-primary">
                                <i class="ph-duotone ph-eye" style="font-size: 3rem;"></i>
                            </div>
                        </div>
                        <small class="text-muted">
                            <i class="ph-duotone ph-trending-up me-1"></i>
                            Média: <?php echo e(number_format($stats['media_diaria_impressoes'] ?? 0, 1, ',', '.')); ?>/dia
                        </small>
                    </div>
                </div>
            </div>

            <div class="col-md-3">
                <div class="card stat-card success">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="text-muted mb-1">Total de Cliques</h6>
                                <h2 class="mb-0"><?php echo e(number_format($stats['total_cliques'] ?? 0, 0, ',', '.')); ?></h2>
                            </div>
                            <div class="text-success">
                                <i class="ph-duotone ph-cursor-click" style="font-size: 3rem;"></i>
                            </div>
                        </div>
                        <small class="text-muted">
                            <i class="ph-duotone ph-trending-up me-1"></i>
                            Média: <?php echo e(number_format($stats['media_diaria_cliques'] ?? 0, 1, ',', '.')); ?>/dia
                        </small>
                    </div>
                </div>
            </div>

            <div class="col-md-3">
                <div class="card stat-card warning">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="text-muted mb-1">CTR (Taxa de Cliques)</h6>
                                <h2 class="mb-0"><?php echo e(number_format($stats['ctr'] ?? 0, 2, ',', '.')); ?>%</h2>
                            </div>
                            <div class="text-warning">
                                <i class="ph-duotone ph-target" style="font-size: 3rem;"></i>
                            </div>
                        </div>
                        <small class="text-muted">
                            <?php if(($stats['ctr'] ?? 0) >= 5): ?>
                                <i class="ph-duotone ph-thumbs-up me-1"></i>
                                Excelente performance!
                            <?php elseif(($stats['ctr'] ?? 0) >= 2): ?>
                                <i class="ph-duotone ph-info me-1"></i>
                                Performance boa
                            <?php else: ?>
                                <i class="ph-duotone ph-warning me-1"></i>
                                Pode melhorar
                            <?php endif; ?>
                        </small>
                    </div>
                </div>
            </div>

            <div class="col-md-3">
                <div class="card stat-card info">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="text-muted mb-1"><?php echo e(isset($stats['usando_dados_detalhados']) && !$stats['usando_dados_detalhados'] ? 'Usuários Únicos' : 'Hotspots Ativos'); ?></h6>
                                <h2 class="mb-0">
                                    <?php if(isset($stats['usando_dados_detalhados']) && !$stats['usando_dados_detalhados']): ?>
                                        <?php echo e(number_format($stats['total_usuarios_logs'] ?? 0, 0, ',', '.')); ?>

                                    <?php else: ?>
                                        <?php echo e(number_format($stats['hotspots_ativos'] ?? 0, 0, ',', '.')); ?>

                                    <?php endif; ?>
                                </h2>
                            </div>
                            <div class="text-info">
                                <i class="ph-duotone <?php echo e(isset($stats['usando_dados_detalhados']) && !$stats['usando_dados_detalhados'] ? 'ph-users' : 'ph-wifi-high'); ?>" style="font-size: 3rem;"></i>
                            </div>
                        </div>
                        <small class="text-muted">
                            <i class="ph-duotone ph-user-list me-1"></i>
                            Usuários únicos
                        </small>
                    </div>
                </div>
            </div>
        </div>

        <!-- Gráficos -->
        <div class="row">
            <!-- Gráfico de Visualizações e Cliques por Dia -->
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0">
                            <i class="ph-duotone ph-chart-line me-2"></i>
                            Visualizações e Cliques - Últimos 30 dias
                        </h5>
                    </div>
                    <div class="card-body">
                        <?php if(!empty($stats['impressoes_por_dia'])): ?>
                        <div class="chart-container">
                            <canvas id="visualizacoesCliquesChart"></canvas>
                        </div>
                        <?php else: ?>
                        <div class="text-center py-5">
                            <i class="ph-duotone ph-chart-line-down text-muted" style="font-size: 3rem;"></i>
                            <p class="text-muted mt-3 mb-0">
                                <small>Nenhum dado disponível para os últimos 30 dias.</small>
                            </p>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- Visualizações por Hora, Top Hotspots e Dados Diários -->
        <div class="row">
            <!-- Gráfico de Visualizações por Hora -->
            <div class="col-md-6">
                <div class="card mb-3">
                    <div class="card-header">
                        <h5 class="mb-0">
                            <i class="ph-duotone ph-clock me-2"></i>
                            Visualizações por Hora do Dia
                        </h5>
                    </div>
                    <div class="card-body">
                        <?php if(isset($stats['visualizacoes_por_hora']) && count($stats['visualizacoes_por_hora']) > 0): ?>
                        <div class="chart-container">
                            <canvas id="visualizacoesPorHoraChart"></canvas>
                        </div>
                        <?php else: ?>
                        <div class="text-center py-5">
                            <i class="ph-duotone ph-clock-countdown text-muted" style="font-size: 3rem;"></i>
                            <p class="text-muted mt-3 mb-0">
                                <small>Nenhuma visualização registrada ainda</small>
                            </p>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>

                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0">
                            <i class="ph-duotone ph-trophy me-2"></i>
                            Top 5 Hotspots - Mais Visualizações
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-hover w-100">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Serial</th>
                                        <th class="text-end">Visualizações</th>
                                        <th class="text-end">Cliques</th>
                                        <th class="text-end">CTR</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__empty_1 = true; $__currentLoopData = $stats['top_hotspots'] ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $hotspot): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td>
                                            <?php if($index === 0): ?>
                                                🥇
                                            <?php elseif($index === 1): ?>
                                                🥈
                                            <?php elseif($index === 2): ?>
                                                🥉
                                            <?php else: ?>
                                                <?php echo e($index + 1); ?>

                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <strong><?php echo e($hotspot->serial); ?></strong>
                                        </td>
                                        <td class="text-end">
                                            <span class="badge bg-success">
                                                <?php echo e(number_format($hotspot->total_visualizacoes, 0, ',', '.')); ?>

                                            </span>
                                        </td>
                                        <td class="text-end">
                                            <span class="badge" style="background-color:#ff5370;color:#fff;">
                                                <?php echo e(number_format($hotspot->total_cliques, 0, ',', '.')); ?>

                                            </span>
                                        </td>
                                        <td class="text-end">
                                            <span class="badge bg-<?php echo e($hotspot->ctr >= 5 ? 'success' : ($hotspot->ctr >= 2 ? 'warning' : 'secondary')); ?>">
                                                <?php echo e(number_format($hotspot->ctr, 2, ',', '.')); ?>%
                                            </span>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="5" class="text-center text-muted py-4">
                                            <i class="ph-duotone ph-info me-2"></i>
                                            Nenhum dado disponível ainda
                                        </td>
                                    </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Dados Diários Detalhados -->
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0">
                            <i class="ph-duotone ph-calendar me-2"></i>
                            Dados por Dia - Últimos 7 dias
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>Data</th>
                                        <th class="text-end">Visualizações</th>
                                        <th class="text-end">Cliques</th>
                                        <th class="text-end">CTR</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
        $dadosDiarios = collect($stats['impressoes_por_dia'] ?? [])
            ->sortByDesc('data')
            ->take(7);
    ?>
                                    <?php $__empty_1 = true; $__currentLoopData = $dadosDiarios; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dia): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td>
                                            <strong><?php echo e(\Carbon\Carbon::parse($dia['data'])->format('d/m/Y')); ?></strong>
                                            <small class="text-muted d-block">
                                                <?php echo e(\Carbon\Carbon::parse($dia['data'])->translatedFormat('l')); ?>

                                            </small>
                                        </td>
                                        <td class="text-end">
                                            <?php echo e(number_format($dia['visualizacoes'], 0, ',', '.')); ?>

                                        </td>
                                        <td class="text-end">
                                            <?php echo e(number_format($dia['cliques'], 0, ',', '.')); ?>

                                        </td>
                                        <td class="text-end">
                                            <?php
                                                $baseCtr = $dia['visualizacoes'] > 0 ? $dia['visualizacoes'] : $dia['impressoes'];
                                                $ctrDia = $baseCtr > 0
                                                    ? ($dia['cliques'] / $baseCtr) * 100
                                                    : 0;
                                            ?>
                                            <span class="badge bg-<?php echo e($ctrDia >= 5 ? 'success' : ($ctrDia >= 2 ? 'warning' : 'secondary')); ?>">
                                                <?php echo e(number_format($ctrDia, 2, ',', '.')); ?>%
                                            </span>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="4" class="text-center text-muted py-4">
                                            <i class="ph-duotone ph-info me-2"></i>
                                            Nenhum dado disponível ainda
                                        </td>
                                    </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

        </div>

        <!-- Lista de Usuários que Visualizaram -->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0">
                            <i class="ph-duotone ph-users me-2"></i>
                            Usuários que Visualizaram a Publicação
                            <?php if(isset($stats['total_usuarios_logs']) && $stats['total_usuarios_logs'] > 0): ?>
                                (<?php echo e($stats['total_usuarios_logs']); ?> <?php echo e($stats['total_usuarios_logs'] == 1 ? 'usuário único' : 'usuários únicos'); ?>)
                            <?php endif; ?>
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>Data/Hora</th>
                                        <th>MAC</th>
                                        <th>IP</th>
                                        <th>Hotspot</th>
                                        <th>Página Clicada</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__empty_1 = true; $__currentLoopData = $logsPaginados ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $log): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td>
                                            <small><?php echo e(\Carbon\Carbon::parse($log->created_at)->format('d/m/Y H:i')); ?></small>
                                        </td>
                                        <td>
                                            <code class="text-muted" title="<?php echo e($log->cl_mac_address ?? '---'); ?>"><?php echo e(substr($log->cl_mac_address ?? '---', 0, 8)); ?>***<?php echo e(substr($log->cl_mac_address ?? '---', -2)); ?></code>
                                        </td>
                                        <td>
                                            <small>---</small>
                                        </td>
                                        <td>
                                            <small class="text-muted"><?php echo e($log->hs_serial ?? 'N/A'); ?></small>
                                        </td>
                                        <td>
                                            <?php if($log->pag_click && $log->pag_click !== '---'): ?>
                                                <a href="<?php echo e($log->pag_click); ?>" target="_blank" rel="noopener" title="<?php echo e($log->pag_click); ?>">
                                                    <small><?php echo e(Str::limit($log->pag_click, 40)); ?></small>
                                                </a>
                                            <?php else: ?>
                                                <small class="text-muted">---</small>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="7" class="text-center text-muted py-4">
                                            <i class="ph-duotone ph-info me-2"></i>
                                            Nenhum registro de visualização disponível ainda
                                        </td>
                                    </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>

                        <!-- Paginação -->
                        <?php if($logsPaginados && $logsPaginados->hasPages()): ?>
                        <div class="d-flex justify-content-between align-items-center mt-3">
                            <div>
                                <small class="text-muted">
                                    Mostrando
                                    <strong><?php echo e($logsPaginados->firstItem()); ?></strong> a
                                    <strong><?php echo e($logsPaginados->lastItem()); ?></strong> de
                                    <strong><?php echo e($logsPaginados->total()); ?></strong> registros
                                </small>
                            </div>
                        </div>

                        <nav aria-label="Paginação de usuários">
                            <?php echo e($logsPaginados->links('pagination::bootstrap-5', ['queryStringParameter' => 'page_logs'])); ?>

                        </nav>
                        <?php elseif($logsPaginados && $logsPaginados->total() > 0): ?>
                        <div class="text-center mt-3">
                            <small class="text-muted">
                                <i class="ph-duotone ph-info me-1"></i>
                                Total de <?php echo e($logsPaginados->total()); ?> registros
                            </small>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- Walled Gardens (se houver) -->
        <?php if($publicacao->walledGardens && $publicacao->walledGardens->count() > 0): ?>
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0">
                            <i class="ph-duotone ph-shield-check me-2"></i>
                            Walled Gardens Configurados
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <?php $__currentLoopData = $publicacao->walledGardens; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $wg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-md-4 mb-3">
                                <div class="card h-100" style="background-color:#F7F3EC;">
                                    <div class="card-body">
                                        <div class="d-flex align-items-start">
                                            <div class="me-3">
                                                <?php if($wg->tipo === 'domain'): ?>
                                                    <i class="ph-duotone ph-globe text-primary" style="font-size: 2rem;"></i>
                                                <?php elseif($wg->tipo === 'ip'): ?>
                                                    <i class="ph-duotone ph-broadcast text-success" style="font-size: 2rem;"></i>
                                                <?php else: ?>
                                                    <i class="ph-duotone ph-network text-info" style="font-size: 2rem;"></i>
                                                <?php endif; ?>
                                            </div>
                                            <div class="flex-grow-1">
                                                <h6 class="mb-1">
                                                    <?php if($wg->tipo === 'domain'): ?>
                                                        🌐 Domínio
                                                    <?php elseif($wg->tipo === 'ip'): ?>
                                                        📡 IP
                                                    <?php else: ?>
                                                        🔒 Subnet
                                                    <?php endif; ?>
                                                </h6>
                                                <code class="d-block mb-2" style="background-color: transparent; color: #1E335C;"><?php echo e($wg->endereco); ?></code>
                                                <?php if($wg->descricao): ?>
                                                <small style="color:#1E335C;"><?php echo e($wg->descricao); ?></small>
                                                <?php endif; ?>
                                                <div class="mt-2">
                                                    <span class="badge bg-<?php echo e($wg->ativo ? 'success' : 'secondary'); ?>">
                                                        <?php echo e($wg->ativo ? 'Ativo' : 'Inativo'); ?>

                                                    </span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.0/dist/chart.umd.min.js"></script>
<script>
    // Dados para os gráficos
    const visualizacoesImpressoesPorDia = <?php echo json_encode($stats['impressoes_por_dia'] ?? [], 15, 512) ?>;
    const visualizacoesPorHora = <?php echo json_encode($stats['visualizacoes_por_hora'] ?? [], 15, 512) ?>;

    // Configuração comum de cores
    const colors = {
        primary: '#4680ff',
        success: '#2ed8b6',
        warning: '#ffb64d',
        danger: '#ff5370',
        info: '#00bcd4'
    };

    // Gráfico de Visualizações e Cliques por Dia
    const ctxVisualizacoesCliques = document.getElementById('visualizacoesCliquesChart');
    if (ctxVisualizacoesCliques) {
        new Chart(ctxVisualizacoesCliques, {
            type: 'line',
            data: {
                labels: visualizacoesImpressoesPorDia.map(d => {
                    const date = new Date(d.data);
                    return date.toLocaleDateString('pt-BR', { day: '2-digit', month: '2-digit' });
                }),
                datasets: [
                    {
                        label: 'Visualizações',
                        data: visualizacoesImpressoesPorDia.map(d => d.visualizacoes),
                        borderColor: colors.info,
                        backgroundColor: colors.info + '20',
                        tension: 0.4,
                        fill: true
                    },
                    {
                        label: 'Cliques',
                        data: visualizacoesImpressoesPorDia.map(d => d.cliques),
                        borderColor: colors.danger,
                        backgroundColor: colors.danger + '20',
                        tension: 0.4,
                        fill: true
                    }
                ]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        display: true,
                        position: 'top'
                    },
                    tooltip: {
                        mode: 'index',
                        intersect: false
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: {
                            precision: 0
                        }
                    }
                }
            }
        });
    }

    // Gráfico de Cliques por Hora
    const ctxVisualizacoesPorHora = document.getElementById('visualizacoesPorHoraChart');
    if (ctxVisualizacoesPorHora) {
        new Chart(ctxVisualizacoesPorHora, {
            type: 'bar',
            data: {
                labels: visualizacoesPorHora.map(h => h.hora + 'h'),
                datasets: [{
                    label: 'Visualizações',
                    data: visualizacoesPorHora.map(h => h.total),
                    backgroundColor: colors.primary,
                    borderColor: colors.primary,
                    borderWidth: 1
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        display: false
                    },
                    tooltip: {
                        callbacks: {
                            title: function(context) {
                                return 'Horário: ' + context[0].label;
                            }
                        }
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: {
                            precision: 0
                        }
                    }
                }
            }
        });
    }
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/resources/views/publicacoes/estatisticas.blade.php ENDPATH**/ ?>