<?php $__env->startSection('title', 'Hotspots'); ?>
<?php $__env->startSection('main-content'); ?>
<?php use \Illuminate\Support\Facades\Storage; ?>
    <div class="container-fluid">
        <!-- Breadcrumb start -->
        <div class="row m-1">
            <div class="col-12">
                <h5><i class="ph-duotone ph-wifi-high f-s-16 me-2"></i>Hotspots</h5>
                <ul class="app-line-breadcrumbs mb-3">
                    <li class="">
                        <a href="#" class="f-s-14 f-w-500">
                            <span>Gestão de Hotspots</span>
                        </a>
                    </li>
                    <li class="active">
                        <a href="#" class="f-s-14 f-w-500">Hotspots</a>
                    </li>
                </ul>
            </div>
        </div>
        <!-- Breadcrumb end -->

        <!-- tables start  -->
        <div class="row table-section">
            <div class="col-xl-12">
                <div class="card">
                    <div class="card-header">
                        <div class="d-flex justify-content-between align-items-center">
                            <h5>Hotspots Cadastrados</h5>
                            <div class="d-flex align-items-center gap-2">
                                <!-- Formulário de Busca Avançada -->
                                <form action="<?php echo e(route('hotspots.index')); ?>" method="GET" class="d-flex align-items-center gap-2">
                                    <div class="input-group">
                                        <label class="input-group-text" for="filter_type">
                                            <i class="ph-duotone ph-funnel me-1"></i>Tipo
                                        </label>
                                        <select name="filter_type" id="filter_type" class="form-select" style="max-width: 150px;">
                                            <option value="empresa" <?php echo e(request('filter_type') == 'empresa' ? 'selected' : ''); ?>>Empresa</option>
                                            <option value="marca" <?php echo e(request('filter_type') == 'marca' ? 'selected' : ''); ?>>Marca</option>
                                            <option value="modelo" <?php echo e(request('filter_type') == 'modelo' ? 'selected' : ''); ?>>Modelo</option>
                                            <option value="serial" <?php echo e(request('filter_type') == 'serial' ? 'selected' : ''); ?>>Serial</option>
                                        </select>
                                    </div>
                                    <div class="input-group" style="min-width: 250px;">
                                        <input type="text" 
                                               name="search" 
                                               id="search" 
                                               class="form-control" 
                                               placeholder="Digite o termo para buscar..." 
                                               value="<?php echo e(request('search')); ?>">
                                        <button type="submit" class="btn btn-secondary">
                                            <i class="ph ph-magnifying-glass me-1"></i>Buscar
                                        </button>
                                        <?php if(request('search')): ?>
                                            <a href="<?php echo e(route('hotspots.index')); ?>" class="btn btn-outline-secondary" title="Limpar filtros">
                                                <i class="ph ph-x"></i>
                                            </a>
                                        <?php endif; ?>
                                    </div>
                                </form>
                                
                                <!-- Botões de Ação -->
                                <div class="btn-group">
                                    <a href="<?php echo e(route('hotspots.create')); ?>" class="btn btn-primary">
                                        <i class="ph ph-plus me-1"></i>Novo Hotspot
                                    </a>
                                    <button type="button" class="btn btn-warning" data-bs-toggle="modal" data-bs-target="#trashModalHotspots" title="Lixeira">
                                        <i class="ph ph-trash"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table align-middle mb-0">
                                <thead>
                                <tr>
                                    <th scope="col" class="text-center" width="50">#</th>
                                    <th scope="col">Serial</th>
                                    <th scope="col">Marca</th>
                                    <th scope="col">Modelo</th>
                                    <th scope="col">Franquia</th>
                                    <th scope="col">Cliente</th>
                                    <th scope="col">Situação</th>
                                    <th scope="col">Última Atividade</th>
                                    <th scope="col">IP VPN</th>
                                    <th scope="col" class="text-center" width="30">*</th>
                                    <th scope="col" class="text-center">Ações</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $hotspots; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $hotspot): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td class="text-center">
                                        <span class="<?php if($hotspot->status == 1): ?> opacity-50 <?php endif; ?>">
                                            <?php echo e(($hotspots->currentPage() - 1) * $hotspots->perPage() + $index + 1); ?>

                                        </span>
                                    </td>
                                    <td>
                                        <a href="<?php echo e(route('hotspots.edit', $hotspot)); ?>" 
                                           class="text-decoration-none <?php if($hotspot->status == 1): ?> opacity-50 <?php endif; ?>"
                                           title="Clique para editar">
                                            <code class="text-info" style="font-size: 0.95em; font-weight: 600;">
                                                <?php echo e($hotspot->serial); ?>

                                            </code>
                                        </a>
                                        <?php if($hotspot->status == 1): ?>
                                            <i class="ph ph-power text-danger ms-1" title="Desativado" data-bs-toggle="tooltip"></i>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <span class="<?php if($hotspot->status == 1): ?> opacity-50 <?php endif; ?>">
                                            <?php echo e($hotspot->marca); ?>

                                        </span>
                                    </td>
                                    <td>
                                        <span class="<?php if($hotspot->status == 1): ?> opacity-50 <?php endif; ?>">
                                            <?php echo e($hotspot->modelo); ?>

                                        </span>
                                    </td>
                                    <td>
                                        <span class="<?php if($hotspot->status == 1): ?> opacity-50 <?php endif; ?>">
                                            <?php if($hotspot->franquia): ?>
                                                <i class="ph-fill ph-buildings text-primary me-1"></i>
                                                <?php echo e($hotspot->franquia->name); ?>

                                            <?php else: ?>
                                                <span class="text-muted small">Não definida</span>
                                            <?php endif; ?>
                                        </span>
                                    </td>
                                    <td>
                                        <span class="<?php if($hotspot->status == 1): ?> opacity-50 <?php endif; ?>">
                                            <?php if($hotspot->cliente): ?>
                                                <i class="ph-fill ph-storefront text-success me-1"></i>
                                                <?php echo e($hotspot->cliente->name); ?>

                                            <?php else: ?>
                                                <span class="text-muted small">Não definido</span>
                                            <?php endif; ?>
                                        </span>
                                    </td>
                                    <td>
                                        <?php
                                            $situacaoConfig = [
                                                'estoque' => ['icon' => '📦', 'text' => 'Estoque', 'class' => 'secondary'],
                                                'em_transito' => ['icon' => '🚚', 'text' => 'Em Trânsito', 'class' => 'info'],
                                                'aguardando_instalacao' => ['icon' => '⏳', 'text' => 'Aguardando', 'class' => 'warning'],
                                                'instalado' => ['icon' => '✅', 'text' => 'Instalado', 'class' => 'success'],
                                                'manutencao' => ['icon' => '🔧', 'text' => 'Manutenção', 'class' => 'warning'],
                                                'desativado' => ['icon' => '❌', 'text' => 'Desativado', 'class' => 'danger'],
                                            ];
                                            $currentSituacao = $hotspot->situacao ?? 'instalado';
                                        ?>
                                        <select class="form-select form-select-sm situacao-select" 
                                                data-hotspot-id="<?php echo e($hotspot->id); ?>" 
                                                style="min-width: 130px; max-width: 145px; cursor: pointer;"
                                                <?php if($hotspot->status == 1): ?> disabled <?php endif; ?>>
                                            <?php $__currentLoopData = $situacaoConfig; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $config): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($key); ?>" 
                                                        <?php echo e($currentSituacao == $key ? 'selected' : ''); ?>

                                                        data-icon="<?php echo e($config['icon']); ?>"
                                                        data-class="<?php echo e($config['class']); ?>">
                                                    <?php echo e($config['icon']); ?> <?php echo e($config['text']); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </td>
                                    <td>
                                        <?php if($hotspot->last_activity_at): ?>
                                            <span class="text-muted small">
                                                <?php echo e($hotspot->last_activity_at->format('d/m/Y H:i')); ?>

                                            </span>
                                        <?php else: ?>
                                            <span class="text-muted small">Sem registro</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if($hotspot->vpn_ip): ?>
                                            <code class="text-success <?php if($hotspot->status == 1): ?> opacity-50 <?php endif; ?>" style="font-size: 0.9em;">
                                                <i class="ph-fill ph-plugs-connected me-1"></i><?php echo e($hotspot->vpn_ip); ?>

                                            </code>
                                        <?php else: ?>
                                            <span class="text-muted small">Não configurado</span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="text-center">
                                        <?php if($hotspot->last_activity_at): ?>
                                            <?php
                                                $diffInHours = $hotspot->last_activity_at->diffInHours(now());
                                                
                                                // Definir classe e ícone baseado no tempo
                                                $statusClass = match(true) {
                                                    $diffInHours < 1 => 'success',      // < 1h - Verde
                                                    $diffInHours < 24 => 'info',        // < 24h - Azul
                                                    $diffInHours < 72 => 'warning',     // < 72h - Laranja
                                                    default => 'danger'                  // > 72h - Vermelho
                                                };
                                                
                                                $statusText = match(true) {
                                                    $diffInHours < 1 => 'Ativo agora',
                                                    $diffInHours < 24 => 'Ativo hoje',
                                                    $diffInHours < 72 => 'Atenção',
                                                    default => 'Inativo'
                                                };
                                            ?>
                                            <span class="badge rounded-pill bg-<?php echo e($statusClass); ?>" 
                                                  style="width: 12px; height: 12px; padding: 0;" 
                                                  title="<?php echo e($statusText); ?> - <?php echo e($hotspot->last_activity_at->diffForHumans()); ?>"
                                                  data-bs-toggle="tooltip">
                                            </span>
                                        <?php else: ?>
                                            <span class="badge rounded-pill bg-secondary" 
                                                  style="width: 12px; height: 12px; padding: 0;" 
                                                  title="Nenhuma atividade registrada"
                                                  data-bs-toggle="tooltip">
                                            </span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="text-center">
                                        <a href="#" class="toggle-status me-2" data-id="<?php echo e($hotspot->id); ?>" title="Mudar Status">
                                            <?php if($hotspot->status == 0): ?>
                                                <i class="ph-bold ph-toggle-right text-success"></i>
                                            <?php else: ?>
                                                <i class="ph-bold ph-toggle-left"></i>
                                            <?php endif; ?>
                                        </a>
                                        <a href="#" class="delete-hotspot" data-id="<?php echo e($hotspot->id); ?>" title="Excluir">
                                            <i class="ph-duotone ph-trash"></i>
                                        </a>
                                        <form id="delete-form-<?php echo e($hotspot->id); ?>" action="<?php echo e(route('hotspots.destroy', $hotspot)); ?>" method="POST" style="display: none;">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                        </form>
                                        <form id="toggle-status-form-<?php echo e($hotspot->id); ?>" action="<?php echo e(route('hotspots.toggleStatus', $hotspot)); ?>" method="POST" style="display: none;">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('PATCH'); ?>
                                        </form>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="11" class="text-center">Nenhum hotspot encontrado.</td>
                                </tr>
                                <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <?php if($hotspots->hasPages()): ?>
                        <div class="card-footer">
                            <?php echo e($hotspots->appends(request()->query())->links()); ?>

                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <!-- tables-end  -->

        <!-- Trash Modal -->
        <div class="modal fade" id="trashModalHotspots" tabindex="-1" aria-labelledby="trashModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="trashModalLabel"><i class="ph-duotone ph-trash me-2"></i>Lixeira de Hotspots</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>Marca</th>
                                    <th>Modelo</th>
                                    <th>Serial</th>
                                    <th>Deletado Por</th>
                                    <th>Ação</th>
                                </tr>
                            </thead>
                            <tbody id="trash-list">
                                <tr>
                                    <td colspan="5" class="text-center">Carregando...</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .situacao-select {
        font-weight: 500;
        border: 2px solid transparent;
        transition: all 0.3s ease;
    }
    
    .situacao-select:hover:not(:disabled) {
        border-color: rgba(0,0,0,0.2);
        box-shadow: 0 2px 4px rgba(0,0,0,0.1);
    }
    
    .situacao-select:focus {
        box-shadow: 0 0 0 0.25rem rgba(13, 110, 253, 0.25);
    }
    
    .situacao-select.bg-secondary { background-color: #6c757d !important; }
    .situacao-select.bg-info { background-color: #0dcaf0 !important; }
    .situacao-select.bg-warning { background-color: #ffc107 !important; color: #000 !important; }
    .situacao-select.bg-success { background-color: #198754 !important; }
    .situacao-select.bg-danger { background-color: #dc3545 !important; }
    
    .situacao-select option {
        background-color: white;
        color: #212529;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    $(document).ready(function(){
        // Inicializar tooltips do Bootstrap
        var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
        var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
            return new bootstrap.Tooltip(tooltipTriggerEl);
        });

        // Atualizar placeholder do campo de busca conforme o tipo selecionado
        const placeholders = {
            'empresa': 'Digite o nome da empresa...',
            'marca': 'Digite a marca do hotspot...',
            'modelo': 'Digite o modelo do hotspot...',
            'serial': 'Digite o serial do hotspot...'
        };

        function updatePlaceholder() {
            const filterType = $('#filter_type').val();
            $('#search').attr('placeholder', placeholders[filterType] || 'Digite o termo para buscar...');
        }

        // Atualizar ao carregar a página
        updatePlaceholder();

        // Atualizar ao mudar o select
        $('#filter_type').on('change', function() {
            updatePlaceholder();
            $('#search').focus();
        });

        // Delete hotspot
        $('.delete-hotspot').on('click', function(e){
            e.preventDefault();
            var id = $(this).data('id');
            if(confirm('Tem certeza que deseja excluir este hotspot?')){
                $('#delete-form-'+id).submit();
            }
        });

        // Toggle status
        $('.toggle-status').on('click', function(e){
            e.preventDefault();
            var id = $(this).data('id');
            $('#toggle-status-form-'+id).submit();
        });

        // Update situacao via AJAX
        $('.situacao-select').on('change', function(){
            const select = $(this);
            const hotspotId = select.data('hotspot-id');
            const newSituacao = select.val();
            const originalValue = select.find('option:selected').data('original-value') || select.val();

            // Visual feedback
            select.prop('disabled', true);
            select.css('opacity', '0.6');

            $.ajax({
                url: '/hotspots/' + hotspotId + '/situacao',
                method: 'PATCH',
                data: {
                    _token: '<?php echo e(csrf_token()); ?>',
                    situacao: newSituacao
                },
                success: function(response){
                    // Re-enable select
                    select.prop('disabled', false);
                    select.css('opacity', '1');
                    
                    // Show success message
                    if (typeof toastr !== 'undefined') {
                        toastr.success(response.message);
                    } else {
                        alert(response.message);
                    }

                    // Update background color based on situacao
                    const selectedOption = select.find('option:selected');
                    const bgClass = selectedOption.data('class');
                    
                    // Remove all bg classes
                    select.removeClass('bg-secondary bg-info bg-warning bg-success bg-danger');
                    select.removeClass('text-white');
                    
                    // Add new bg class
                    if (bgClass) {
                        select.addClass('bg-' + bgClass + ' text-white');
                    }
                },
                error: function(xhr){
                    // Restore original value
                    select.val(originalValue);
                    select.prop('disabled', false);
                    select.css('opacity', '1');
                    
                    // Show error message
                    if (typeof toastr !== 'undefined') {
                        toastr.error('Erro ao atualizar situação!');
                    } else {
                        alert('Erro ao atualizar situação!');
                    }
                }
            });
        });

        // Apply initial colors to selects
        $('.situacao-select').each(function(){
            const select = $(this);
            const selectedOption = select.find('option:selected');
            const bgClass = selectedOption.data('class');
            
            if (bgClass) {
                select.addClass('bg-' + bgClass + ' text-white');
            }
        });

        // Load trash
        $('#trashModalHotspots').on('show.bs.modal', function(){
            $.ajax({
                url: '<?php echo e(route("hotspots.trash")); ?>',
                method: 'GET',
                success: function(data){
                    var html = '';
                    if(data.length > 0){
                        data.forEach(function(item){
                            html += '<tr>';
                            html += '<td>'+item.marca+'</td>';
                            html += '<td>'+item.modelo+'</td>';
                            html += '<td><code>'+item.serial+'</code></td>';
                            html += '<td>'+(item.destroyer ? item.destroyer.name : 'N/A')+'</td>';
                            html += '<td>';
                            html += '<form action="<?php echo e(url("hotspots")); ?>/'+item.id+'/restore" method="POST" style="display:inline;">';
                            html += '<?php echo csrf_field(); ?>';
                            html += '<?php echo method_field("PATCH"); ?>';
                            html += '<button type="submit" class="btn btn-sm btn-success"><i class="ph-duotone ph-arrow-counter-clockwise"></i> Restaurar</button>';
                            html += '</form>';
                            html += '</td>';
                            html += '</tr>';
                        });
                    } else {
                        html = '<tr><td colspan="5" class="text-center">Lixeira vazia</td></tr>';
                    }
                    $('#trash-list').html(html);
                }
            });
        });
    });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/resources/views/hotspots/index.blade.php ENDPATH**/ ?>