<!-- GEMINI_TEST_COMMENT_123 -->

<?php $__env->startSection('title', isset($midia) ? 'Editar Mídia' : 'Criar Mídia'); ?>
<?php $__env->startSection('main-content'); ?>
    <div class="container-fluid">
        <!-- Breadcrumb start -->
        <div class="row m-1">
            <div class="col-12">
                <h5><i class="ph-duotone ph-image f-s-16 me-2"></i><?php echo $__env->yieldContent('title'); ?></h5>
                <ul class="app-line-breadcrumbs mb-3">
                    <li class="">
                        <a href="<?php echo e(route('midias.index')); ?>" class="f-s-14 f-w-500">
                            <span>Mídias</span>
                        </a>
                    </li>
                    <li class="active">
                        <a href="#" class="f-s-14 f-w-500"><?php echo $__env->yieldContent('title'); ?></a>
                    </li>
                </ul>
            </div>
        </div>
        <!-- Breadcrumb end -->

        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <h5>Detalhes da Mídia</h5>
                    </div>
                    <div class="card-body">
                        <form class="app-form" action="<?php echo e(isset($midia) ? route('midias.update', $midia) : route('midias.store')); ?>" method="POST" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <?php if(isset($midia)): ?>
                                <?php echo method_field('PUT'); ?>
                            <?php endif; ?>
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="mb-3">
                                        <label class="form-label">Título</label>
                                        <input type="text" name="title" class="form-control" placeholder="Título da Mídia" value="<?php echo e(old('title', $midia->title ?? '')); ?>" required>
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="mb-3">
                                        <label class="form-label">Tipo de Mídia</label>
                                        <select name="type" class="form-control" required>
                                            <option value="image" <?php if(old('type', $midia->tipo ?? $midia->type ?? '') == 'image'): ?> selected <?php endif; ?>>Imagem</option>
                                            <option value="video" <?php if(old('type', $midia->tipo ?? $midia->type ?? '') == 'video'): ?> selected <?php endif; ?>>Vídeo</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="mb-3">
                                        <label class="form-label">Arquivo de Mídia</label>
                                        <input type="file" name="media_file" class="form-control" <?php if(!isset($midia)): ?> required <?php endif; ?>>
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="mb-3">
                                        <label class="form-label">Empresa</label>
                                        <select name="empresa_legado_id" class="form-control" required>
                                            <?php $__currentLoopData = $empresas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $empresa): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($empresa->id); ?>" <?php if(old('empresa_legado_id', $midia->empresa_legado_id ?? '') == $empresa->id): ?> selected <?php endif; ?>><?php echo e($empresa->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="mb-3">
                                        <label class="form-label">Serial do Equipamento</label>
                                        <input type="text" name="equipment_serial" class="form-control" placeholder="Serial do Equipamento" value="<?php echo e(old('equipment_serial', $midia->equipment_serial ?? '')); ?>">
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="mb-3">
                                        <label class="form-label">Posição da Mídia (1-6)</label>
                                        <select name="position" class="form-control">
                                            <option value="">Selecionar Posição</option>
                                            <?php for($i = 1; $i <= 6; $i++): ?>
                                                <option value="<?php echo e($i); ?>" <?php if(old('position', $midia->position ?? '') == $i): ?> selected <?php endif; ?>><?php echo e($i); ?></option>
                                            <?php endfor; ?>
                                        </select>
                                    </div>
                                </div>

                                <div class="col-12"><hr class="my-3"></div>

                                <div class="col-sm-6">
                                    <div class="mb-3">
                                        <label class="form-label">Data e Hora de Início</label>
                                        <input type="datetime-local" name="start_datetime" class="form-control" value="<?php echo e(old('start_datetime', isset($midia) ? \Carbon\Carbon::parse($midia->start_datetime)->format('Y-m-d\TH:i') : '')); ?>">
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="mb-3">
                                        <label class="form-label">Data e Hora de Encerramento</label>
                                        <input type="datetime-local" name="end_datetime" class="form-control" value="<?php echo e(old('end_datetime', isset($midia) ? \Carbon\Carbon::parse($midia->end_datetime)->format('Y-m-d\TH:i') : '')); ?>">
                                    </div>
                                </div>

                                <div class="col-12 text-end">
                                    <div class="btn-group" role="group">
                                        <button type="submit" class="btn btn-success"><i class="ph-duotone ph-floppy-disk me-2"></i>Salvar</button>
                                        <a href="<?php echo e(route('midias.index')); ?>" class="btn btn-secondary"><i class="ph-duotone ph-x-circle me-2"></i>Cancelar</a>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/resources/views/midias/create.blade.php ENDPATH**/ ?>