<?php $__env->startSection('title', 'Nova Empresa'); ?>
<?php $__env->startSection('main-content'); ?>
    <div class="container-fluid">
        <!-- Breadcrumb start -->
        <div class="row m-1">
            <div class="col-12">
                <h5><?php echo $__env->yieldContent('title'); ?></h5>
                <ul class="app-line-breadcrumbs mb-3">
                    <li class="">
                        <a href="<?php echo e(route('empresas.index')); ?>" class="f-s-14 f-w-500">
                            <span><i class="ph-duotone ph-buildings f-s-16"></i> Empresas</span>
                        </a>
                    </li>
                    <li class="active">
                        <a href="#" class="f-s-14 f-w-500"><?php echo $__env->yieldContent('title'); ?></a>
                    </li>
                </ul>
            </div>
        </div>
        <!-- Breadcrumb end -->

        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <h5>Detalhes da Empresa</h5>
                    </div>
                    <div class="card-body">
                        <form class="app-form" action="<?php echo e(route('empresas.store')); ?>" method="POST" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="mb-3">
                                        <label class="form-label">Nome <span class="text-danger">*</span></label>
                                        <input type="text" name="name" class="form-control" placeholder="Nome da Empresa" value="<?php echo e(old('name')); ?>" required>
                                    </div>
                                </div>
                                
                                <div class="col-sm-6">
                                    <div class="mb-3">
                                        <label class="form-label">Tipo de Empresa <span class="text-danger">*</span></label>
                                        <select name="tipo_empresa" class="form-select" required>
                                            <option value="">Selecione o tipo</option>
                                            <option value="matriz" <?php echo e(old('tipo_empresa') == 'matriz' ? 'selected' : ''); ?>>🏛️ Matriz (Sede Principal)</option>
                                            <option value="franquia" <?php echo e(old('tipo_empresa') == 'franquia' ? 'selected' : ''); ?>>🏢 Franquia</option>
                                            <option value="cliente" <?php echo e(old('tipo_empresa') == 'cliente' ? 'selected' : ''); ?>>🏪 Cliente da Franquia</option>
                                        </select>
                                        <small class="form-text text-muted">
                                            <strong>Matriz:</strong> Sede principal da rede<br>
                                            <strong>Franquia:</strong> Unidade franqueada<br>
                                            <strong>Cliente:</strong> Cliente que usa os serviços da franquia
                                        </small>
                                    </div>
                                </div>
                                
                                <div class="col-sm-6">
                                    <div class="mb-3">
                                        <label class="form-label">Empresa Pai (Franquia/Matriz)</label>
                                        <select name="empresa_pai_id" class="form-select">
                                            <option value="">Nenhuma (empresa independente)</option>
                                            <?php $__currentLoopData = \App\Models\Empresa::whereIn('tipo_empresa', ['matriz', 'franquia'])->orderBy('name')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $empresa): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($empresa->id); ?>" <?php echo e(old('empresa_pai_id') == $empresa->id ? 'selected' : ''); ?>>
                                                    <?php echo e($empresa->tipo_empresa == 'matriz' ? '🏛️' : '🏢'); ?> <?php echo e($empresa->name); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <small class="form-text text-muted">Se for cliente, selecione a franquia. Se for franquia, selecione a matriz.</small>
                                    </div>
                                </div>
                                
                                <div class="col-sm-6">
                                    <div class="mb-3">
                                        <label class="form-label">E-mail</label>
                                        <input type="email" name="email" class="form-control" placeholder="E-mail da Empresa" value="<?php echo e(old('email')); ?>">
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="mb-3">
                                        <label class="form-label">Telefone</label>
                                        <input type="text" name="phone" class="form-control" placeholder="Telefone da Empresa" value="<?php echo e(old('phone')); ?>">
                                    </div>
                                </div>
                                <div class="col-sm-12">
                                    <div class="mb-3">
                                        <label class="form-label">Logomarca</label>
                                        <input type="file" name="logomarca" class="form-control" accept="image/*">
                                        <small class="form-text text-muted">Formatos aceitos: JPEG, PNG, JPG, GIF. Tamanho máximo: 2MB. A imagem será redimensionada para máximo 350px de largura.</small>
                                    </div>
                                </div>

                                <div class="col-12 text-end">
                                    <div class="btn-group" role="group">
                                        <button type="submit" class="btn btn-success"><i class="ph-duotone ph-floppy-disk me-2"></i>Salvar</button>
                                        <a href="<?php echo e(route('empresas.index')); ?>" class="btn btn-secondary"><i class="ph-duotone ph-x-circle me-2"></i>Cancelar</a>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    $(document).ready(function(){
        var SPMaskBehavior = function (val) {
          return val.replace(/\D/g, '').length === 11 ? '(00) 00000-0000' : '(00) 0000-00009';
        },
        spOptions = {
          onKeyPress: function(val, e, field, options) {
              field.mask(SPMaskBehavior.apply({}, arguments), options);
            }
        };

        $('input[name="phone"]').mask(SPMaskBehavior, spOptions);
    });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/resources/views/empresas/create.blade.php ENDPATH**/ ?>