<?php $__env->startSection('title', 'Criar Publicação'); ?>
<?php $__env->startSection('main-content'); ?>
    <div class="container-fluid">
        <!-- Breadcrumb -->
        <div class="row m-1">
            <div class="col-12">
                <h5><i class="ph-duotone ph-broadcast f-s-16 me-2"></i>Criar Nova Publicação</h5>
                <ul class="app-line-breadcrumbs mb-3">
                    <li>
                        <a href="<?php echo e(route('publicacoes.index')); ?>" class="f-s-14 f-w-500">
                            <span>Publicações</span>
                        </a>
                    </li>
                    <li class="active">
                        <a href="#" class="f-s-14 f-w-500">Criar</a>
                    </li>
                </ul>
            </div>
        </div>

        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <h5>Detalhes da Publicação</h5>
                    </div>
                    <div class="card-body">
                        <form class="app-form" action="<?php echo e(route('publicacoes.store')); ?>" method="POST">
                            <?php echo csrf_field(); ?>

                            <div class="row">
                                <!-- Criativo -->
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label">Criativo <span class="text-danger">*</span></label>
                                        <select name="criativo_id" id="criativoSelect" class="form-control <?php $__errorArgs = ['criativo_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                                            <option value="">Selecione um criativo...</option>
                                            <?php $__currentLoopData = $criativos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $criativo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($criativo->id); ?>" 
                                                        data-tipo="<?php echo e($criativo->tipo ?? $criativo->type ?? 'imagem'); ?>"
                                                        <?php if(old('criativo_id') == $criativo->id): ?> selected <?php endif; ?>>
                                                    <?php echo e($criativo->title); ?> (<?php echo e(ucfirst($criativo->tipo ?? $criativo->type ?? 'imagem')); ?>)
                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <?php $__errorArgs = ['criativo_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        <small class="form-text text-muted">
                                            Apenas criativos aprovados estão disponíveis
                                        </small>
                                    </div>
                                    
                                    <!-- Preview do Criativo -->
                                    <div id="criativoPreview" class="mt-3" style="display: none;">
                                        <div class="card bg-light">
                                            <div class="card-body text-center p-3">
                                                <h6 class="mb-3">Preview do Criativo</h6>
                                                <div id="previewContent" class="mb-3">
                                                    <!-- Imagem/vídeo será inserido aqui -->
                                                </div>
                                                <div id="previewInfo" class="text-muted small">
                                                    <!-- Informações do criativo -->
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Título e Posição -->
                                <div class="col-md-6">
                                    <!-- Título -->
                                    <div class="mb-3">
                                        <label class="form-label">Título da Campanha <span class="text-danger">*</span></label>
                                        <input type="text" 
                                               name="titulo" 
                                               class="form-control <?php $__errorArgs = ['titulo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                               placeholder="Ex: Campanha Black Friday 2025" 
                                               value="<?php echo e(old('titulo')); ?>" 
                                               required>
                                        <?php $__errorArgs = ['titulo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    
                                    <!-- Franquia (Vendedor) -->
                                    <div class="mb-3">
                                        <label class="form-label">Franquia (Vendedor) <span class="text-danger">*</span></label>
                                        <select name="franquia_id" class="form-control <?php $__errorArgs = ['franquia_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                                            <option value="">Selecione uma franquia...</option>
                                            <?php $__currentLoopData = $franquias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $franquia): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($franquia->id); ?>" <?php if(old('franquia_id') == $franquia->id): ?> selected <?php endif; ?>>
                                                    <?php echo e($franquia->name); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <?php $__errorArgs = ['franquia_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <!-- Cliente (Comprador) -->
                                    <div class="mb-3">
                                        <label class="form-label">Cliente (Comprador) <span class="text-danger">*</span></label>
                                        <select name="cliente_id" class="form-control <?php $__errorArgs = ['cliente_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                                            <option value="">Selecione um cliente...</option>
                                            <?php $__currentLoopData = $clientes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cliente): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($cliente->id); ?>" <?php if(old('cliente_id') == $cliente->id): ?> selected <?php endif; ?>>
                                                    <?php echo e($cliente->name); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <?php $__errorArgs = ['cliente_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    
                                    <!-- Posição de Exibição -->
                                    <div class="mb-3">
                                        <label class="form-label">Posição de Exibição <span class="text-danger">*</span></label>
                                        <select name="posicao" class="form-control <?php $__errorArgs = ['posicao'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                                            <option value="">Selecione a posição...</option>
                                            <?php for($i = 1; $i <= 6; $i++): ?>
                                                <?php
                                                    $colors = [
                                                        1 => '🔵 Primary',
                                                        2 => '🟢 Success',
                                                        3 => '🔷 Info',
                                                        4 => '🟡 Warning',
                                                        5 => '🔴 Danger',
                                                        6 => '⚪ Secondary',
                                                    ];
                                                ?>
                                                <option value="<?php echo e($i); ?>" <?php if(old('posicao') == $i): ?> selected <?php endif; ?>>
                                                    Posição <?php echo e($i); ?> - <?php echo e($colors[$i]); ?>

                                                </option>
                                            <?php endfor; ?>
                                        </select>
                                        <?php $__errorArgs = ['posicao'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        <small class="form-text text-muted">
                                            <i class="ph-duotone ph-info me-1"></i>
                                            Define em qual slot (1-6) a publicidade será exibida
                                        </small>
                                    </div>
                                </div>

                                <div class="col-12"><hr class="my-3"></div>
                                <div class="col-12"><h6 class="mb-3">Alcance da Publicação</h6></div>

                                <!-- Tipo de Alcance -->
                                <div class="col-md-4">
                                    <div class="mb-3">
                                        <label class="form-label">Tipo de Alcance <span class="text-danger">*</span></label>
                                        <select name="tipo_alcance" id="tipo_alcance" class="form-control <?php $__errorArgs = ['tipo_alcance'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                                            <option value="todos" <?php if(old('tipo_alcance', 'todos') == 'todos'): ?> selected <?php endif; ?>>Todos os equipamentos</option>
                                            <option value="serial_especifico" <?php if(old('tipo_alcance') == 'serial_especifico'): ?> selected <?php endif; ?>>Serial Específico</option>
                                            <option value="empresa" <?php if(old('tipo_alcance') == 'empresa'): ?> selected <?php endif; ?>>Empresa Específica</option>
                                        </select>
                                        <?php $__errorArgs = ['tipo_alcance'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        <small class="form-text text-muted">
                                            Define se a publicação será exibida em todos equipamentos, apenas um específico ou em um grupo
                                        </small>
                                    </div>
                                </div>

                                <!-- Equipment Serial (condicional) -->
                                <div class="col-md-4" id="serial_field" style="display: none;">
                                    <div class="mb-3">
                                        <label class="form-label">Serial do Equipamento <span class="text-danger">*</span></label>
                                        <input type="text" 
                                               name="equipment_serial" 
                                               class="form-control <?php $__errorArgs = ['equipment_serial'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                               placeholder="Ex: ABC123456" 
                                               value="<?php echo e(old('equipment_serial')); ?>">
                                        <?php $__errorArgs = ['equipment_serial'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>

                                <!-- Empresa Específica (condicional) -->
                                <div class="col-md-4" id="empresa_field" style="display: none;">
                                    <div class="mb-3">
                                        <label class="form-label">Empresa <span class="text-danger">*</span></label>
                                        <select name="empresa_alcance_id" 
                                               class="form-control <?php $__errorArgs = ['empresa_alcance_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                            <option value="">Selecione uma empresa</option>
                                            <?php $__currentLoopData = $clientes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cliente): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($cliente->id); ?>" <?php if(old('empresa_alcance_id') == $cliente->id): ?> selected <?php endif; ?>>
                                                    <?php echo e($cliente->name); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <?php $__errorArgs = ['empresa_alcance_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>

                                <div class="col-12"><hr class="my-3"></div>
                                <div class="col-12"><h6 class="mb-3">Período de Exibição</h6></div>

                                <!-- Data Início -->
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label">Data e Hora de Início <span class="text-danger">*</span></label>
                                        <input type="datetime-local" 
                                               name="data_inicio" 
                                               class="form-control <?php $__errorArgs = ['data_inicio'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                               value="<?php echo e(old('data_inicio')); ?>" 
                                               required>
                                        <?php $__errorArgs = ['data_inicio'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        <small class="form-text text-muted">
                                            Define quando a publicação começará a ser exibida
                                        </small>
                                    </div>
                                </div>

                                <!-- Data Fim -->
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label">Data e Hora de Término <span class="text-danger">*</span></label>
                                        <input type="datetime-local" 
                                               name="data_fim" 
                                               class="form-control <?php $__errorArgs = ['data_fim'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                               value="<?php echo e(old('data_fim')); ?>" 
                                               required>
                                        <?php $__errorArgs = ['data_fim'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        <small class="form-text text-muted">
                                            Define quando a publicação deixará de ser exibida
                                        </small>
                                    </div>
                                </div>

                                <div class="col-12"><hr class="my-3"></div>
                                <div class="col-12"><h6 class="mb-3">Configuração de Tracking e Cliques</h6></div>

                                <!-- Link de Destino -->
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label">Link de Destino (URL)</label>
                                        <input type="text"
                                               name="link_destino"
                                               id="link_destino"
                                               class="form-control <?php $__errorArgs = ['link_destino'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                               placeholder="https://exemplo.com/oferta ou # para desabilitar"
                                               value="<?php echo e(old('link_destino')); ?>">
                                        <?php $__errorArgs = ['link_destino'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        <small class="form-text text-muted">
                                            URL para onde o usuário será redirecionado ao clicar no anúncio. Use # para link inativo.
                                        </small>
                                    </div>
                                </div>

                                <!-- Habilitar Clique -->
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label d-block">Opções de Interação</label>
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" 
                                                   type="checkbox" 
                                                   name="habilitar_clique" 
                                                   id="habilitar_clique"
                                                   value="1"
                                                   <?php echo e(old('habilitar_clique', true) ? 'checked' : ''); ?>>
                                            <label class="form-check-label" for="habilitar_clique">
                                                🖱️ Habilitar cliques no anúncio
                                            </label>
                                        </div>
                                        <div class="form-check form-switch mt-2">
                                            <input class="form-check-input" 
                                                   type="checkbox" 
                                                   name="track_impressoes" 
                                                   id="track_impressoes"
                                                   value="1"
                                                   <?php echo e(old('track_impressoes', true) ? 'checked' : ''); ?>>
                                            <label class="form-check-label" for="track_impressoes">
                                                👁️ Rastrear impressões (visualizações)
                                            </label>
                                        </div>
                                        <div class="form-check form-switch mt-2">
                                            <input class="form-check-input" 
                                                   type="checkbox" 
                                                   name="track_cliques" 
                                                   id="track_cliques"
                                                   value="1"
                                                   <?php echo e(old('track_cliques', true) ? 'checked' : ''); ?>>
                                            <label class="form-check-label" for="track_cliques">
                                                🎯 Rastrear cliques no anúncio
                                            </label>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-12"><hr class="my-3"></div>
                                <div class="col-12">
                                    <h6 class="mb-2">
                                        Walled Garden - Domínios/IPs Liberados
                                        <small class="text-muted">(Opcional)</small>
                                    </h6>
                                    <p class="text-muted small mb-3">
                                        <i class="ph-duotone ph-shield-check me-1"></i>
                                        Configure domínios, IPs ou subnets que serão liberados no hotspot 
                                        <strong>antes da autenticação</strong> para permitir carregamento de conteúdo externo.
                                    </p>
                                </div>

                                <!-- Container de Walled Gardens -->
                                <div class="col-12">
                                    <div id="walledGardensContainer">
                                        <!-- Items serão adicionados aqui via JavaScript -->
                                    </div>
                                    
                                    <button type="button" 
                                            class="btn btn-outline-primary btn-sm mt-2" 
                                            id="addWalledGarden">
                                        <i class="ph-duotone ph-plus-circle me-1"></i>Adicionar Domínio/IP
                                    </button>
                                </div>

                                <div class="col-12"><hr class="my-3"></div>
                                <div class="col-12"><h6 class="mb-3">Valores Comerciais</h6></div>

                                <!-- Valor do Contrato -->
                                <div class="col-md-4">
                                    <div class="mb-3">
                                        <label class="form-label">Valor do Contrato</label>
                                        <div class="input-group">
                                            <span class="input-group-text">R$</span>
                                            <input type="text" 
                                                   name="valor_contrato" 
                                                   id="valor_contrato"
                                                   class="form-control <?php $__errorArgs = ['valor_contrato'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                                   placeholder="0,00" 
                                                   value="<?php echo e(old('valor_contrato')); ?>">
                                        </div>
                                        <?php $__errorArgs = ['valor_contrato'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback d-block"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        <small class="form-text text-muted">
                                            Digite o valor (ex: 1.500,00)
                                        </small>
                                    </div>
                                </div>

                                <!-- Impressões Contratadas -->
                                <div class="col-md-4">
                                    <div class="mb-3">
                                        <label class="form-label">Impressões Contratadas</label>
                                        <input type="number" 
                                               name="impressoes_contratadas" 
                                               class="form-control <?php $__errorArgs = ['impressoes_contratadas'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                               placeholder="0" 
                                               min="0"
                                               value="<?php echo e(old('impressoes_contratadas')); ?>">
                                        <?php $__errorArgs = ['impressoes_contratadas'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>

                                <!-- Status -->
                                <div class="col-md-4">
                                    <div class="mb-3">
                                        <label class="form-label">Status <span class="text-danger">*</span></label>
                                        <select name="status" class="form-control <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                                            <option value="ativa" <?php if(old('status') == 'ativa' || !old('status')): ?> selected <?php endif; ?>>Ativa</option>
                                            <option value="pausada" <?php if(old('status') == 'pausada'): ?> selected <?php endif; ?>>Pausada</option>
                                            <option value="expirada" <?php if(old('status') == 'expirada'): ?> selected <?php endif; ?>>Expirada</option>
                                            <option value="cancelada" <?php if(old('status') == 'cancelada'): ?> selected <?php endif; ?>>Cancelada</option>
                                        </select>
                                        <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>

                                <div class="col-12 text-end mt-3">
                                    <div class="btn-group" role="group">
                                        <button type="submit" class="btn btn-success">
                                            <i class="ph-duotone ph-floppy-disk me-2"></i>Salvar Publicação
                                        </button>
                                        <a href="<?php echo e(route('publicacoes.index')); ?>" class="btn btn-secondary">
                                            <i class="ph-duotone ph-x-circle me-2"></i>Cancelar
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        // === WALLED GARDENS DINÂMICOS ===
        let walledGardenCounter = 0;

        function createWalledGardenRow(data = {}) {
            const index = walledGardenCounter++;
            const row = document.createElement('div');
            row.className = 'card mb-3 walled-garden-item';
            row.dataset.index = index;
            
            row.innerHTML = `
                <div class="card-body">
                    <div class="row align-items-end">
                        <div class="col-md-3">
                            <label class="form-label">Tipo</label>
                            <select name="walled_gardens[${index}][tipo]" 
                                    class="form-control walled-garden-tipo" 
                                    data-index="${index}">
                                <option value="domain" ${data.tipo === 'domain' ? 'selected' : ''}>🌐 Domínio</option>
                                <option value="ip" ${data.tipo === 'ip' ? 'selected' : ''}>📡 IP</option>
                                <option value="subnet" ${data.tipo === 'subnet' ? 'selected' : ''}>🔒 Subnet</option>
                            </select>
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">Endereço <span class="text-danger">*</span></label>
                            <input type="text" 
                                   name="walled_gardens[${index}][endereco]" 
                                   class="form-control walled-garden-endereco"
                                   placeholder="exemplo.com"
                                   value="${data.endereco || ''}"
                                   required>
                            <small class="form-text text-muted walled-garden-hint">
                                Ex: exemplo.com
                            </small>
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">Descrição (Opcional)</label>
                            <input type="text" 
                                   name="walled_gardens[${index}][descricao]" 
                                   class="form-control"
                                   placeholder="Ex: CDN de imagens"
                                   value="${data.descricao || ''}">
                        </div>
                        <div class="col-md-1">
                            <button type="button" 
                                    class="btn btn-danger btn-sm w-100 remove-walled-garden"
                                    title="Remover">
                                <i class="ph-duotone ph-trash"></i>
                            </button>
                        </div>
                    </div>
                </div>
            `;
            
            return row;
        }

        // Adicionar evento para atualizar placeholder baseado no tipo
        document.addEventListener('change', function(e) {
            if(e.target.classList.contains('walled-garden-tipo')) {
                const index = e.target.dataset.index;
                const tipo = e.target.value;
                const enderecoInput = document.querySelector(`input[name="walled_gardens[${index}][endereco]"]`);
                const hint = e.target.closest('.card-body').querySelector('.walled-garden-hint');
                
                switch(tipo) {
                    case 'domain':
                        enderecoInput.placeholder = 'exemplo.com';
                        hint.textContent = 'Ex: exemplo.com ou cdn.exemplo.com';
                        break;
                    case 'ip':
                        enderecoInput.placeholder = '192.168.1.1';
                        hint.textContent = 'Ex: 192.168.1.1 ou 200.200.200.200';
                        break;
                    case 'subnet':
                        enderecoInput.placeholder = '192.168.1.0/24';
                        hint.textContent = 'Ex: 192.168.1.0/24 ou 10.0.0.0/8';
                        break;
                }
            }
        });

        // Botão adicionar walled garden
        document.getElementById('addWalledGarden').addEventListener('click', function() {
            const container = document.getElementById('walledGardensContainer');
            const row = createWalledGardenRow();
            container.appendChild(row);
            
            // Animar entrada
            row.style.opacity = '0';
            row.style.transform = 'translateY(-10px)';
            setTimeout(() => {
                row.style.transition = 'all 0.3s ease';
                row.style.opacity = '1';
                row.style.transform = 'translateY(0)';
            }, 10);
        });

        // Remover walled garden (delegação de evento)
        document.addEventListener('click', function(e) {
            if(e.target.closest('.remove-walled-garden')) {
                const item = e.target.closest('.walled-garden-item');
                
                // Animar saída
                item.style.transition = 'all 0.3s ease';
                item.style.opacity = '0';
                item.style.transform = 'translateX(20px)';
                
                setTimeout(() => {
                    item.remove();
                }, 300);
            }
        });

        // Carregar walled gardens existentes do old() se houver
        <?php if(old('walled_gardens')): ?>
            document.addEventListener('DOMContentLoaded', function() {
                const oldData = <?php echo json_encode(old('walled_gardens'), 15, 512) ?>;
                const container = document.getElementById('walledGardensContainer');
                
                oldData.forEach(wg => {
                    const row = createWalledGardenRow(wg);
                    container.appendChild(row);
                });
            });
        <?php endif; ?>

        // === CONTROLE DE CAMPOS CONDICIONAIS ===
        // Controlar exibição de campos condicionais baseado no tipo de alcance
        document.addEventListener('DOMContentLoaded', function() {
            const tipoAlcanceSelect = document.getElementById('tipo_alcance');
            const serialField = document.getElementById('serial_field');
            const empresaField = document.getElementById('empresa_field');
            
            function updateFields() {
                const value = tipoAlcanceSelect.value;
                
                // Ocultar todos primeiro
                serialField.style.display = 'none';
                empresaField.style.display = 'none';
                
                // Mostrar campo relevante
                if (value === 'serial_especifico') {
                    serialField.style.display = 'block';
                } else if (value === 'empresa') {
                    empresaField.style.display = 'block';
                }
            }
            
            // Executar ao carregar
            updateFields();
            
            // Executar ao mudar
            tipoAlcanceSelect.addEventListener('change', updateFields);
        });
        
        // Preview dinâmico do criativo
        const criativoSelect = document.getElementById('criativoSelect');
        const criativoPreview = document.getElementById('criativoPreview');
        const previewContent = document.getElementById('previewContent');
        const previewInfo = document.getElementById('previewInfo');
        
        if(criativoSelect) {
            criativoSelect.addEventListener('change', function() {
                const criativoId = this.value;
                
                if(!criativoId) {
                    criativoPreview.style.display = 'none';
                    return;
                }
                
                // Mostrar loading
                criativoPreview.style.display = 'block';
                previewContent.innerHTML = '<div class="spinner-border text-primary" role="status"><span class="visually-hidden">Carregando...</span></div>';
                previewInfo.innerHTML = '<p class="text-muted">Carregando informações...</p>';
                
                // Buscar dados do criativo via AJAX
                fetch(`/publicacoes/criativo/${criativoId}`)
                    .then(response => response.json())
                    .then(data => {
                        console.log('Dados do criativo:', data);
                        
                        // Atualizar preview
                        if(data.tipo === 'imagem' || data.tipo === 'image') {
                            previewContent.innerHTML = `
                                <img src="${data.path}" 
                                     alt="${data.title}" 
                                     style="max-width: 100%; max-height: 300px; border-radius: 8px; box-shadow: 0 4px 12px rgba(0,0,0,0.1);">
                            `;
                        } else if(data.tipo === 'video') {
                            previewContent.innerHTML = `
                                <video controls style="max-width: 100%; max-height: 300px; border-radius: 8px;">
                                    <source src="${data.path}" type="video/mp4">
                                    Seu navegador não suporta vídeo.
                                </video>
                            `;
                        }
                        
                        // Atualizar informações
                        let infoHTML = `
                            <div class="row text-start">
                                <div class="col-6">
                                    <strong>Tipo:</strong> ${data.tipo === 'imagem' ? '🖼️ Imagem' : '🎬 Vídeo'}
                                </div>
                                <div class="col-6">
                                    <strong>Dimensões:</strong> ${data.width}x${data.height}px
                                </div>
                            </div>
                        `;
                        
                        if(data.empresa) {
                            infoHTML += `
                                <div class="row text-start mt-2">
                                    <div class="col-12">
                                        <strong>Empresa:</strong> ${data.empresa}
                                    </div>
                                </div>
                            `;
                        }
                        
                        if(data.size) {
                            infoHTML += `
                                <div class="row text-start mt-2">
                                    <div class="col-12">
                                        <strong>Tamanho:</strong> ${(data.size / 1024).toFixed(2)} KB
                                    </div>
                                </div>
                            `;
                        }
                        
                        previewInfo.innerHTML = infoHTML;
                    })
                    .catch(error => {
                        console.error('Erro ao buscar criativo:', error);
                        previewContent.innerHTML = '<div class="alert alert-danger">Erro ao carregar preview</div>';
                        previewInfo.innerHTML = '';
                    });
            });
            
            // Carregar preview se já houver valor selecionado (old input)
            if(criativoSelect.value) {
                criativoSelect.dispatchEvent(new Event('change'));
            }
        }
        
        // Máscara de dinheiro no campo valor_contrato
        const valorContratoInput = document.getElementById('valor_contrato');
        if(valorContratoInput) {
            // Função para formatar valor
            function formatarMoeda(valor) {
                // Remove tudo que não é número
                valor = valor.replace(/\D/g, '');
                
                // Converte para número com 2 casas decimais
                valor = (parseFloat(valor) / 100).toFixed(2);
                
                // Formata com separadores
                valor = valor.replace('.', ',');
                valor = valor.replace(/(\d)(?=(\d{3})+(?!\d))/g, '$1.');
                
                return valor;
            }
            
            // Função para converter valor formatado para decimal
            function converterParaDecimal(valor) {
                if(!valor) return '';
                
                // Remove pontos (separador de milhar) e substitui vírgula por ponto
                return valor.replace(/\./g, '').replace(',', '.');
            }
            
            // Aplicar máscara ao digitar
            valorContratoInput.addEventListener('input', function(e) {
                let valor = e.target.value;
                e.target.value = formatarMoeda(valor);
            });
            
            // Formatar valor existente (old value)
            if(valorContratoInput.value) {
                // Se já está formatado, mantém
                if(!valorContratoInput.value.includes(',')) {
                    // Se não está formatado (decimal), formata
                    let valorDecimal = parseFloat(valorContratoInput.value) * 100;
                    valorContratoInput.value = formatarMoeda(valorDecimal.toString());
                }
            }
            
            // Converter para decimal antes de enviar o form
            const form = valorContratoInput.closest('form');
            if(form) {
                form.addEventListener('submit', function(e) {
                    // Criar campo hidden com valor decimal
                    const valorFormatado = valorContratoInput.value;
                    const valorDecimal = converterParaDecimal(valorFormatado);
                    
                    // Criar input hidden temporário
                    const hiddenInput = document.createElement('input');
                    hiddenInput.type = 'hidden';
                    hiddenInput.name = 'valor_contrato';
                    hiddenInput.value = valorDecimal;
                    
                    // Remover o name do input original para não enviar
                    valorContratoInput.removeAttribute('name');
                    
                    // Adicionar hidden ao form
                    form.appendChild(hiddenInput);
                });
            }
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/resources/views/publicacoes/create.blade.php ENDPATH**/ ?>