<?php $__env->startSection('title', 'Usuários'); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .status-selector {
        position: relative;
        display: inline-block;
    }
    
    .status-badge {
        transition: opacity 0.2s ease;
    }
    
    .status-badge:hover {
        opacity: 0.85 !important;
    }
    
    .status-select {
        min-width: 160px;
        font-size: 0.875rem;
        position: absolute;
        top: 100%;
        left: 0;
        z-index: 1000;
        margin-top: 2px;
        box-shadow: 0 4px 12px rgba(0,0,0,0.2);
        border: 2px solid #dee2e6;
        border-radius: 0.375rem;
        overflow: hidden;
    }
    
    .status-select option {
        padding: 10px 12px;
        font-weight: 600;
        cursor: pointer;
        border-bottom: 1px solid rgba(0,0,0,0.05);
    }
    
    .status-select option:last-child {
        border-bottom: none;
    }
    
    .status-select option:hover {
        opacity: 0.8;
        filter: brightness(0.95);
    }
    
    .status-select option:checked,
    .status-select option:focus {
        font-weight: 700;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('main-content'); ?>
    <div class="container-fluid">
        <!-- Breadcrumb start -->
        <div class="row m-1">
            <div class="col-12">
                <h5><i class="ph-duotone ph-users f-s-16 me-2"></i>Usuários</h5>
                <ul class="app-line-breadcrumbs mb-3">
                    <li class="">
                        <a href="#" class="f-s-14 f-w-500">
                            <span>Gestão de Usuários</span>
                        </a>
                    </li>
                    <li class="active">
                        <a href="#" class="f-s-14 f-w-500">Usuários</a>
                    </li>
                </ul>
            </div>
        </div>
        <!-- Breadcrumb end -->

        <!-- tables start  -->
        <div class="row table-section">
            <div class="col-xl-12">
                <div class="card">
                    <div class="card-header">
                        <div class="d-flex justify-content-between align-items-center">
                            <h5>Usuários Cadastrados</h5>
                            <div class="d-flex align-items-center gap-2">
                                <!-- Formulário de Busca -->
                                <form action="<?php echo e(route('users.index')); ?>" method="GET" class="d-flex">
                                    <div class="input-group" style="min-width: 300px;">
                                        <input type="text" 
                                               name="q" 
                                               id="search" 
                                               class="form-control" 
                                               placeholder="Buscar por nome ou email..." 
                                               value="<?php echo e(request('q')); ?>">
                                        <button type="submit" class="btn btn-secondary">
                                            <i class="ph ph-magnifying-glass me-1"></i>Buscar
                                        </button>
                                        <?php if(request('q')): ?>
                                            <a href="<?php echo e(route('users.index')); ?>" class="btn btn-outline-secondary" title="Limpar filtros">
                                                <i class="ph ph-x"></i>
                                            </a>
                                        <?php endif; ?>
                                    </div>
                                </form>
                                
                                <!-- Botões de Ação -->
                                <div class="btn-group">
                                    <a href="<?php echo e(route('users.create')); ?>" class="btn btn-primary">
                                        <i class="ph ph-plus me-1"></i>Novo Usuário
                                    </a>
                                    <button type="button" class="btn btn-warning" data-bs-toggle="modal" data-bs-target="#trashModalUsers" title="Lixeira">
                                        <i class="ph ph-trash"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table align-middle mb-0">
                                <thead>
                                <tr>
                                    <th scope="col" class="text-center" width="50">#</th>
                                    <th scope="col">Nome</th>
                                    <th scope="col">E-mail</th>
                                    <th scope="col">Empresa</th>
                                    <th scope="col" class="text-center">Situação</th>
                                    <th scope="col" class="text-center">Ações</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td class="text-center"><?php echo e(($users->currentPage() - 1) * $users->perPage() + $index + 1); ?></td>
                                    <td><a href="<?php echo e(route('users.edit', $user)); ?>" class="text-decoration-none text-reset"><?php echo e($user->name); ?></a></td>
                                    <td><?php echo e($user->email); ?></td>
                                    <td><?php echo e($user->empresa?->name ?? '-'); ?></td>
                                    <td class="text-center">
                                        <div class="status-selector">
                                            <!-- Badge clicável que abre o select -->
                                            <span class="badge status-badge <?php echo e($user->status_cadastro === 'aprovado' ? 'bg-success' : ($user->status_cadastro === 'rejeitado' ? 'bg-danger' : 'bg-warning text-dark')); ?>" 
                                                  style="cursor: pointer; user-select: none;" 
                                                  onclick="toggleStatusSelect(<?php echo e($user->id); ?>)">
                                                <i class="ph <?php echo e($user->status_cadastro === 'aprovado' ? 'ph-check-circle' : ($user->status_cadastro === 'rejeitado' ? 'ph-x-circle' : 'ph-clock')); ?> me-1"></i>
                                                <?php echo e(ucfirst($user->status_cadastro)); ?>

                                                <i class="ph ph-caret-down ms-1"></i>
                                            </span>
                                            
                                            <!-- Select dropdown (inicialmente oculto) -->
                                            <select id="status-select-<?php echo e($user->id); ?>" 
                                                    class="form-select form-select-sm status-select d-none mt-1" 
                                                    data-user-id="<?php echo e($user->id); ?>" 
                                                    data-user-name="<?php echo e($user->name); ?>"
                                                    data-current-status="<?php echo e($user->status_cadastro); ?>"
                                                    onchange="changeUserStatus(<?php echo e($user->id); ?>)"
                                                    onblur="setTimeout(() => hideStatusSelect(<?php echo e($user->id); ?>), 200)"
                                                    size="3">
                                                <option value="pendente" <?php echo e($user->status_cadastro === 'pendente' ? 'selected' : ''); ?> style="background-color: #fff3cd; color: #856404; font-weight: 600;">
                                                    🟡 Pendente
                                                </option>
                                                <option value="aprovado" <?php echo e($user->status_cadastro === 'aprovado' ? 'selected' : ''); ?> style="background-color: #d1e7dd; color: #0f5132; font-weight: 600;">
                                                    🟢 Aprovado
                                                </option>
                                                <option value="rejeitado" <?php echo e($user->status_cadastro === 'rejeitado' ? 'selected' : ''); ?> style="background-color: #f8d7da; color: #842029; font-weight: 600;">
                                                    🔴 Rejeitado
                                                </option>
                                            </select>
                                        </div>
                                        
                                        <!-- Forms ocultos para ações -->
                                        <form id="approve-form-<?php echo e($user->id); ?>" action="<?php echo e(route('users.approve', $user)); ?>" method="POST" style="display: none;">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('PATCH'); ?>
                                        </form>
                                        <form id="reject-form-<?php echo e($user->id); ?>" action="<?php echo e(route('users.reject', $user)); ?>" method="POST" style="display: none;">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('PATCH'); ?>
                                        </form>
                                    </td>
                                    <td class="text-center">
                                        <a href="<?php echo e(route('users.edit', $user)); ?>" class="me-2" title="Editar">
                                            <i class="ph-duotone ph-pencil-simple"></i>
                                        </a>
                                        <a href="#" class="delete-user" data-id="<?php echo e($user->id); ?>" title="Excluir">
                                            <i class="ph-duotone ph-trash"></i>
                                        </a>
                                        <form id="delete-form-<?php echo e($user->id); ?>" action="<?php echo e(route('users.destroy', $user)); ?>" method="POST" style="display: none;">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                        </form>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="6" class="text-center">Nenhum usuário encontrado.</td>
                                </tr>
                                <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <?php if($users->hasPages()): ?>
                        <div class="card-footer">
                            <?php echo e($users->appends(request()->query())->links()); ?>

                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <!-- tables-end  -->
    </div>

    <!-- Trash Modal -->
    <div class="modal fade" id="trashModalUsers" tabindex="-1" aria-labelledby="trashModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="trashModalLabel">Usuários Excluídos</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body" id="trashModalBodyUsers">
                    <p>Carregando...</p>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    // Funções para o Status Selector (Dropdown)
    function toggleStatusSelect(userId) {
        const select = document.getElementById('status-select-' + userId);
        const badge = select.previousElementSibling;
        
        // Esconder todos os outros selects abertos
        document.querySelectorAll('.status-select').forEach(s => {
            if (s.id !== 'status-select-' + userId) {
                s.classList.add('d-none');
            }
        });
        
        // Toggle do select atual
        if (select.classList.contains('d-none')) {
            select.classList.remove('d-none');
            badge.style.opacity = '0.5';
            select.focus();
        } else {
            select.classList.add('d-none');
            badge.style.opacity = '1';
        }
    }
    
    function hideStatusSelect(userId) {
        const select = document.getElementById('status-select-' + userId);
        const badge = select.previousElementSibling;
        select.classList.add('d-none');
        badge.style.opacity = '1';
    }
    
    function changeUserStatus(userId) {
        const select = document.getElementById('status-select-' + userId);
        const newStatus = select.value;
        const currentStatus = select.dataset.currentStatus;
        const userName = select.dataset.userName;
        
        if (!newStatus || newStatus === currentStatus) {
            hideStatusSelect(userId);
            return;
        }
        
        // Mensagens de confirmação personalizadas
        let confirmMessage = '';
        let statusLabel = '';
        
        if (newStatus === 'aprovado') {
            statusLabel = 'APROVAR';
            confirmMessage = `Tem certeza que deseja APROVAR o cadastro de "${userName}"?\n\nO usuário poderá acessar o sistema.`;
        } else if (newStatus === 'rejeitado') {
            statusLabel = 'REJEITAR';
            confirmMessage = `Tem certeza que deseja REJEITAR o cadastro de "${userName}"?\n\nO usuário NÃO poderá acessar o sistema.`;
        } else if (newStatus === 'pendente') {
            statusLabel = 'TORNAR PENDENTE';
            confirmMessage = `Tem certeza que deseja alterar o status de "${userName}" para PENDENTE?\n\nO cadastro ficará aguardando aprovação novamente.`;
        }
        
        if (confirm(confirmMessage)) {
            // Submeter o formulário apropriado
            if (newStatus === 'aprovado') {
                document.getElementById('approve-form-' + userId).submit();
            } else if (newStatus === 'rejeitado') {
                document.getElementById('reject-form-' + userId).submit();
            }
        } else {
            // Reverter para o status original
            select.value = currentStatus;
            hideStatusSelect(userId);
        }
    }
    
    document.addEventListener('DOMContentLoaded', function () {
        // Fechar select ao clicar fora
        document.addEventListener('click', function(event) {
            if (!event.target.closest('.status-selector')) {
                document.querySelectorAll('.status-select').forEach(select => {
                    if (!select.classList.contains('d-none')) {
                        const userId = select.dataset.userId;
                        hideStatusSelect(userId);
                    }
                });
            }
        });
        
        // Main page actions
        document.body.addEventListener('click', function(event) {
            // Delete user
            if (event.target.closest('.delete-user')) {
                event.preventDefault();
                let userId = event.target.closest('.delete-user').dataset.id;
                if (confirm('Tem certeza que deseja enviar este usuário para a lixeira?')) {
                    document.getElementById('delete-form-' + userId).submit();
                }
            }
        });

        // Trash Modal for Users
        const trashModalUsers = document.getElementById('trashModalUsers');
        if(trashModalUsers) {
            trashModalUsers.addEventListener('show.bs.modal', function () {
                const modalBody = document.getElementById('trashModalBodyUsers');
                modalBody.innerHTML = '<p>Carregando...</p>';

                fetch('<?php echo e(route("users.trash")); ?>')
                    .then(response => response.json())
                    .then(data => {
                        if (data.length === 0) {
                            modalBody.innerHTML = '<p>A lixeira está vazia.</p>';
                            return;
                        }

                        let tableHtml = '<div class="table-responsive"><table class="table align-middle"><thead><tr><th>Usuário</th><th>Email</th><th>Excluído em</th><th>Excluído por</th><th>Ações</th></tr></thead><tbody>';
                        data.forEach(user => {
                            const deletedAt = new Date(user.deleted_at).toLocaleString('pt-BR');
                            const destroyerName = user.destroyer ? user.destroyer.name : 'Usuário desconhecido';

                            tableHtml += `
                                <tr>
                                    <td>${user.name}</td>
                                    <td>${user.email}</td>
                                    <td>${deletedAt}</td>
                                    <td>${destroyerName}</td>
                                    <td>
                                        <button class="btn btn-sm btn-success restore-user" data-id="${user.id}">Restaurar</button>
                                        <form id="restore-form-${user.id}" action="/users/${user.id}/restore" method="POST" style="display: none;">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('PATCH'); ?>
                                        </form>
                                    </td>
                                </tr>
                            `;
                        });
                        tableHtml += '</tbody></table></div>';
                        modalBody.innerHTML = tableHtml;
                    })
                    .catch(error => {
                        modalBody.innerHTML = '<p>Ocorreu um erro ao carregar os itens.</p>';
                        console.error('Error fetching trash:', error);
                    });
            });

            trashModalUsers.addEventListener('click', function(event) {
                const restoreBtn = event.target.closest('.restore-user');
                if (restoreBtn) {
                    event.preventDefault();
                    let userId = restoreBtn.dataset.id;
                    if (confirm('Tem certeza que deseja restaurar este usuário?')) {
                        document.getElementById('restore-form-' + userId).submit();
                    }
                }
            });
        }
    });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/resources/views/users/index.blade.php ENDPATH**/ ?>