<?php $__env->startSection('title', 'Criativos'); ?>
<?php $__env->startSection('main-content'); ?>
    <div class="container-fluid">
        <!-- Breadcrumb start -->
        <div class="row m-1">
            <div class="col-12">
                <h5><i class="ph-duotone ph-image f-s-16 me-2"></i>Criativos</h5>
                <ul class="app-line-breadcrumbs mb-3">
                    <li class="">
                        <a href="#" class="f-s-14 f-w-500">
                            <span>Gestão de Criativos</span>
                        </a>
                    </li>
                    <li class="active">
                        <a href="#" class="f-s-14 f-w-500">Criativos</a>
                    </li>
                </ul>
            </div>
        </div>
        <!-- Breadcrumb end -->

        <!-- tables start  -->
        <div class="row table-section">
            <div class="col-xl-12">
                <div class="card">
                    <div class="card-header">
                                                <div class="d-flex justify-content-between align-items-center">
                            <h5>Criativos Cadastrados</h5>
                            <div class="d-flex align-items-center gap-2">
                                <!-- Formulário de Busca -->
                                <form action="<?php echo e(route('midias.index')); ?>" method="GET" class="d-flex">
                                    <div class="input-group" style="min-width: 300px;">
                                        <input type="text" 
                                               name="q" 
                                               id="search" 
                                               class="form-control" 
                                               placeholder="Buscar por título..." 
                                               value="<?php echo e(request('q')); ?>">
                                        <button type="submit" class="btn btn-secondary">
                                            <i class="ph ph-magnifying-glass me-1"></i>Buscar
                                        </button>
                                        <?php if(request('q')): ?>
                                            <a href="<?php echo e(route('midias.index')); ?>" class="btn btn-outline-secondary" title="Limpar filtros">
                                                <i class="ph ph-x"></i>
                                            </a>
                                        <?php endif; ?>
                                    </div>
                                </form>
                                
                                <!-- Botões de Ação -->
                                <div class="btn-group">
                                    <a href="<?php echo e(route('midias.create')); ?>" class="btn btn-primary">
                                        <i class="ph ph-plus me-1"></i>Nova Mídia
                                    </a>
                                    <button type="button" class="btn btn-warning" data-bs-toggle="modal" data-bs-target="#trashModal" title="Lixeira">
                                        <i class="ph ph-trash"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table align-middle mb-0">
                                <thead>
                                <tr>
                                    <th scope="col" class="text-center" width="50">#</th>
                                    <th scope="col" style="width: 40%;">Título</th>
                                    <th scope="col">Tipo</th>
                                    <th scope="col">Empresa</th>
                                    <th scope="col">Serial</th>
                                    <th scope="col" class="text-center">Views</th>
                                    <th scope="col" class="text-center" style="width: 1%;">Ações</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $midias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $midia): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr class="<?php if($midia->status == 1): ?> text-muted <?php endif; ?>">
                                    <td class="text-center"><?php echo e(($midias->currentPage() - 1) * $midias->perPage() + $index + 1); ?></td>
                                    <td><a href="<?php echo e(route('midias.edit', $midia)); ?>" class="text-decoration-none text-reset"><?php echo e($midia->title); ?></a></td>
                                    <td><?php echo e($midia->tipo ?? $midia->type ?? '-'); ?></td>
                                    <td><?php echo e($midia->empresa?->name ?? 'Sem empresa'); ?></td>
                                    <td><?php echo e($midia->equipment_serial); ?></td>
                                    <td class="text-center">
                                        <a href="#" data-bs-toggle="modal" data-bs-target="#analyticsModal" data-media-title="<?php echo e($midia->title); ?>">
                                            <i class="ph-fill ph-chart-pie-slice"></i>
                                        </a>
                                        <span class="ms-2"><?php echo e(str_pad($midia->views_count, 6, '0', STR_PAD_LEFT)); ?></span>
                                    </td>
                                    <td class="text-center">
                                        <a href="#" class="preview-media me-2" data-bs-toggle="modal" data-bs-target="#mediaPreviewModal" data-path="<?php echo e(Storage::url($midia->path)); ?>" data-type="<?php echo e($midia->tipo ?? $midia->type ?? 'image'); ?>" title="Preview">
                                            <i class="ph-duotone ph-images-square"></i>
                                        </a>
                                        <a href="#" class="toggle-status me-2" data-id="<?php echo e($midia->id); ?>" title="Mudar Status">
                                            <?php if($midia->status == 0): ?>
                                                <i class="ph-bold ph-toggle-right text-success"></i>
                                            <?php else: ?>
                                                <i class="ph-bold ph-toggle-left"></i>
                                            <?php endif; ?>
                                        </a>
                                        <a href="#" class="delete-midia" data-id="<?php echo e($midia->id); ?>" title="Excluir">
                                            <i class="ph-duotone ph-trash"></i>
                                        </a>
                                        <form id="delete-form-<?php echo e($midia->id); ?>" action="<?php echo e(route('midias.destroy', $midia)); ?>" method="POST" style="display: none;">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                        </form>
                                        <form id="toggle-status-form-<?php echo e($midia->id); ?>" action="<?php echo e(route('midias.toggleStatus', $midia)); ?>" method="POST" style="display: none;">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('PATCH'); ?>
                                        </form>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="7" class="text-center">Nenhuma mídia encontrada.</td>
                                </tr>
                                <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <?php if($midias->hasPages()): ?>
                        <div class="card-footer">
                            <?php echo e($midias->appends(request()->query())->links()); ?>

                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <!-- tables-end  -->
    </div>

    <!-- Analytics Modal -->
    <div class="modal fade" id="analyticsModal" tabindex="-1" aria-labelledby="analyticsModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="analyticsModalLabel">Visualizações da mídia</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>Dados de visualização para esta mídia aparecerão aqui.</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Media Preview Modal -->
    <div class="modal fade" id="mediaPreviewModal" tabindex="-1" aria-labelledby="mediaPreviewModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered preview-modal-dialog">
            <div class="modal-content preview-modal-content">
                <div class="modal-header border-0">
                    <h5 class="modal-title" id="mediaPreviewModalLabel">
                        <i class="ph-duotone ph-images-square me-2"></i>Preview da Mídia
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body text-center p-4" id="mediaPreviewBody" style="min-height: 400px;">
                    <!-- Preloader animado -->
                    <div class="preview-loader" id="previewLoader">
                        <i class="ph-duotone ph-circle-notch ph-spin f-s-48 mb-3"></i>
                        <p class="mt-0 mb-0">Carregando preview...</p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Trash Modal -->
    <div class="modal fade" id="trashModal" tabindex="-1" aria-labelledby="trashModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="trashModalLabel">Itens Excluídos Anteriormente</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body" id="trashModalBody">
                    <p>Carregando...</p>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
    /* Animação de fade-in para o preview */
    @keyframes fadeIn {
        from {
            opacity: 0;
            transform: scale(0.95);
        }
        to {
            opacity: 1;
            transform: scale(1);
        }
    }
    
    /* Estilo do preloader */
    .preview-loader {
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        min-height: 400px;
    }
    
    /* Animação de rotação para o ícone */
    @keyframes spin {
        from {
            transform: rotate(0deg);
        }
        to {
            transform: rotate(360deg);
        }
    }
    
    .ph-spin {
        animation: spin 1s linear infinite;
        display: inline-block;
    }
    
    /* Modal backdrop mais escuro */
    #mediaPreviewModal ~ .modal-backdrop {
        background-color: rgba(0, 0, 0, 0.9) !important;
    }

    .modal-backdrop.show {
        opacity: 1 !important;
    }
    
    /* Background do modal adaptado ao tema */
    .preview-modal-content {
        background: var(--bs-body-bg) !important;
    }

    /* Tema escuro: fundo preto semi-transparente */
    [data-pc-theme="dark"] .preview-modal-content,
    [data-theme="dark"] .preview-modal-content {
        background: rgba(0, 0, 0, 0.95) !important;
    }

    /* Sombra suave na imagem */
    #mediaPreviewModal img {
        box-shadow: 0 10px 40px rgba(0, 0, 0, 0.3);
    }

    /* Tema escuro: sombra mais forte */
    [data-pc-theme="dark"] #mediaPreviewModal img,
    [data-theme="dark"] #mediaPreviewModal img {
        box-shadow: 0 10px 40px rgba(0, 0, 0, 0.7);
    }
    
    /* Modal dialog que se ajusta ao conteúdo */
    div#mediaPreviewModal.modal .modal-dialog.modal-dialog-centered.preview-modal-dialog,
    #mediaPreviewModal.show .modal-dialog.preview-modal-dialog,
    #mediaPreviewModal .modal-dialog.preview-modal-dialog {
        max-width: 90vw !important;
        width: auto !important;
        margin: 1.75rem auto !important;
        display: flex !important;
        align-items: center !important;
        min-height: calc(100vh - 3.5rem) !important;
    }

    /* Modal content ajustado */
    div#mediaPreviewModal.modal .modal-dialog .modal-content,
    #mediaPreviewModal.show .modal-content,
    #mediaPreviewModal .modal-content {
        width: auto !important;
        max-width: 100% !important;
        overflow: hidden !important;
        display: flex !important;
        flex-direction: column !important;
        box-sizing: border-box !important;
    }

    /* Modal body sem largura fixa */
    div#mediaPreviewModal.modal .modal-body,
    #mediaPreviewModal.show .modal-body,
    #mediaPreviewModal .modal-body {
        width: auto !important;
        max-width: 100% !important;
        padding: 1.5rem !important;
        overflow: hidden !important;
        display: flex !important;
        justify-content: center !important;
        align-items: center !important;
        box-sizing: border-box !important;
        min-height: 400px !important;
    }

    /* Tema escuro: texto branco */
    [data-pc-theme="dark"] #mediaPreviewModal .modal-body,
    [data-theme="dark"] #mediaPreviewModal .modal-body {
        color: #fff !important;
    }

    /* Tema escuro: botão fechar branco */
    [data-pc-theme="dark"] #mediaPreviewModal .btn-close,
    [data-theme="dark"] #mediaPreviewModal .btn-close {
        filter: invert(1) grayscale(100%) brightness(200%);
    }

    /* Imagem do preview */
    div#mediaPreviewModal.modal .modal-body img,
    #mediaPreviewModal.show .modal-body img,
    #mediaPreviewModal .modal-body img,
    #mediaPreviewModal img {
        max-height: 75vh !important;
        max-width: 100% !important;
        width: auto !important;
        height: auto !important;
        display: block !important;
        margin: 0 auto !important;
        box-shadow: 0 10px 40px rgba(0, 0, 0, 0.5) !important;
        border-radius: 8px !important;
        object-fit: contain !important;
    }

    /* Vídeo do preview */
    div#mediaPreviewModal.modal .modal-body video,
    #mediaPreviewModal.show .modal-body video,
    #mediaPreviewModal .modal-body video {
        max-height: 75vh !important;
        max-width: 100% !important;
        width: auto !important;
        height: auto !important;
        border-radius: 8px !important;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        // Main page actions - using event delegation
        document.body.addEventListener('click', function(event) {
            const deleteBtn = event.target.closest('.delete-midia');
            if (deleteBtn) {
                event.preventDefault();
                let midiaId = deleteBtn.dataset.id;
                if (confirm('Tem certeza que deseja enviar este item para a lixeira?')) {
                    document.getElementById('delete-form-' + midiaId).submit();
                }
            }

            const toggleBtn = event.target.closest('.toggle-status');
            if (toggleBtn) {
                event.preventDefault();
                let midiaId = toggleBtn.dataset.id;
                document.getElementById('toggle-status-form-' + midiaId).submit();
            }
        });

        // Media Preview Modal
        const mediaPreviewModal = document.getElementById('mediaPreviewModal');
        if(mediaPreviewModal) {
            // Função para aplicar estilos dinâmicos no modal
            function forceMediaModalStyles(imageWidth = null) {
                const modalDialog = mediaPreviewModal.querySelector('.modal-dialog');
                const modalContent = mediaPreviewModal.querySelector('.modal-content');
                const modalBody = mediaPreviewModal.querySelector('.modal-body');

                if (modalDialog) {
                    let targetWidth;

                    if (imageWidth) {
                        // Se temos a largura da imagem, usar ela + padding (aproximadamente 100px)
                        const modalPadding = 100;
                        targetWidth = Math.min(imageWidth + modalPadding, window.innerWidth * 0.9);
                    } else {
                        // Fallback: 80% da largura da viewport
                        targetWidth = Math.floor(window.innerWidth * 0.80);
                    }

                    // FORÇAR estilos inline (maior prioridade)
                    modalDialog.style.cssText = `
                        max-width: ${targetWidth}px !important;
                        width: auto !important;
                        margin: 1.75rem auto !important;
                        display: flex !important;
                        align-items: center !important;
                        min-height: calc(100vh - 3.5rem) !important;
                    `;
                }

                if (modalContent) {
                    modalContent.style.cssText = `
                        max-width: 100% !important;
                        width: auto !important;
                        overflow: hidden !important;
                        box-sizing: border-box !important;
                    `;
                }

                if (modalBody) {
                    modalBody.style.cssText = `
                        max-width: 100% !important;
                        width: auto !important;
                        padding: 1.5rem !important;
                        overflow: hidden !important;
                        display: flex !important;
                        justify-content: center !important;
                        align-items: center !important;
                        box-sizing: border-box !important;
                        min-height: 400px !important;
                    `;
                }
            }

            mediaPreviewModal.addEventListener('show.bs.modal', function (event) {
                const button = event.relatedTarget;
                const mediaPath = button.getAttribute('data-path');
                const mediaType = button.getAttribute('data-type');
                const modalBody = document.getElementById('mediaPreviewBody');
                const previewLoader = document.getElementById('previewLoader');

                console.log('Preview - Path:', mediaPath, 'Type:', mediaType);

                // Aplicar estilos iniciais
                setTimeout(() => forceMediaModalStyles(), 50);

                // Mostrar preloader
                if(previewLoader) {
                    previewLoader.style.display = 'block';
                }
                
                // Limpar conteúdo anterior (mas manter o loader)
                const existingMedia = modalBody.querySelector('img, video');
                if(existingMedia) {
                    existingMedia.remove();
                }
                
                if (mediaType === 'imagem' || mediaType === 'image') {
                    // Criar elemento de imagem
                    const img = document.createElement('img');
                    img.src = mediaPath;
                    img.className = 'img-fluid rounded shadow-lg';
                    img.style.maxHeight = '80vh';
                    img.style.maxWidth = '100%';
                    img.style.display = 'none'; // Esconder até carregar
                    img.alt = 'Preview da mídia';
                    
                    // Adicionar tratamento de erro
                    img.onerror = function() {
                        console.error('Erro ao carregar imagem:', mediaPath);
                        if(previewLoader) {
                            previewLoader.style.display = 'none';
                        }
                        modalBody.innerHTML = `
                            <div class="alert alert-danger">
                                <i class="ph-duotone ph-warning-circle me-2"></i>
                                <strong>Erro ao carregar imagem</strong>
                                <p class="mb-0 mt-2">Caminho: ${mediaPath}</p>
                                <p class="mb-0 opacity-75">Verifique se o arquivo existe e o link simbólico está correto.</p>
                            </div>
                        `;
                    };
                    
                    img.onload = function() {
                        console.log('Imagem carregada com sucesso!');

                        // Obter largura natural da imagem
                        const imageNaturalWidth = img.naturalWidth;
                        const maxHeight = window.innerHeight * 0.75; // 75vh

                        // Calcular largura proporcional se a altura for limitada
                        let displayWidth = imageNaturalWidth;
                        if (img.naturalHeight > maxHeight) {
                            const aspectRatio = imageNaturalWidth / img.naturalHeight;
                            displayWidth = maxHeight * aspectRatio;
                        }

                        // Esconder preloader
                        if(previewLoader) {
                            previewLoader.style.display = 'none';
                        }

                        // Aplicar estilos na imagem
                        img.style.cssText = `
                            max-width: 100% !important;
                            max-height: 75vh !important;
                            width: auto !important;
                            height: auto !important;
                            display: block !important;
                            margin: 0 auto !important;
                            object-fit: contain !important;
                            border-radius: 8px !important;
                            box-shadow: 0 10px 40px rgba(0, 0, 0, 0.5) !important;
                            animation: fadeIn 0.3s ease-in !important;
                        `;

                        // FORÇAR estilos do modal com a largura da imagem
                        forceMediaModalStyles(displayWidth);

                        // Log para debug
                        console.log('🖼️ Imagem carregada:', {
                            naturalWidth: img.naturalWidth,
                            naturalHeight: img.naturalHeight,
                            displayWidth: displayWidth,
                            calculatedModalWidth: Math.min(displayWidth + 100, window.innerWidth * 0.9),
                            modalWidth: mediaPreviewModal.querySelector('.modal-dialog').offsetWidth
                        });
                    };
                    
                    modalBody.appendChild(img);
                } else if (mediaType === 'video') {
                    // Esconder preloader para vídeo
                    if(previewLoader) {
                        previewLoader.style.display = 'none';
                    }
                    
                    // Criar elemento de vídeo
                    const video = document.createElement('video');
                    video.src = mediaPath;
                    video.controls = true;
                    video.className = 'rounded shadow-lg';
                    video.style.maxHeight = '80vh';
                    video.style.maxWidth = '100%';
                    modalBody.appendChild(video);
                } else {
                    // Esconder preloader
                    if(previewLoader) {
                        previewLoader.style.display = 'none';
                    }
                    modalBody.innerHTML = '<p class="text-white-50">Preview não disponível para este tipo de mídia.</p>';
                }
            });
            
            // Listener para redimensionamento de janela
            window.addEventListener('resize', function() {
                if (mediaPreviewModal.classList.contains('show')) {
                    forceMediaModalStyles();
                }
            });

            // Resetar modal ao fechar
            mediaPreviewModal.addEventListener('hidden.bs.modal', function () {
                const modalBody = document.getElementById('mediaPreviewBody');
                const previewLoader = document.getElementById('previewLoader');
                
                // Remover mídia carregada
                const existingMedia = modalBody.querySelector('img, video');
                if(existingMedia) {
                    existingMedia.remove();
                }
                
                // Mostrar loader novamente para próxima abertura
                if(previewLoader) {
                    previewLoader.style.display = 'block';
                }
            });
        }

        // Analytics Modal
        const analyticsModal = document.getElementById('analyticsModal');
        if(analyticsModal) {
            analyticsModal.addEventListener('show.bs.modal', function (event) {
                const button = event.relatedTarget;
                const mediaTitle = button.getAttribute('data-media-title');
                const modalTitle = analyticsModal.querySelector('.modal-title');
                modalTitle.textContent = 'Visualizações da mídia: ' + mediaTitle;
            });
        }

        // Trash Modal
        const trashModal = document.getElementById('trashModal');
        if(trashModal) {
            trashModal.addEventListener('show.bs.modal', function () {
                const modalBody = document.getElementById('trashModalBody');
                modalBody.innerHTML = '<p>Carregando...</p>';

                fetch('<?php echo e(route("midias.trash")); ?>')
                    .then(response => response.json())
                    .then(data => {
                        if (data.length === 0) {
                            modalBody.innerHTML = '<p>A lixeira está vazia.</p>';
                            return;
                        }

                        let tableHtml = '<div class="table-responsive"><table class="table align-middle"><thead><tr><th>Mídia</th><th>Excluído em</th><th>Excluído por</th><th>Ações</th></tr></thead><tbody>';
                        data.forEach(midia => {
                            const deletedAt = new Date(midia.deleted_at).toLocaleString('pt-BR');
                            const destroyerName = midia.destroyer ? midia.destroyer.name : 'Usuário desconhecido';
                            const imageUrl = midia.path ? `<?php echo e(Storage::url('/')); ?>${midia.path}` : 'https://via.placeholder.com/80x80';

                            tableHtml += `
                                <tr>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <img src="${imageUrl}" class="rounded" width="80" height="80" style="object-fit: cover;">
                                            <span class="ms-2">${midia.title}</span>
                                        </div>
                                    </td>
                                    <td>${deletedAt}</td>
                                    <td>${destroyerName}</td>
                                    <td>
                                        <button class="btn btn-sm btn-success restore-midia" data-id="${midia.id}">Restaurar</button>
                                        <form id="restore-form-${midia.id}" action="/midias/${midia.id}/restore" method="POST" style="display: none;">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('PATCH'); ?>
                                        </form>
                                    </td>
                                </tr>
                            `;
                        });
                        tableHtml += '</tbody></table></div>';
                        modalBody.innerHTML = tableHtml;
                    })
                    .catch(error => {
                        modalBody.innerHTML = '<p>Ocorreu um erro ao carregar os itens.</p>';
                        console.error('Error fetching trash:', error);
                    });
            });

            trashModal.addEventListener('click', function(event) {
                const restoreBtn = event.target.closest('.restore-midia');
                if (restoreBtn) {
                    event.preventDefault();
                    let midiaId = restoreBtn.dataset.id;
                    if (confirm('Tem certeza que deseja restaurar este item?')) {
                        document.getElementById('restore-form-' + midiaId).submit();
                    }
                }
            });
        }
    });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/resources/views/midias/index.blade.php ENDPATH**/ ?>