<?php $__env->startSection('title', 'Editar Publicação'); ?>
<?php $__env->startSection('main-content'); ?>
    <div class="container-fluid">
        <!-- Breadcrumb -->
        <div class="row m-1">
            <div class="col-12">
                <h5><i class="ph-duotone ph-broadcast f-s-16 me-2"></i>Editar Publicação</h5>
                <ul class="app-line-breadcrumbs mb-3">
                    <li>
                        <a href="<?php echo e(route('publicacoes.index')); ?>" class="f-s-14 f-w-500">
                            <span>Publicações</span>
                        </a>
                    </li>
                    <li class="active">
                        <a href="#" class="f-s-14 f-w-500">Editar</a>
                    </li>
                </ul>
            </div>
        </div>

        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <h5>Detalhes da Publicação</h5>
                    </div>
                    <div class="card-body">
                        <form class="app-form" action="<?php echo e(route('publicacoes.update', $publicacao)); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PUT'); ?>

                            <div class="row">
                                <!-- Criativo -->
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label">Criativo <span class="text-danger">*</span></label>
                                        <select id="criativo_id_select" name="criativo_id" class="form-control <?php $__errorArgs = ['criativo_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                                            <option value="">Selecione um criativo...</option>
                                            <?php $__currentLoopData = $criativos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $criativo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($criativo->id); ?>" <?php if(old('criativo_id', $publicacao->criativo_id) == $criativo->id): ?> selected <?php endif; ?>>
                                                    <?php echo e($criativo->title); ?> (<?php echo e(ucfirst($criativo->tipo ?? 'imagem')); ?>)
                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <?php $__errorArgs = ['criativo_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        <small class="form-text text-muted">
                                            Apenas criativos aprovados estão disponíveis
                                        </small>
                                    </div>
                                </div>

                                <!-- Preview do Criativo -->
                                <div class="col-md-6">
                                    <div id="criativo-preview-container" style="display: none;" class="mb-3">
                                        <div class="card bg-light h-100">
                                            <div class="card-body p-2">
                                                <h6 class="card-title mb-2 f-s-12">
                                                    <i class="ph-duotone ph-image me-1"></i>Preview
                                                </h6>
                                                <div id="criativo-preview-media" style="min-height: 150px; display: flex; align-items: center; justify-content: center; background-color: #f8f9fa; border-radius: 4px; overflow: hidden;">
                                                    <span class="text-muted f-s-12">Carregando...</span>
                                                </div>
                                                <div class="criativo-details mt-2">
                                                    <p class="mb-1 f-s-11">
                                                        <strong>Título:</strong> <span id="criativo-title"></span>
                                                    </p>
                                                    <p class="mb-1 f-s-11">
                                                        <strong>Tipo:</strong> <span id="criativo-type"></span>
                                                    </p>
                                                    <p class="mb-1 f-s-11">
                                                        <strong>Empresa:</strong> <span id="criativo-empresa"></span>
                                                    </p>
                                                    <p class="mb-1 f-s-11">
                                                        <strong>Dimensões:</strong> <span id="criativo-dimensions"></span>
                                                    </p>
                                                    <p class="mb-0 f-s-11">
                                                        <strong>Tamanho:</strong> <span id="criativo-size"></span>
                                                    </p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Título -->
                                <div class="col-md-12">
                                    <div class="mb-3">
                                        <label class="form-label">Título da Campanha <span class="text-danger">*</span></label>
                                        <input type="text" 
                                               name="titulo" 
                                               class="form-control <?php $__errorArgs = ['titulo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                               placeholder="Ex: Campanha Black Friday 2025" 
                                               value="<?php echo e(old('titulo', $publicacao->titulo)); ?>" 
                                               required>
                                        <?php $__errorArgs = ['titulo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>

                                <div class="col-12"><hr class="my-3"></div>
                                <div class="col-12"><h6 class="mb-3">Relacionamentos</h6></div>

                                <!-- Franquia -->
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label">Franquia (Vendedor) <span class="text-danger">*</span></label>
                                        <select name="franquia_id" class="form-control <?php $__errorArgs = ['franquia_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                                            <option value="">Selecione uma franquia...</option>
                                            <?php $__currentLoopData = $franquias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $franquia): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($franquia->id); ?>" <?php if(old('franquia_id', $publicacao->franquia_id) == $franquia->id): ?> selected <?php endif; ?>>
                                                    <?php echo e($franquia->name); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <?php $__errorArgs = ['franquia_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>

                                <!-- Cliente -->
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label">Cliente (Comprador) <span class="text-danger">*</span></label>
                                        <select name="cliente_id" class="form-control <?php $__errorArgs = ['cliente_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                                            <option value="">Selecione um cliente...</option>
                                            <?php $__currentLoopData = $clientes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cliente): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($cliente->id); ?>" <?php if(old('cliente_id', $publicacao->cliente_id) == $cliente->id): ?> selected <?php endif; ?>>
                                                    <?php echo e($cliente->name); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <?php $__errorArgs = ['cliente_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>

                                <div class="col-12"><hr class="my-3"></div>
                                <div class="col-12"><h6 class="mb-3">Alcance da Publicação</h6></div>

                                <!-- Tipo de Alcance -->
                                <div class="col-md-4">
                                    <div class="mb-3">
                                        <label class="form-label">Tipo de Alcance <span class="text-danger">*</span></label>
                                        <select name="tipo_alcance" id="tipo_alcance" class="form-control <?php $__errorArgs = ['tipo_alcance'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                                            <option value="todos" <?php if(old('tipo_alcance', $publicacao->tipo_alcance) == 'todos'): ?> selected <?php endif; ?>>Todos os equipamentos</option>
                                            <option value="serial_especifico" <?php if(old('tipo_alcance', $publicacao->tipo_alcance) == 'serial_especifico'): ?> selected <?php endif; ?>>Serial Específico</option>
                                            <option value="empresa" <?php if(old('tipo_alcance', $publicacao->tipo_alcance) == 'empresa'): ?> selected <?php endif; ?>>Empresa Específica</option>
                                        </select>
                                        <?php $__errorArgs = ['tipo_alcance'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        <small class="form-text text-muted">
                                            Define se a publicação será exibida em todos equipamentos, apenas um específico ou em todos os equipamentos de uma empresa
                                        </small>
                                    </div>
                                </div>

                                <!-- Equipment Serial (condicional) -->
                                <div class="col-md-4" id="serial_field" style="display: <?php echo e(old('tipo_alcance', $publicacao->tipo_alcance) == 'serial_especifico' ? 'block' : 'none'); ?>;">
                                    <div class="mb-3">
                                        <label class="form-label">Serial do Equipamento <span class="text-danger">*</span></label>
                                        <input type="text" 
                                               name="equipment_serial" 
                                               class="form-control <?php $__errorArgs = ['equipment_serial'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                               placeholder="Ex: ABC123456" 
                                               value="<?php echo e(old('equipment_serial', $publicacao->equipment_serial)); ?>">
                                        <?php $__errorArgs = ['equipment_serial'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>

                                <!-- Empresa Específica (condicional) -->
                                <div class="col-md-4" id="empresa_field" style="display: <?php echo e(old('tipo_alcance', $publicacao->tipo_alcance) == 'empresa' ? 'block' : 'none'); ?>;">
                                    <div class="mb-3">
                                        <label class="form-label">Empresa <span class="text-danger">*</span></label>
                                        <select name="empresa_alcance_id" 
                                               class="form-control <?php $__errorArgs = ['empresa_alcance_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                            <option value="">Selecione uma empresa</option>
                                            <?php $__currentLoopData = $clientes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cliente): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($cliente->id); ?>" <?php if(old('empresa_alcance_id', $publicacao->empresa_alcance_id) == $cliente->id): ?> selected <?php endif; ?>>
                                                    <?php echo e($cliente->name); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <?php $__errorArgs = ['empresa_alcance_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        <small class="form-text text-muted">
                                            Sistema de grupos será implementado futuramente
                                        </small>
                                    </div>
                                </div>

                                <div class="col-12"><hr class="my-3"></div>
                                <div class="col-12"><h6 class="mb-3">Configuração de Tracking e Cliques</h6></div>

                                <!-- Link de Destino -->
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label">Link de Destino (URL)</label>
                                        <input type="text"
                                               name="link_destino"
                                               id="link_destino"
                                               class="form-control <?php $__errorArgs = ['link_destino'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                               placeholder="https://exemplo.com/oferta ou # para desabilitar"
                                               value="<?php echo e(old('link_destino', $publicacao->link_destino)); ?>">
                                        <?php $__errorArgs = ['link_destino'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        <small class="form-text text-muted">
                                            URL para onde o usuário será redirecionado ao clicar no anúncio. Use # para link inativo.
                                        </small>
                                    </div>
                                </div>

                                <!-- Habilitar Clique -->
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label d-block">Opções de Interação</label>
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" 
                                                   type="checkbox" 
                                                   name="habilitar_clique" 
                                                   id="habilitar_clique"
                                                   value="1"
                                                   <?php echo e(old('habilitar_clique', $publicacao->habilitar_clique) ? 'checked' : ''); ?>>
                                            <label class="form-check-label" for="habilitar_clique">
                                                🖱️ Habilitar cliques no anúncio
                                            </label>
                                        </div>
                                        <div class="form-check form-switch mt-2">
                                            <input class="form-check-input" 
                                                   type="checkbox" 
                                                   name="track_impressoes" 
                                                   id="track_impressoes"
                                                   value="1"
                                                   <?php echo e(old('track_impressoes', $publicacao->track_impressoes) ? 'checked' : ''); ?>>
                                            <label class="form-check-label" for="track_impressoes">
                                                👁️ Rastrear impressões (visualizações)
                                            </label>
                                        </div>
                                        <div class="form-check form-switch mt-2">
                                            <input class="form-check-input" 
                                                   type="checkbox" 
                                                   name="track_cliques" 
                                                   id="track_cliques"
                                                   value="1"
                                                   <?php echo e(old('track_cliques', $publicacao->track_cliques) ? 'checked' : ''); ?>>
                                            <label class="form-check-label" for="track_cliques">
                                                🎯 Rastrear cliques no anúncio
                                            </label>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-12"><hr class="my-3"></div>
                                <div class="col-12">
                                    <h6 class="mb-2">
                                        Walled Garden - Domínios/IPs Liberados
                                        <small class="text-muted">(Opcional)</small>
                                    </h6>
                                    <p class="text-muted small mb-3">
                                        <i class="ph-duotone ph-shield-check me-1"></i>
                                        Configure domínios, IPs ou subnets que serão liberados no hotspot 
                                        <strong>antes da autenticação</strong> para permitir carregamento de conteúdo externo.
                                    </p>
                                </div>

                                <!-- Container de Walled Gardens -->
                                <div class="col-12">
                                    <div id="walledGardensContainer">
                                        <!-- Items serão adicionados aqui via JavaScript -->
                                    </div>
                                    
                                    <button type="button" 
                                            class="btn btn-outline-primary btn-sm mt-2" 
                                            id="addWalledGarden">
                                        <i class="ph-duotone ph-plus-circle me-1"></i>Adicionar Domínio/IP
                                    </button>
                                </div>

                                <div class="col-12"><hr class="my-3"></div>
                                <div class="col-12"><h6 class="mb-3">Período de Exibição</h6></div>

                                <!-- Data Início -->
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label">Data de Início <span class="text-danger">*</span></label>
                                        <input type="date" 
                                               name="data_inicio" 
                                               class="form-control <?php $__errorArgs = ['data_inicio'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                               value="<?php echo e(old('data_inicio', $publicacao->data_inicio->format('Y-m-d'))); ?>" 
                                               required>
                                        <?php $__errorArgs = ['data_inicio'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>

                                <!-- Data Fim -->
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label">Data de Término <span class="text-danger">*</span></label>
                                        <input type="date" 
                                               name="data_fim" 
                                               class="form-control <?php $__errorArgs = ['data_fim'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                               value="<?php echo e(old('data_fim', $publicacao->data_fim->format('Y-m-d'))); ?>" 
                                               required>
                                        <?php $__errorArgs = ['data_fim'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>

                                <div class="col-12"><hr class="my-3"></div>
                                <div class="col-12"><h6 class="mb-3">Valores Comerciais</h6></div>

                                <!-- Valor do Contrato -->
                                <div class="col-md-4">
                                    <div class="mb-3">
                                        <label class="form-label">Valor do Contrato (R$)</label>
                                        <input type="number" 
                                               name="valor_contrato" 
                                               class="form-control <?php $__errorArgs = ['valor_contrato'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                               placeholder="0.00" 
                                               step="0.01"
                                               min="0"
                                               value="<?php echo e(old('valor_contrato', $publicacao->valor_contrato)); ?>">
                                        <?php $__errorArgs = ['valor_contrato'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>

                                <!-- Impressões Contratadas -->
                                <div class="col-md-4">
                                    <div class="mb-3">
                                        <label class="form-label">Impressões Contratadas</label>
                                        <input type="number" 
                                               name="impressoes_contratadas" 
                                               class="form-control <?php $__errorArgs = ['impressoes_contratadas'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                               placeholder="0" 
                                               min="0"
                                               value="<?php echo e(old('impressoes_contratadas', $publicacao->impressoes_contratadas)); ?>">
                                        <?php $__errorArgs = ['impressoes_contratadas'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>

                                <!-- Status -->
                                <div class="col-md-4">
                                    <div class="mb-3">
                                        <label class="form-label">Status <span class="text-danger">*</span></label>
                                        <select name="status" class="form-control <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                                            <option value="ativa" <?php if(old('status', $publicacao->status) == 'ativa'): ?> selected <?php endif; ?>>Ativa</option>
                                            <option value="pausada" <?php if(old('status', $publicacao->status) == 'pausada'): ?> selected <?php endif; ?>>Pausada</option>
                                            <option value="expirada" <?php if(old('status', $publicacao->status) == 'expirada'): ?> selected <?php endif; ?>>Expirada</option>
                                            <option value="cancelada" <?php if(old('status', $publicacao->status) == 'cancelada'): ?> selected <?php endif; ?>>Cancelada</option>
                                        </select>
                                        <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>

                                <!-- Info adicional -->
                                <?php if($publicacao->publicadoPor): ?>
                                    <div class="col-12">
                                        <div class="alert alert-info">
                                            <i class="ph-duotone ph-info me-2"></i>
                                            <strong>Publicado por:</strong> <?php echo e($publicacao->publicadoPor->name); ?> 
                                            em <?php echo e($publicacao->publicada_em->format('d/m/Y H:i')); ?>

                                        </div>
                                    </div>
                                <?php endif; ?>

                                <div class="col-12 text-end mt-3">
                                    <div class="btn-group" role="group">
                                        <button type="submit" class="btn btn-success">
                                            <i class="ph-duotone ph-floppy-disk me-2"></i>Atualizar Publicação
                                        </button>
                                        <a href="<?php echo e(route('publicacoes.index')); ?>" class="btn btn-secondary">
                                            <i class="ph-duotone ph-x-circle me-2"></i>Cancelar
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        // === WALLED GARDENS DINÂMICOS ===
        let walledGardenCounter = 0;

        function createWalledGardenRow(data = {}) {
            const index = data.id ? `existing_${data.id}` : `new_${walledGardenCounter++}`;
            const row = document.createElement('div');
            row.className = 'card mb-3 walled-garden-item';
            row.dataset.index = index;
            
            row.innerHTML = `
                <div class="card-body">
                    <div class="row align-items-end">
                        ${data.id ? `<input type="hidden" name="walled_gardens[${index}][id]" value="${data.id}">` : ''}
                        <div class="col-md-3">
                            <label class="form-label">Tipo</label>
                            <select name="walled_gardens[${index}][tipo]" 
                                    class="form-control walled-garden-tipo" 
                                    data-index="${index}">
                                <option value="domain" ${data.tipo === 'domain' ? 'selected' : ''}>🌐 Domínio</option>
                                <option value="ip" ${data.tipo === 'ip' ? 'selected' : ''}>📡 IP</option>
                                <option value="subnet" ${data.tipo === 'subnet' ? 'selected' : ''}>🔒 Subnet</option>
                            </select>
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">Endereço <span class="text-danger">*</span></label>
                            <input type="text" 
                                   name="walled_gardens[${index}][endereco]" 
                                   class="form-control walled-garden-endereco"
                                   placeholder="exemplo.com"
                                   value="${data.endereco || ''}"
                                   required>
                            <small class="form-text text-muted walled-garden-hint">
                                Ex: exemplo.com
                            </small>
                        </div>
                        <div class="col-md-3">
                            <label class="form-label">Descrição (Opcional)</label>
                            <input type="text" 
                                   name="walled_gardens[${index}][descricao]" 
                                   class="form-control"
                                   placeholder="Ex: CDN de imagens"
                                   value="${data.descricao || ''}">
                        </div>
                        <div class="col-md-1">
                            <div class="form-check form-switch mb-2">
                                <input class="form-check-input" 
                                       type="checkbox" 
                                       name="walled_gardens[${index}][ativo]" 
                                       value="1"
                                       ${data.ativo !== false ? 'checked' : ''}
                                       title="Ativo">
                            </div>
                        </div>
                        <div class="col-md-1">
                            <button type="button" 
                                    class="btn btn-danger btn-sm w-100 remove-walled-garden"
                                    title="Remover">
                                <i class="ph-duotone ph-trash"></i>
                            </button>
                        </div>
                    </div>
                </div>
            `;
            
            return row;
        }

        // Adicionar evento para atualizar placeholder baseado no tipo
        document.addEventListener('change', function(e) {
            if(e.target.classList.contains('walled-garden-tipo')) {
                const container = e.target.closest('.card-body');
                const enderecoInput = container.querySelector('.walled-garden-endereco');
                const hint = container.querySelector('.walled-garden-hint');
                const tipo = e.target.value;
                
                switch(tipo) {
                    case 'domain':
                        enderecoInput.placeholder = 'exemplo.com';
                        hint.textContent = 'Ex: exemplo.com ou cdn.exemplo.com';
                        break;
                    case 'ip':
                        enderecoInput.placeholder = '192.168.1.1';
                        hint.textContent = 'Ex: 192.168.1.1 ou 200.200.200.200';
                        break;
                    case 'subnet':
                        enderecoInput.placeholder = '192.168.1.0/24';
                        hint.textContent = 'Ex: 192.168.1.0/24 ou 10.0.0.0/8';
                        break;
                }
            }
        });

        // Botão adicionar walled garden
        document.getElementById('addWalledGarden').addEventListener('click', function() {
            const container = document.getElementById('walledGardensContainer');
            const row = createWalledGardenRow();
            container.appendChild(row);
            
            // Animar entrada
            row.style.opacity = '0';
            row.style.transform = 'translateY(-10px)';
            setTimeout(() => {
                row.style.transition = 'all 0.3s ease';
                row.style.opacity = '1';
                row.style.transform = 'translateY(0)';
            }, 10);
        });

        // Remover walled garden (delegação de evento)
        document.addEventListener('click', function(e) {
            if(e.target.closest('.remove-walled-garden')) {
                const item = e.target.closest('.walled-garden-item');
                
                // Animar saída
                item.style.transition = 'all 0.3s ease';
                item.style.opacity = '0';
                item.style.transform = 'translateX(20px)';
                
                setTimeout(() => {
                    item.remove();
                }, 300);
            }
        });

        // Carregar walled gardens existentes do banco de dados
        document.addEventListener('DOMContentLoaded', function() {
            const container = document.getElementById('walledGardensContainer');
            
            // Carregar walled gardens existentes
            <?php if($publicacao->walledGardens && $publicacao->walledGardens->count() > 0): ?>
                const existingData = <?php echo json_encode($publicacao->walledGardens->toArray(), 15, 512) ?>;
                
                existingData.forEach(wg => {
                    const row = createWalledGardenRow(wg);
                    container.appendChild(row);
                });
            <?php endif; ?>
            
            // Carregar old() se houver (após validação falhada)
            <?php if(old('walled_gardens')): ?>
                // Limpar existentes se há old data
                container.innerHTML = '';
                
                const oldData = <?php echo json_encode(old('walled_gardens'), 15, 512) ?>;
                
                Object.values(oldData).forEach(wg => {
                    const row = createWalledGardenRow(wg);
                    container.appendChild(row);
                });
            <?php endif; ?>
        });

        // === CONTROLE DE CAMPOS CONDICIONAIS ===
        // Controlar exibição de campos condicionais baseado no tipo de alcance
        document.addEventListener('DOMContentLoaded', function() {
            const tipoAlcanceSelect = document.getElementById('tipo_alcance');
            const serialField = document.getElementById('serial_field');
            const grupoField = document.getElementById('empresa_field');
            
            function updateFields() {
                const value = tipoAlcanceSelect.value;
                
                // Ocultar todos primeiro
                serialField.style.display = 'none';
                grupoField.style.display = 'none';
                
                // Mostrar campo relevante
                if (value === 'serial_especifico') {
                    serialField.style.display = 'block';
                } else if (value === 'empresa') {
                    grupoField.style.display = 'block';
                }
            }
            
            // Executar ao carregar (já feito pelo PHP, mas garantir)
            updateFields();
            
            // Executar ao mudar
            tipoAlcanceSelect.addEventListener('change', updateFields);
        });

        // === PREVIEW DO CRIATIVO ===
        document.addEventListener('DOMContentLoaded', function() {
            const criativoSelect = document.getElementById('criativo_id_select');
            const previewContainer = document.getElementById('criativo-preview-container');
            
            // Função para carregar e exibir preview
            function loadCriativoPreview(criativoId) {
                if (!criativoId) {
                    previewContainer.style.display = 'none';
                    return;
                }

                fetch(`/publicacoes/criativo/${criativoId}`)
                    .then(response => {
                        if (!response.ok) throw new Error('Erro ao carregar criativo');
                        return response.json();
                    })
                    .then(data => {
                        // Preencher detalhes
                        document.getElementById('criativo-title').textContent = data.title || '-';
                        document.getElementById('criativo-type').textContent = (data.tipo || 'imagem').toUpperCase();
                        document.getElementById('criativo-empresa').textContent = data.empresa || '-';
                        document.getElementById('criativo-dimensions').textContent = `${data.width} x ${data.height}px`;
                        document.getElementById('criativo-size').textContent = data.size ? formatBytes(data.size) : '-';

                        // Exibir mídia (imagem ou vídeo)
                        const mediaContainer = document.getElementById('criativo-preview-media');
                        mediaContainer.innerHTML = '';

                        if (data.path) {
                            if (data.tipo === 'video') {
                                const video = document.createElement('video');
                                video.src = data.path;
                                video.style.maxWidth = '100%';
                                video.style.maxHeight = '300px';
                                video.controls = true;
                                mediaContainer.appendChild(video);
                            } else {
                                const img = document.createElement('img');
                                img.src = data.path;
                                img.style.maxWidth = '100%';
                                img.style.maxHeight = '300px';
                                img.style.objectFit = 'contain';
                                mediaContainer.appendChild(img);
                            }
                        } else {
                            mediaContainer.innerHTML = '<span class="text-muted">Sem arquivo disponível</span>';
                        }

                        previewContainer.style.display = 'block';
                    })
                    .catch(error => {
                        console.error('Erro:', error);
                        previewContainer.style.display = 'none';
                    });
            }

            // Converter bytes para formato legível
            function formatBytes(bytes, decimals = 2) {
                if (bytes === 0) return '0 Bytes';
                const k = 1024;
                const dm = decimals < 0 ? 0 : decimals;
                const sizes = ['Bytes', 'KB', 'MB', 'GB'];
                const i = Math.floor(Math.log(bytes) / Math.log(k));
                return parseFloat((bytes / Math.pow(k, i)).toFixed(dm)) + ' ' + sizes[i];
            }

            // Carregar preview ao mudar seleção
            criativoSelect.addEventListener('change', function() {
                loadCriativoPreview(this.value);
            });

            // Carregar preview inicial se houver criativo selecionado
            if (criativoSelect.value) {
                loadCriativoPreview(criativoSelect.value);
            }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/resources/views/publicacoes/edit.blade.php ENDPATH**/ ?>