<?php

use App\Models\Empresa;
use App\Models\User;

test('shows correct row numbering on first page', function () {
    $user = User::factory()->create();
    $this->actingAs($user);
    
    // Criar 5 empresas
    Empresa::factory()->count(5)->create();
    
    $response = $this->get(route('empresas.index'));
    
    $response->assertStatus(200);
    
    // Verificar se a coluna # existe
    $response->assertSee('<th scope="col" class="text-center" width="50">#</th>', false);
    
    // Verificar se os números aparecem (1, 2, 3, 4, 5)
    for ($i = 1; $i <= 5; $i++) {
        $response->assertSee('<td class="text-center">' . $i . '</td>', false);
    }
});

test('shows correct row numbering on second page', function () {
    $user = User::factory()->create();
    $this->actingAs($user);
    
    // Criar 25 empresas (mais que uma página)
    Empresa::factory()->count(25)->create();
    
    // Acessar a segunda página (assumindo 15 por página)
    $response = $this->get(route('empresas.index', ['page' => 2]));
    
    $response->assertStatus(200);
    
    // Na segunda página, a numeração deve começar em 16
    $response->assertSee('<td class="text-center">16</td>', false);
    $response->assertSee('<td class="text-center">17</td>', false);
    $response->assertSee('<td class="text-center">18</td>', false);
});

test('row numbering works with search', function () {
    $user = User::factory()->create();
    $this->actingAs($user);
    
    // Criar empresas com nomes específicos
    Empresa::factory()->create(['name' => 'Empresa A']);
    Empresa::factory()->create(['name' => 'Empresa B']);
    Empresa::factory()->create(['name' => 'Outro Nome']);
    Empresa::factory()->create(['name' => 'Empresa C']);
    
    // Buscar por "Empresa" (deve retornar 3 resultados)
    $response = $this->get(route('empresas.index', ['q' => 'Empresa']));
    
    $response->assertStatus(200);
    
    // Verificar se a numeração ainda funciona com busca
    $response->assertSee('<td class="text-center">1</td>', false);
    $response->assertSee('<td class="text-center">2</td>', false);
    $response->assertSee('<td class="text-center">3</td>', false);
    
    // Não deve mostrar número 4 já que só há 3 resultados
    $response->assertDontSee('<td class="text-center">4</td>', false);
});