<?php

namespace Tests\Feature;

use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Http\UploadedFile;
use Illuminate\Support\Facades\Storage;
use Tests\TestCase;
use App\Models\User;
use App\Models\Empresa;
use App\Models\Midia;

class MediaManagementFlowTest extends TestCase
{
    use RefreshDatabase;

    protected $user;

    protected function setUp(): void
    {
        parent::setUp();
        $this->user = User::factory()->create();
        $this->actingAs($this->user);
        Storage::fake('public');
    }

    public function test_full_media_management_flow()
    {
        // 1. Create a new Empresa
        $empresa1 = Empresa::factory()->create();
        $this->assertDatabaseHas('empresas', ['id' => $empresa1->id]);

        // 2. Create a new Midia and associate it with the Empresa
        // $file = UploadedFile::fake()->image('midia.jpg');
        $midia = Midia::factory()->create([
            'empresa_id' => $empresa1->id,
            // 'path' => $file->store('midias', 'public'),
        ]);
        $this->assertDatabaseHas('midias', ['id' => $midia->id, 'empresa_id' => $empresa1->id]);

        // 3. Verify the relationship
        $this->assertEquals($empresa1->id, $midia->empresa->id);
        $this->assertTrue($empresa1->midias->contains($midia));

        // 4. Update the Midia to associate it with a different Empresa
        $empresa2 = Empresa::factory()->create();
        $this->put(route('midias.update', $midia), [
            'title' => 'Updated Title',
            'type' => 'image',
            'empresa_id' => $empresa2->id,
        ]);
        $this->assertDatabaseHas('midias', ['id' => $midia->id, 'empresa_id' => $empresa2->id]);
        $this->assertFalse($empresa1->refresh()->midias->contains($midia));
        $this->assertTrue($empresa2->refresh()->midias->contains($midia));

        // 5. Delete the Midia
        $this->delete(route('midias.destroy', $midia));
        $this->assertSoftDeleted('midias', ['id' => $midia->id]);

        // 6. Delete the Empresa
        $this->delete(route('empresas.destroy', $empresa1));
        $this->assertDatabaseMissing('empresas', ['id' => $empresa1->id]);
    }
}
