<?php

/**
 * Teste Completo de TODAS as Rotas do Sistema
 * Verifica existência, métodos HTTP e middlewares
 */

require __DIR__.'/vendor/autoload.php';

$app = require_once __DIR__.'/bootstrap/app.php';
$app->make(\Illuminate\Contracts\Console\Kernel::class)->bootstrap();

use Illuminate\Support\Facades\Route;

// Cores para output
class Color {
    public static function green($text) { return "\033[32m{$text}\033[0m"; }
    public static function red($text) { return "\033[31m{$text}\033[0m"; }
    public static function yellow($text) { return "\033[33m{$text}\033[0m"; }
    public static function blue($text) { return "\033[36m{$text}\033[0m"; }
    public static function bold($text) { return "\033[1m{$text}\033[0m"; }
}

$passed = 0;
$failed = 0;
$routes = Route::getRoutes();

echo Color::bold("\n╔═══════════════════════════════════════════════════════════════╗\n");
echo Color::bold("║        TESTE COMPLETO DE TODAS AS ROTAS DO SISTEMA           ║\n");
echo Color::bold("╚═══════════════════════════════════════════════════════════════╝\n");

// ═══════════════════════════════════════════════════════════════
echo "\n" . Color::yellow("═══ 1. ROTAS PÚBLICAS (SEM AUTENTICAÇÃO) ═══") . "\n\n";

$publicRoutes = [
    ['GET', '/', 'welcome'],
    ['GET', 'locale/{locale}', 'locale.setting'],
];

foreach ($publicRoutes as [$method, $uri, $name]) {
    $found = false;
    foreach ($routes as $route) {
        if ($route->uri() === $uri && in_array($method, $route->methods())) {
            echo Color::green("✓") . " {$method} /{$uri}";
            if ($name) {
                $routeName = $route->getName();
                if ($routeName === $name) {
                    echo " → " . Color::blue("name: {$name}");
                }
            }
            echo "\n";
            $found = true;
            $passed++;
            break;
        }
    }
    
    if (!$found) {
        echo Color::red("✗") . " {$method} /{$uri} - " . Color::red("NÃO ENCONTRADA") . "\n";
        $failed++;
    }
}

// ═══════════════════════════════════════════════════════════════
echo "\n" . Color::yellow("═══ 2. ROTAS DE REGISTRO (GUEST MIDDLEWARE) ═══") . "\n\n";

$registerRoutes = [
    ['GET', 'register', 'register'],
    ['POST', 'register', 'register.store'],
    ['POST', 'register/validate-code', 'register.validate-code'],
];

foreach ($registerRoutes as [$method, $uri, $name]) {
    $found = false;
    foreach ($routes as $route) {
        if ($route->uri() === $uri && in_array($method, $route->methods())) {
            echo Color::green("✓") . " {$method} /{$uri}";
            
            // Verificar middleware
            $middleware = $route->gatherMiddleware();
            if (in_array('guest', $middleware) || in_array('web', $middleware)) {
                echo " → " . Color::blue("middleware: guest");
            }
            
            // Verificar nome
            $routeName = $route->getName();
            if ($routeName === $name) {
                echo " → " . Color::blue("name: {$name}");
            }
            
            echo "\n";
            $found = true;
            $passed++;
            break;
        }
    }
    
    if (!$found) {
        echo Color::red("✗") . " {$method} /{$uri} - " . Color::red("NÃO ENCONTRADA") . "\n";
        $failed++;
    }
}

// ═══════════════════════════════════════════════════════════════
echo "\n" . Color::yellow("═══ 3. ROTAS DE AUTENTICAÇÃO (AUTH MIDDLEWARE) ═══") . "\n\n";

$authRoutes = [
    ['GET', 'dashboard', 'dashboard'],
];

foreach ($authRoutes as [$method, $uri, $name]) {
    $found = false;
    foreach ($routes as $route) {
        if ($route->uri() === $uri && in_array($method, $route->methods())) {
            echo Color::green("✓") . " {$method} /{$uri}";
            
            // Verificar middleware
            $middleware = $route->gatherMiddleware();
            $hasAuth = false;
            foreach ($middleware as $m) {
                if (str_contains($m, 'auth')) {
                    $hasAuth = true;
                    break;
                }
            }
            if ($hasAuth) {
                echo " → " . Color::blue("middleware: auth");
            }
            
            // Verificar nome
            $routeName = $route->getName();
            if ($routeName === $name) {
                echo " → " . Color::blue("name: {$name}");
            }
            
            echo "\n";
            $found = true;
            $passed++;
            break;
        }
    }
    
    if (!$found) {
        echo Color::red("✗") . " {$method} /{$uri} - " . Color::red("NÃO ENCONTRADA") . "\n";
        $failed++;
    }
}

// ═══════════════════════════════════════════════════════════════
echo "\n" . Color::yellow("═══ 4. ROTAS DE PERFIL (AUTH MIDDLEWARE) ═══") . "\n\n";

$profileRoutes = [
    ['GET', 'profile', 'profile.edit'],
    ['PATCH', 'profile', 'profile.update'],
    ['DELETE', 'profile', 'profile.destroy'],
];

foreach ($profileRoutes as [$method, $uri, $name]) {
    $found = false;
    foreach ($routes as $route) {
        if ($route->uri() === $uri && in_array($method, $route->methods())) {
            echo Color::green("✓") . " {$method} /{$uri} → " . Color::blue("name: {$name}") . "\n";
            $found = true;
            $passed++;
            break;
        }
    }
    
    if (!$found) {
        echo Color::red("✗") . " {$method} /{$uri} - " . Color::red("NÃO ENCONTRADA") . "\n";
        $failed++;
    }
}

// ═══════════════════════════════════════════════════════════════
echo "\n" . Color::yellow("═══ 5. ROTAS RESOURCE: USERS ═══") . "\n\n";

$userRoutes = [
    ['GET', 'users', 'users.index'],
    ['GET', 'users/create', 'users.create'],
    ['POST', 'users', 'users.store'],
    ['GET', 'users/{user}', 'users.show'],
    ['GET', 'users/{user}/edit', 'users.edit'],
    ['PUT', 'users/{user}', 'users.update'],
    ['PATCH', 'users/{user}', 'users.update'],
    ['DELETE', 'users/{user}', 'users.destroy'],
];

foreach ($userRoutes as [$method, $uri, $name]) {
    $found = false;
    foreach ($routes as $route) {
        if ($route->uri() === $uri && in_array($method, $route->methods())) {
            echo Color::green("✓") . " {$method} /{$uri} → " . Color::blue($name) . "\n";
            $found = true;
            $passed++;
            break;
        }
    }
    
    if (!$found) {
        echo Color::red("✗") . " {$method} /{$uri} - " . Color::red("NÃO ENCONTRADA") . "\n";
        $failed++;
    }
}

// ═══════════════════════════════════════════════════════════════
echo "\n" . Color::yellow("═══ 6. ROTAS RESOURCE: PERMISSIONS ═══") . "\n\n";

$permissionRoutes = [
    ['GET', 'permissions', 'permissions.index'],
    ['GET', 'permissions/create', 'permissions.create'],
    ['POST', 'permissions', 'permissions.store'],
    ['GET', 'permissions/{permission}', 'permissions.show'],
    ['GET', 'permissions/{permission}/edit', 'permissions.edit'],
    ['PUT', 'permissions/{permission}', 'permissions.update'],
    ['PATCH', 'permissions/{permission}', 'permissions.update'],
    ['DELETE', 'permissions/{permission}', 'permissions.destroy'],
];

foreach ($permissionRoutes as [$method, $uri, $name]) {
    $found = false;
    foreach ($routes as $route) {
        if ($route->uri() === $uri && in_array($method, $route->methods())) {
            echo Color::green("✓") . " {$method} /{$uri} → " . Color::blue($name) . "\n";
            $found = true;
            $passed++;
            break;
        }
    }
    
    if (!$found) {
        echo Color::red("✗") . " {$method} /{$uri} - " . Color::red("NÃO ENCONTRADA") . "\n";
        $failed++;
    }
}

// ═══════════════════════════════════════════════════════════════
echo "\n" . Color::yellow("═══ 7. ROTAS RESOURCE: GROUPS ═══") . "\n\n";

$groupRoutes = [
    ['GET', 'groups', 'groups.index'],
    ['GET', 'groups/create', 'groups.create'],
    ['POST', 'groups', 'groups.store'],
    ['GET', 'groups/{group}', 'groups.show'],
    ['GET', 'groups/{group}/edit', 'groups.edit'],
    ['PUT', 'groups/{group}', 'groups.update'],
    ['PATCH', 'groups/{group}', 'groups.update'],
    ['DELETE', 'groups/{group}', 'groups.destroy'],
    ['GET', 'groups/{group}/permissions', 'groups.permissions.edit'],
    ['POST', 'groups/{group}/permissions', 'groups.permissions.update'],
];

foreach ($groupRoutes as [$method, $uri, $name]) {
    $found = false;
    foreach ($routes as $route) {
        if ($route->uri() === $uri && in_array($method, $route->methods())) {
            echo Color::green("✓") . " {$method} /{$uri} → " . Color::blue($name) . "\n";
            $found = true;
            $passed++;
            break;
        }
    }
    
    if (!$found) {
        echo Color::red("✗") . " {$method} /{$uri} - " . Color::red("NÃO ENCONTRADA") . "\n";
        $failed++;
    }
}

// ═══════════════════════════════════════════════════════════════
echo "\n" . Color::yellow("═══ 8. ROTAS RESOURCE: EMPRESAS ═══") . "\n\n";

$empresaRoutes = [
    ['GET', 'empresas/trash', 'empresas.trash'],
    ['PATCH', 'empresas/{id}/restore', 'empresas.restore'],
    ['PATCH', 'empresas/{empresa}/status', 'empresas.toggleStatus'],
    ['GET', 'empresas', 'empresas.index'],
    ['GET', 'empresas/create', 'empresas.create'],
    ['POST', 'empresas', 'empresas.store'],
    ['GET', 'empresas/{empresa}', 'empresas.show'],
    ['GET', 'empresas/{empresa}/edit', 'empresas.edit'],
    ['PUT', 'empresas/{empresa}', 'empresas.update'],
    ['PATCH', 'empresas/{empresa}', 'empresas.update'],
    ['DELETE', 'empresas/{empresa}', 'empresas.destroy'],
];

foreach ($empresaRoutes as [$method, $uri, $name]) {
    $found = false;
    foreach ($routes as $route) {
        if ($route->uri() === $uri && in_array($method, $route->methods())) {
            echo Color::green("✓") . " {$method} /{$uri} → " . Color::blue($name) . "\n";
            $found = true;
            $passed++;
            break;
        }
    }
    
    if (!$found) {
        echo Color::red("✗") . " {$method} /{$uri} - " . Color::red("NÃO ENCONTRADA") . "\n";
        $failed++;
    }
}

// ═══════════════════════════════════════════════════════════════
echo "\n" . Color::yellow("═══ 9. ROTAS RESOURCE: MIDIAS ═══") . "\n\n";

$midiaRoutes = [
    ['GET', 'midias/trash', 'midias.trash'],
    ['PATCH', 'midias/{midia}/restore', 'midias.restore'],
    ['PATCH', 'midias/{midia}/status', 'midias.toggleStatus'],
    ['GET', 'midias', 'midias.index'],
    ['GET', 'midias/create', 'midias.create'],
    ['POST', 'midias', 'midias.store'],
    ['GET', 'midias/{midia}', 'midias.show'],
    ['GET', 'midias/{midia}/edit', 'midias.edit'],
    ['PUT', 'midias/{midia}', 'midias.update'],
    ['PATCH', 'midias/{midia}', 'midias.update'],
    ['DELETE', 'midias/{midia}', 'midias.destroy'],
];

foreach ($midiaRoutes as [$method, $uri, $name]) {
    $found = false;
    foreach ($routes as $route) {
        if ($route->uri() === $uri && in_array($method, $route->methods())) {
            echo Color::green("✓") . " {$method} /{$uri} → " . Color::blue($name) . "\n";
            $found = true;
            $passed++;
            break;
        }
    }
    
    if (!$found) {
        echo Color::red("✗") . " {$method} /{$uri} - " . Color::red("NÃO ENCONTRADA") . "\n";
        $failed++;
    }
}

// ═══════════════════════════════════════════════════════════════
echo "\n" . Color::yellow("═══ 10. ROTAS RESOURCE: HOTSPOTS ═══") . "\n\n";

$hotspotRoutes = [
    ['GET', 'hotspots/trash', 'hotspots.trash'],
    ['PATCH', 'hotspots/{id}/restore', 'hotspots.restore'],
    ['PATCH', 'hotspots/{hotspot}/status', 'hotspots.toggleStatus'],
    ['GET', 'hotspots', 'hotspots.index'],
    ['GET', 'hotspots/create', 'hotspots.create'],
    ['POST', 'hotspots', 'hotspots.store'],
    ['GET', 'hotspots/{hotspot}', 'hotspots.show'],
    ['GET', 'hotspots/{hotspot}/edit', 'hotspots.edit'],
    ['PUT', 'hotspots/{hotspot}', 'hotspots.update'],
    ['PATCH', 'hotspots/{hotspot}', 'hotspots.update'],
    ['DELETE', 'hotspots/{hotspot}', 'hotspots.destroy'],
];

foreach ($hotspotRoutes as [$method, $uri, $name]) {
    $found = false;
    foreach ($routes as $route) {
        if ($route->uri() === $uri && in_array($method, $route->methods())) {
            echo Color::green("✓") . " {$method} /{$uri} → " . Color::blue($name) . "\n";
            $found = true;
            $passed++;
            break;
        }
    }
    
    if (!$found) {
        echo Color::red("✗") . " {$method} /{$uri} - " . Color::red("NÃO ENCONTRADA") . "\n";
        $failed++;
    }
}

// ═══════════════════════════════════════════════════════════════
echo "\n" . Color::yellow("═══ 11. ESTATÍSTICAS GERAIS DAS ROTAS ═══") . "\n\n";

$totalRoutes = count($routes);
$getRoutes = 0;
$postRoutes = 0;
$putRoutes = 0;
$patchRoutes = 0;
$deleteRoutes = 0;
$namedRoutes = 0;
$authRoutes = 0;
$guestRoutes = 0;

foreach ($routes as $route) {
    $methods = $route->methods();
    
    if (in_array('GET', $methods)) $getRoutes++;
    if (in_array('POST', $methods)) $postRoutes++;
    if (in_array('PUT', $methods)) $putRoutes++;
    if (in_array('PATCH', $methods)) $patchRoutes++;
    if (in_array('DELETE', $methods)) $deleteRoutes++;
    
    if ($route->getName()) $namedRoutes++;
    
    $middleware = $route->gatherMiddleware();
    foreach ($middleware as $m) {
        if (str_contains($m, 'auth')) {
            $authRoutes++;
            break;
        }
    }
    
    if (in_array('guest', $middleware)) $guestRoutes++;
}

echo "Total de rotas no sistema: " . Color::bold($totalRoutes) . "\n";
echo "GET:    " . Color::green($getRoutes) . "\n";
echo "POST:   " . Color::yellow($postRoutes) . "\n";
echo "PUT:    " . Color::blue($putRoutes) . "\n";
echo "PATCH:  " . Color::blue($patchRoutes) . "\n";
echo "DELETE: " . Color::red($deleteRoutes) . "\n";
echo "\n";
echo "Rotas com nome:       " . Color::bold($namedRoutes) . "\n";
echo "Rotas com auth:       " . Color::bold($authRoutes) . "\n";
echo "Rotas com guest:      " . Color::bold($guestRoutes) . "\n";

// ═══════════════════════════════════════════════════════════════
echo "\n" . Color::bold("╔═══════════════════════════════════════════════════════════════╗\n");
echo Color::bold("║                    RESUMO DOS TESTES                          ║\n");
echo Color::bold("╚═══════════════════════════════════════════════════════════════╝\n\n");

echo "Total de rotas testadas: " . Color::bold($passed + $failed) . "\n";
echo Color::green("✓ Rotas encontradas: {$passed}") . "\n";

if ($failed > 0) {
    echo Color::red("✗ Rotas não encontradas: {$failed}") . "\n";
}

$percentage = ($passed + $failed) > 0 ? round(($passed / ($passed + $failed)) * 100, 2) : 0;

echo "\n" . Color::bold("Taxa de sucesso: ");
if ($percentage === 100.0) {
    echo Color::green("{$percentage}%") . " ✓\n";
} elseif ($percentage >= 80) {
    echo Color::yellow("{$percentage}%") . " ⚠️\n";
} else {
    echo Color::red("{$percentage}%") . " ✗\n";
}

// ═══════════════════════════════════════════════════════════════
echo "\n" . Color::yellow("═══ 12. LISTAR TODAS AS ROTAS DO SISTEMA ═══") . "\n\n";

echo Color::blue("Executando: php artisan route:list\n\n");

echo Color::yellow("(Para ver a lista completa, execute: docker exec freefi-admin-app php artisan route:list)\n");

echo "\n";

exit($failed > 0 ? 1 : 0);
