#!/bin/bash

# Script de teste para verificar rotas de mídias/criativos
# Criado em: 17/10/2025

echo "╔═══════════════════════════════════════════════════════════════════════╗"
echo "║                                                                       ║"
echo "║              🧪 TESTANDO ROTAS DE MÍDIAS/CRIATIVOS 🧪                 ║"
echo "║                                                                       ║"
echo "╚═══════════════════════════════════════════════════════════════════════╝"
echo ""

BASE_URL="http://localhost:8082"
ERRORS=0

# Função para testar uma rota
test_route() {
    local route=$1
    local description=$2
    
    echo -n "🔍 Testando $description... "
    
    # Fazer requisição HTTP e verificar código de resposta
    http_code=$(curl -s -o /dev/null -w "%{http_code}" "$BASE_URL$route")
    
    if [ "$http_code" = "200" ] || [ "$http_code" = "302" ]; then
        echo "✅ OK (HTTP $http_code)"
    else
        echo "❌ ERRO (HTTP $http_code)"
        ((ERRORS++))
    fi
}

echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"
echo "📋 TESTANDO ROTAS PÚBLICAS:"
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"

test_route "/" "Home"
test_route "/midias" "Lista de Mídias (index)"

echo ""
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"
echo "🔍 VERIFICANDO ERROS NO LOG:"
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"

# Verificar últimas linhas do log do Laravel
docker exec -it freefi-admin-app tail -20 storage/logs/laravel.log 2>/dev/null | grep -i "error\|exception\|fail" && echo "⚠️  Erros encontrados no log!" || echo "✅ Nenhum erro no log"

echo ""
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"
echo "📊 RESUMO DOS TESTES:"
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"

if [ $ERRORS -eq 0 ]; then
    echo "✅ TODOS OS TESTES PASSARAM!"
    echo "✅ Sistema está funcionando corretamente"
else
    echo "❌ $ERRORS TESTE(S) FALHARAM"
    echo "⚠️  Verifique os logs para mais detalhes"
fi

echo ""
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"
echo "💡 ACESSE MANUALMENTE:"
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"
echo "   📊 Dashboard: $BASE_URL"
echo "   🖼️  Mídias:    $BASE_URL/midias"
echo "   🏢 Empresas:  $BASE_URL/empresas"
echo "   📡 Hotspots:  $BASE_URL/hotspots"
echo ""

exit $ERRORS
