# 🔧 CORREÇÃO E CONFIGURAÇÃO DA PIPELINE GITHUB ACTIONS

## 📊 STATUS ATUAL

**Repositório:** `github.com:freefi-com-br/freefiadm.git`
**Pipeline:** ✅ Já configurada (`.github/workflows/deploy.yml`)
**Docker Compose:** ✅ Porta 8082 já configurada
**Status:** 🔴 Falhando - Precisa configurar secrets

---

## 🔍 ANÁLISE DA PIPELINE ATUAL

### Workflow Deploy (`deploy.yml`)

**Estrutura:** 3 Jobs sequenciais
1. ✅ **laravel-tests** - Roda testes automaticamente
2. ✅ **build-and-push** - Build da imagem Docker e push para GitHub Container Registry
3. ⚠️ **deploy** - Deploy no servidor via SSH (PRECISA DOS SECRETS)

### Problemas Identificados

#### 1. **Secrets Ausentes** 🔴 CRÍTICO
A pipeline precisa dos seguintes secrets configurados no GitHub:

```
SSH_HOST          - IP ou hostname do servidor Linode
SSH_USERNAME      - Usuário SSH do servidor (ex: deploy, cloud, root)
SSH_PRIVATE_KEY   - Chave privada SSH para autenticação
SSH_PORT          - Porta SSH (padrão: 22)
PROJECT_PATH      - Caminho do projeto no servidor (ex: /var/www/freefi)
GH_PAT            - GitHub Personal Access Token (para pull da imagem)
```

#### 2. **Docker Compose no Servidor** ⚠️ MÉDIO
O deploy assume que o servidor já tem:
- Docker instalado
- Docker Compose instalado
- Projeto clonado em `$PROJECT_PATH`
- Arquivo `.env` configurado no servidor

#### 3. **Migrations com -T flag** ⚠️ BAIXO
Linha 102: `docker-compose exec -T app php artisan migrate --force`
- Flag `-T` é para não alocar TTY (correto para CI/CD)
- `--force` roda migrations sem confirmação (correto para produção)

---

## ✅ CONFIGURAÇÃO - PASSO A PASSO

### PASSO 1: Configurar Secrets no GitHub

1. **Acesse o repositório no GitHub:**
   ```
   https://github.com/freefi-com-br/freefiadm
   ```

2. **Vá em Settings > Secrets and variables > Actions**

3. **Clique em "New repository secret" e adicione cada um:**

#### Secret 1: SSH_HOST
```
Name: SSH_HOST
Value: [IP DO SERVIDOR LINODE]

Exemplo:
192.168.1.100
ou
freefi.seudominio.com.br
```

#### Secret 2: SSH_USERNAME
```
Name: SSH_USERNAME
Value: [USUÁRIO SSH]

Exemplos comuns:
- cloud
- deploy
- root (não recomendado para produção)
```

#### Secret 3: SSH_PRIVATE_KEY
```
Name: SSH_PRIVATE_KEY
Value: [CONTEÚDO DA CHAVE PRIVADA SSH]

Como obter:
1. No seu computador local (que tem acesso ao servidor):
   cat ~/.ssh/id_rsa

2. Copiar TODO o conteúdo, incluindo:
   -----BEGIN OPENSSH PRIVATE KEY-----
   [conteúdo]
   -----END OPENSSH PRIVATE KEY-----

3. Colar no campo Value
```

**Se você não tem uma chave SSH configurada:**
```bash
# No seu computador local
ssh-keygen -t rsa -b 4096 -C "deploy@freefi"

# Pressione Enter para aceitar o local padrão (~/.ssh/id_rsa)
# Deixe a senha em branco (pressione Enter duas vezes)

# Copiar chave pública para o servidor
ssh-copy-id usuario@IP_DO_SERVIDOR

# Ou manualmente:
cat ~/.ssh/id_rsa.pub
# Copiar o conteúdo e adicionar em ~/.ssh/authorized_keys no servidor

# Depois copiar a chave privada para o GitHub Secret:
cat ~/.ssh/id_rsa
```

#### Secret 4: SSH_PORT
```
Name: SSH_PORT
Value: 22

(Se o servidor usar porta diferente, colocar aqui)
```

#### Secret 5: PROJECT_PATH
```
Name: PROJECT_PATH
Value: [CAMINHO DO PROJETO NO SERVIDOR]

Sugestões:
/var/www/freefi
ou
/home/cloud/freefi
ou
/var/www/html/laravel/admin/freefi_admin

⚠️ IMPORTANTE: Este caminho deve existir no servidor!
```

#### Secret 6: GH_PAT (GitHub Personal Access Token)
```
Name: GH_PAT
Value: [PERSONAL ACCESS TOKEN]

Como criar:
1. GitHub > Settings (seu perfil, não do repositório)
2. Developer settings > Personal access tokens > Tokens (classic)
3. Generate new token (classic)
4. Nome: "FreeFi Deploy"
5. Scopes necessários:
   ✅ repo (all)
   ✅ write:packages
   ✅ read:packages
6. Generate token
7. COPIAR O TOKEN (só aparece uma vez!)
8. Colar no GitHub Secret
```

---

### PASSO 2: Preparar o Servidor

#### 2.1. Instalar Docker e Docker Compose

```bash
# SSH no servidor
ssh usuario@IP_DO_SERVIDOR

# Atualizar sistema
sudo apt update && sudo apt upgrade -y

# Instalar Docker
curl -fsSL https://get.docker.com -o get-docker.sh
sudo sh get-docker.sh

# Adicionar usuário ao grupo docker
sudo usermod -aG docker $USER

# Instalar Docker Compose V2
sudo apt install docker-compose-plugin -y

# Verificar instalações
docker --version
docker compose version

# Logout e login novamente para aplicar grupo
exit
ssh usuario@IP_DO_SERVIDOR
```

#### 2.2. Criar Estrutura de Diretórios

```bash
# Escolher um dos caminhos (deve ser o mesmo do SECRET PROJECT_PATH)

# Opção 1: /var/www/freefi (recomendado)
sudo mkdir -p /var/www/freefi
sudo chown -R $USER:$USER /var/www/freefi
cd /var/www/freefi

# Opção 2: Manter na estrutura atual
cd /var/www/html/laravel/admin/freefi_admin
```

#### 2.3. Clonar Repositório

```bash
# Via SSH (requer chave SSH configurada no GitHub)
git clone git@github.com:freefi-com-br/freefiadm.git .

# Ou via HTTPS
git clone https://github.com/freefi-com-br/freefiadm.git .
```

#### 2.4. Configurar .env no Servidor

```bash
# Copiar .env.example
cp .env.example .env

# Editar .env
nano .env
```

**Configurações OBRIGATÓRIAS para produção:**
```env
APP_NAME=Freefi
APP_ENV=production
APP_DEBUG=false                    # ← CRÍTICO: false em produção!
APP_URL=http://SEU_DOMINIO:8082    # ou http://IP_SERVIDOR:8082

DB_CONNECTION=mysql
DB_HOST=db                         # ← Nome do service no docker-compose
DB_PORT=3306
DB_DATABASE=adm_freefi
DB_USERNAME=freefi_user           # ← Trocar!
DB_PASSWORD=SENHA_SEGURA_AQUI     # ← Trocar!
DB_ROOT_PASSWORD=ROOT_SENHA_AQUI  # ← Trocar!

SESSION_DRIVER=database
QUEUE_CONNECTION=database
CACHE_DRIVER=file

MAIL_MAILER=smtp
MAIL_HOST=email-ssl.com.br
MAIL_PORT=465
MAIL_USERNAME=SEU_EMAIL           # ← Trocar!
MAIL_PASSWORD=SUA_SENHA           # ← Trocar!
MAIL_ENCRYPTION=ssl
MAIL_FROM_ADDRESS=comercial@seudominio.com.br
MAIL_FROM_NAME="${APP_NAME}"
```

```bash
# Gerar APP_KEY
docker compose run --rm app php artisan key:generate

# Verificar
cat .env | grep APP_KEY
```

#### 2.5. Ajustar Permissões

```bash
# Criar diretórios necessários
mkdir -p storage/framework/{sessions,views,cache}
mkdir -p storage/logs
mkdir -p bootstrap/cache

# Permissões corretas
sudo chown -R $USER:www-data storage bootstrap/cache
sudo chmod -R 775 storage bootstrap/cache
```

#### 2.6. Build Inicial (Teste Local)

```bash
# Build das imagens
docker compose build

# Subir containers
docker compose up -d

# Verificar status
docker compose ps

# Instalar dependências
docker compose exec app composer install --no-dev --optimize-autoloader

# Rodar migrations
docker compose exec app php artisan migrate --force

# Criar link do storage
docker compose exec app php artisan storage:link

# Testar acesso
curl http://localhost:8082
# ou
curl http://IP_SERVIDOR:8082
```

Se funcionar localmente, o deploy automatizado também funcionará! ✅

---

### PASSO 3: Testar o Deploy Automatizado

#### 3.1. Fazer um Commit e Push

```bash
# No seu ambiente local (não no servidor)
cd /var/www/html/laravel/admin/freefi_admin

# Fazer uma pequena mudança para testar
echo "# Deploy teste $(date)" >> README.md

# Commitar e pushar para main
git add README.md
git commit -m "test: Trigger deploy pipeline"
git push origin main
```

#### 3.2. Acompanhar a Pipeline

1. **Acesse o GitHub Actions:**
   ```
   https://github.com/freefi-com-br/freefiadm/actions
   ```

2. **Clique no workflow que acabou de iniciar**

3. **Acompanhe cada job:**
   - ✅ Job 1: laravel-tests (5-10 min)
   - ✅ Job 2: build-and-push (3-5 min)
   - ✅ Job 3: deploy (2-3 min)

4. **Se tudo der certo, você verá:**
   ```
   ✓ Logging in to GitHub Container Registry...
   ✓ Pulling latest image...
   ✓ Restarting services...
   ✓ Running migrations...
   ✓ Cleaning up old images...
   ✓ Deployment finished successfully.
   ```

#### 3.3. Verificar Deploy no Servidor

```bash
# SSH no servidor
ssh usuario@IP_DO_SERVIDOR

# Ir para o projeto
cd /var/www/freefi  # ou o caminho configurado

# Ver logs do deploy
docker compose logs --tail=50

# Verificar containers rodando
docker compose ps

# Testar aplicação
curl http://localhost:8082
```

---

## 🐛 TROUBLESHOOTING - Erros Comuns

### Erro 1: "Permission denied (publickey)"
**Causa:** Chave SSH não configurada corretamente

**Solução:**
```bash
# No servidor, verificar authorized_keys
cat ~/.ssh/authorized_keys

# Deve conter a chave pública correspondente à privada no GitHub Secret
# Para adicionar:
echo "SUA_CHAVE_PUBLICA" >> ~/.ssh/authorized_keys
chmod 600 ~/.ssh/authorized_keys
```

### Erro 2: "docker-compose: command not found"
**Causa:** Docker Compose não instalado ou versão antiga

**Solução:**
```bash
# Instalar Docker Compose V2
sudo apt install docker-compose-plugin -y

# Verificar
docker compose version

# Se ainda não funcionar, a pipeline pode estar usando comando antigo
# Editar .github/workflows/deploy.yml e trocar:
# docker-compose → docker compose
```

### Erro 3: "Cannot connect to the Docker daemon"
**Causa:** Usuário não tem permissão para usar Docker

**Solução:**
```bash
# Adicionar usuário ao grupo docker
sudo usermod -aG docker $USER

# Logout e login
exit
ssh usuario@IP_DO_SERVIDOR

# Testar
docker ps
```

### Erro 4: "No such file or directory: .env"
**Causa:** Arquivo .env não existe no servidor

**Solução:**
```bash
# No servidor
cd /var/www/freefi
cp .env.example .env
nano .env
# Configurar valores de produção
```

### Erro 5: "Error response from daemon: pull access denied"
**Causa:** GitHub PAT inválido ou sem permissões

**Solução:**
1. Verificar se GH_PAT tem permissão `read:packages`
2. Gerar novo token se necessário
3. Atualizar secret no GitHub

### Erro 6: "Port 8082 is already in use"
**Causa:** Outra aplicação usando porta 8082

**Solução:**
```bash
# Ver o que está usando a porta
sudo lsof -i :8082
# ou
sudo netstat -tulpn | grep 8082

# Parar o serviço conflitante ou mudar porta no docker-compose.yml
```

### Erro 7: "Database connection failed"
**Causa:** Container db não está rodando ou credenciais erradas

**Solução:**
```bash
# Verificar status do container db
docker compose ps db

# Ver logs do banco
docker compose logs db

# Verificar se .env tem as credenciais corretas
cat .env | grep DB_

# Reiniciar containers
docker compose restart
```

---

## 📋 CHECKLIST PRÉ-DEPLOY

Antes de fazer push para main, verificar:

### No GitHub:
- [ ] Secret SSH_HOST configurado
- [ ] Secret SSH_USERNAME configurado
- [ ] Secret SSH_PRIVATE_KEY configurado
- [ ] Secret SSH_PORT configurado (22)
- [ ] Secret PROJECT_PATH configurado
- [ ] Secret GH_PAT configurado

### No Servidor:
- [ ] Docker instalado e funcionando
- [ ] Docker Compose V2 instalado
- [ ] Projeto clonado no PROJECT_PATH
- [ ] Arquivo .env configurado
- [ ] APP_KEY gerada
- [ ] Permissões corretas (storage, cache)
- [ ] Porta 8082 livre (não em uso)
- [ ] Firewall permite porta 8082 (se houver)

### No Repositório Local:
- [ ] Último commit em main
- [ ] Sem mudanças uncommited importantes
- [ ] .env não está commitado

---

## 🚀 DEPLOY MANUAL (Fallback)

Se a pipeline falhar, você pode fazer deploy manual:

```bash
# SSH no servidor
ssh usuario@IP_DO_SERVIDOR
cd /var/www/freefi

# Pull do código
git pull origin main

# Login no GitHub Container Registry
echo "SEU_GH_PAT" | docker login ghcr.io -u SEU_USUARIO --password-stdin

# Pull da imagem (se usar imagem do registry)
docker compose pull

# Ou rebuild local
docker compose build --no-cache

# Parar containers
docker compose down

# Subir containers
docker compose up -d

# Rodar migrations
docker compose exec app php artisan migrate --force

# Limpar caches
docker compose exec app php artisan cache:clear
docker compose exec app php artisan config:clear
docker compose exec app php artisan view:clear

# Verificar status
docker compose ps
```

---

## 📊 MONITORAMENTO PÓS-DEPLOY

### Logs em Tempo Real
```bash
# Ver logs de todos os containers
docker compose logs -f

# Ver logs de um container específico
docker compose logs -f app
docker compose logs -f nginx
docker compose logs -f db

# Ver últimas 100 linhas
docker compose logs --tail=100
```

### Status dos Containers
```bash
# Ver containers rodando
docker compose ps

# Ver uso de recursos
docker stats

# Ou instalar ctop
sudo wget https://github.com/bcicen/ctop/releases/download/v0.7.7/ctop-0.7.7-linux-amd64 -O /usr/local/bin/ctop
sudo chmod +x /usr/local/bin/ctop
ctop
```

### Testar Aplicação
```bash
# No servidor
curl http://localhost:8082

# De outro computador
curl http://IP_DO_SERVIDOR:8082

# Ou abrir no navegador:
http://IP_DO_SERVIDOR:8082
```

---

## 🔄 FLUXO DE DEPLOY COMPLETO

```
┌─────────────────────────────────────────────────────────────────┐
│  1. DESENVOLVEDOR: Push para main                               │
│     git push origin main                                        │
└─────────────────────────────┬───────────────────────────────────┘
                              │
                              ▼
┌─────────────────────────────────────────────────────────────────┐
│  2. GITHUB ACTIONS: Inicia pipeline automaticamente             │
│                                                                  │
│     JOB 1: laravel-tests (5-10 min)                            │
│     ├─ Checkout código                                          │
│     ├─ Setup PHP 8.2                                            │
│     ├─ Install composer dependencies                            │
│     ├─ Install NPM dependencies                                 │
│     ├─ Build assets (Vite)                                      │
│     ├─ Run migrations                                           │
│     └─ Run tests (Pest)                                         │
│                                                                  │
│     ✓ Se testes passarem, continua...                           │
└─────────────────────────────┬───────────────────────────────────┘
                              │
                              ▼
┌─────────────────────────────────────────────────────────────────┐
│  3. GITHUB ACTIONS: Build Docker Image                          │
│                                                                  │
│     JOB 2: build-and-push (3-5 min)                            │
│     ├─ Checkout código                                          │
│     ├─ Login ghcr.io                                            │
│     ├─ Build imagem Docker                                      │
│     └─ Push para GitHub Container Registry                      │
│                                                                  │
│     ✓ Imagem disponível em:                                     │
│       ghcr.io/freefi-com-br/freefiadm:main                     │
└─────────────────────────────┬───────────────────────────────────┘
                              │
                              ▼
┌─────────────────────────────────────────────────────────────────┐
│  4. GITHUB ACTIONS: Deploy no Servidor                          │
│                                                                  │
│     JOB 3: deploy (2-3 min)                                     │
│     ├─ SSH no servidor Linode                                   │
│     ├─ cd /var/www/freefi                                       │
│     ├─ Login ghcr.io                                            │
│     ├─ docker compose pull                                      │
│     ├─ docker compose up -d --remove-orphans                    │
│     ├─ docker compose exec app php artisan migrate --force      │
│     └─ docker image prune -af                                   │
│                                                                  │
│     ✓ Deploy concluído!                                         │
└─────────────────────────────┬───────────────────────────────────┘
                              │
                              ▼
┌─────────────────────────────────────────────────────────────────┐
│  5. SERVIDOR LINODE: Aplicação Rodando                          │
│                                                                  │
│     🌐 http://IP_DO_SERVIDOR:8082                               │
│                                                                  │
│     Containers ativos:                                          │
│     ├─ freefi_app (PHP 8.3-FPM)                                │
│     ├─ freefi_db (MySQL 8.0)                                   │
│     ├─ freefi_nginx (Nginx Alpine) → porta 8082               │
│     └─ freefi_phpmyadmin → porta 8081                          │
└─────────────────────────────────────────────────────────────────┘
```

**Tempo total:** ~10-20 minutos por deploy

---

## 📝 PRÓXIMOS PASSOS APÓS DEPLOY

1. **Verificar Funcionamento:**
   - [ ] Página inicial carrega
   - [ ] Login funciona
   - [ ] Dashboard acessível
   - [ ] Upload de arquivos funciona
   - [ ] Emails sendo enviados (ou queueados)

2. **Configurar Domínio (Opcional):**
   - Configurar DNS apontando para IP do servidor
   - Adicionar proxy reverso com SSL (Nginx host ou Cloudflare)

3. **Implementar Melhorias:**
   - [ ] Adicionar Redis para cache/sessions
   - [ ] Configurar queue worker
   - [ ] Implementar backups automáticos
   - [ ] Configurar monitoramento (Uptime Robot)

4. **Segurança:**
   - [ ] Firewall (UFW) permitindo apenas portas necessárias
   - [ ] Fail2ban para proteção SSH
   - [ ] SSL/HTTPS (Let's Encrypt ou Cloudflare)

---

## ✅ CONCLUSÃO

A pipeline já está bem configurada! Só precisa:

1. ✅ **Adicionar os 6 secrets no GitHub** (5 minutos)
2. ✅ **Preparar o servidor** (30 minutos - primeira vez)
3. ✅ **Fazer push para main** (automático depois)

**Vantagens do Deploy Automatizado:**
- ✅ Deploy em 10-20 minutos
- ✅ Testes automáticos antes do deploy
- ✅ Rollback fácil (git revert + novo push)
- ✅ Histórico completo de deploys
- ✅ Zero downtime (docker-compose up -d)

**Me avise quando:**
- Tiver as credenciais do servidor para configurar os secrets
- Precisar de ajuda para configurar o servidor
- Quiser fazer o primeiro deploy automatizado!

---

**Documento criado por:** Cloudeia AI
**Data:** 21/10/2025
