# 🔐 FLUXO COMPLETO DE AUTENTICAÇÃO - FreeFi Admin

## 📊 Estrutura de Usuários

### **Hierarquia de Empresas**
```
FreeFi Brasil (MATRIZ)
    ├─ FreeFi São Paulo (FRANQUIA) → Código: FREEFI-SP1
    │   ├─ Shopping Vila Olímpia (CLIENTE)
    │   ├─ Restaurante Fogo de Chão (CLIENTE)
    │   └─ Café Brigadeiro (CLIENTE)
    │
    ├─ FreeFi Rio de Janeiro (FRANQUIA) → Código: FREEFI-RJ1
    │   ├─ Bar Urca Point (CLIENTE)
    │   ├─ Hotel Copacabana Palace (CLIENTE)
    │   └─ Academia Barra Fitness (CLIENTE)
    │
    └─ FreeFi Minas Gerais (FRANQUIA) → Código: FREEFI-MG1
        └─ ...
```

---

## 🎭 Tipos de Usuários e Como se Cadastram

### **1. SUPERADMIN / ADMIN (Matriz)**
- **Criados manualmente** no banco de dados
- **Acesso:** Gestão completa de franquias, usuários, aprovações
- **Login:** Email/senha diretamente

**Usuários existentes:**
```
superadmin@freefi.com.br / password (SuperAdmin)
admin@freefi.com.br / password (Admin)
```

---

### **2. FRANQUEADOS (Gestores de Franquia)**
**Como se cadastram:**
1. Acessam `/register`
2. Informam o **código de convite da franquia** (ex: `FREEFI-SP1`)
3. Preenchem dados pessoais (nome, email, senha)
4. Status inicial: **PENDENTE**
5. SuperAdmin/Admin **APROVA** ou **REJEITA**
6. Se aprovado: podem fazer login

**Usuários franqueados existentes:**
```
gestor@freefisp.com.br / password (Franquia SP) - APROVADO
gerente@freefirj.com.br / password (Franquia RJ) - APROVADO
pedro@freefisp.com.br / password (Franquia SP) - PENDENTE
fernanda@freefimg.com.br / password (Franquia MG) - REJEITADO
```

**Acesso após login:**
- Gerenciar clientes da sua franquia
- Gerenciar mídias
- Gerenciar hotspots da franquia
- Ver estatísticas da franquia

---

### **3. CLIENTES (Donos de estabelecimentos)**
**Opção A - Cadastro via Código de Convite (MESMA ROTA):**
1. Acessam `/register`
2. Informam código de convite da franquia
3. Status inicial: **PENDENTE**
4. Franqueado ou SuperAdmin **APROVA**

**Opção B - Criados pelo Franqueado (FUTURO):**
1. Franqueado acessa módulo "Clientes"
2. Clica em "Novo Cliente"
3. Preenche dados do estabelecimento
4. Cria usuário para o cliente
5. Cliente recebe email com credenciais

**Usuários clientes existentes:**
```
gerente@shoppingvilaolimpia.com.br / password (Cliente Shopping) - APROVADO
dono@fogodechao.com.br / password (Cliente Restaurante) - APROVADO
```

**Acesso após login:**
- Ver estatísticas do seu estabelecimento
- Gerenciar publicações (anúncios)
- Ver hotspots instalados
- Ver logs de acesso WiFi

---

## 🚪 FLUXO DE LOGIN (Todos os tipos)

### **Tela de Login Única**
URL: `/login`

```
┌─────────────────────────────────────┐
│         LOGIN - FreeFi Admin        │
├─────────────────────────────────────┤
│  Email: ___________________________│
│  Senha: ___________________________│
│                                     │
│  [ ] Lembrar-me                     │
│                                     │
│  [  ENTRAR  ]                       │
│                                     │
│  Esqueceu a senha? | Cadastre-se   │
└─────────────────────────────────────┘
```

**Processo:**
1. Usuário digita email/senha
2. Laravel valida credenciais
3. **VERIFICAÇÃO:** `status_cadastro === 'aprovado'`
4. Se NÃO aprovado: **BLOQUEADO** ❌
5. Se aprovado: **REDIRECIONA** para dashboard ✅

---

## ⚠️ PROBLEMA ATUAL - FALTA MIDDLEWARE!

### **Situação Atual:**
- ❌ Usuários com `status_cadastro = 'pendente'` **PODEM** fazer login
- ❌ Usuários com `status_cadastro = 'rejeitado'` **PODEM** fazer login
- ❌ Não há bloqueio automático

### **Solução (FASE 2):**
Criar middleware `CheckApprovalStatus` que:
1. Verifica `status_cadastro` após login
2. Se != 'aprovado': logout automático
3. Redireciona para login com mensagem:
   - Pendente: "Seu cadastro está aguardando aprovação"
   - Rejeitado: "Seu cadastro foi rejeitado"

---

## 📋 FLUXO COMPLETO DE REGISTRO

### **1. Usuário acessa /register**
```
PASSO 1: Código de Convite
┌─────────────────────────────────────┐
│  Informe o código de convite:       │
│  [___________] [Validar]            │
└─────────────────────────────────────┘
```

### **2. Valida código (AJAX)**
```php
// RegisterController@validateCode
- Verifica se código existe
- Verifica se franquia está ativa
- Retorna dados da franquia
```

### **3. Exibe formulário completo**
```
PASSO 2: Dados Pessoais
┌─────────────────────────────────────┐
│  Franquia: FreeFi São Paulo ✓       │
│  Nome: _____________________________│
│  Email: ____________________________│
│  Senha: ____________________________│
│  Confirmar Senha: __________________│
│                                     │
│  [ CADASTRAR ]                      │
└─────────────────────────────────────┘
```

### **4. Cria usuário com status PENDENTE**
```php
User::create([
    'name' => $request->name,
    'email' => $request->email,
    'password' => Hash::make($request->password),
    'empresa_id' => $franquia->id,
    'status_cadastro' => 'pendente', // ← AGUARDANDO APROVAÇÃO
]);
```

### **5. Redireciona para login com mensagem**
```
✅ Cadastro realizado com sucesso!
   Aguarde a aprovação da sua conta.
```

---

## 🔄 FLUXO DE APROVAÇÃO

### **SuperAdmin/Admin acessa /users**
```
Lista de Usuários
┌──────────────────────────────────────────────────────┐
│ #  Nome          Email              Empresa  Situação│
├──────────────────────────────────────────────────────┤
│ 4  Pedro Oliveira pedro@...         SP      🟡       │ ← Clica na bolinha
│                                             ┌────────┐
│                                             │🟡 Pend │
│                                             │🟢 Apro │ ← Seleciona
│                                             │🔴 Reje │
│                                             └────────┘
└──────────────────────────────────────────────────────┘
```

### **Ao selecionar "Aprovado":**
1. Confirmação: "Tem certeza que deseja APROVAR?"
2. Se SIM: `UPDATE users SET status_cadastro = 'aprovado'`
3. Email enviado (FUTURO): "Seu cadastro foi aprovado!"
4. Usuário pode fazer login ✅

---

## 🎯 RESUMO: Como cada um se loga

| Tipo        | Como se Cadastra           | Quem Aprova      | Como Faz Login   |
|-------------|----------------------------|------------------|------------------|
| SuperAdmin  | Criado no banco            | -                | Email/Senha      |
| Admin       | Criado no banco            | -                | Email/Senha      |
| Franqueado  | `/register` + código       | SuperAdmin/Admin | Email/Senha      |
| Cliente     | `/register` + código       | Franqueado/Admin | Email/Senha      |

---

## 🚀 PRÓXIMAS IMPLEMENTAÇÕES (FASE 2)

### **1. Middleware CheckApprovalStatus**
Bloquear login de não-aprovados

### **2. Emails Automáticos**
- Cadastro pendente → Email para admins
- Cadastro aprovado → Email para usuário
- Cadastro rejeitado → Email para usuário

### **3. Dashboard por Tipo**
- SuperAdmin: vê tudo
- Franqueado: vê só sua franquia
- Cliente: vê só seu estabelecimento

### **4. Módulo "Meus Clientes" para Franqueados**
Criar clientes diretamente (sem código de convite)

---

## 📝 Credenciais de Teste

### **SuperAdmin:**
```
Email: superadmin@freefi.com.br
Senha: password
```

### **Franqueado (Aprovado):**
```
Email: gestor@freefisp.com.br
Senha: password
```

### **Franqueado (Pendente):**
```
Email: pedro@freefisp.com.br
Senha: password
⚠️ NÃO deveria conseguir logar (mas consegue - BUG a corrigir)
```

### **Cliente (Aprovado):**
```
Email: gerente@shoppingvilaolimpia.com.br
Senha: password
```

---

## 🔍 Comandos Úteis

**Ver todos os usuários e status:**
```bash
docker exec freefi-admin-app php artisan tinker
>>> User::with('empresa')->get(['id','name','email','status_cadastro','empresa_id']);
```

**Aprovar usuário manualmente:**
```bash
>>> User::where('email', 'pedro@freefisp.com.br')->update(['status_cadastro' => 'aprovado']);
```

**Ver códigos de convite das franquias:**
```bash
>>> Empresa::where('tipo_empresa', 'franquia')->get(['name', 'codigo_convite']);
```
