# 🚀 Guia Rápido - Sistema de Filtro Avançado

## Como Usar em 3 Passos

### Passo 1️⃣: Escolha o Tipo de Filtro
Clique no select "Tipo" e escolha onde deseja buscar:
- 🏢 **Empresa** - Busca pelo nome da empresa
- 🏷️ **Marca** - Busca pela marca do hotspot
- 📦 **Modelo** - Busca pelo modelo do hotspot
- 🔢 **Serial** - Busca pelo número de série

### Passo 2️⃣: Digite o Termo
No campo de busca, digite o que procura:
- Pode ser parte do nome (busca parcial)
- Não diferencia maiúsculas de minúsculas
- Exemplos: "Mikro", "UniFi", "hAP", etc.

### Passo 3️⃣: Clique em Buscar
Clique no botão "🔍 Buscar" ou pressione Enter

## 💡 Dicas

### ✨ O placeholder muda automaticamente!
Quando você muda o tipo de filtro, o texto de ajuda no campo muda também:
- Empresa: "Digite o nome da empresa..."
- Marca: "Digite a marca do hotspot..."
- Modelo: "Digite o modelo do hotspot..."
- Serial: "Digite o serial do hotspot..."

### 🔄 Os filtros são preservados
Ao navegar entre páginas, seus filtros continuam ativos!

### ❌ Limpar filtros
Quando há uma busca ativa, aparece um botão "X" para limpar tudo rapidamente.

## 📝 Exemplos Práticos

### Exemplo 1: Buscar todos os hotspots Mikrotik
```
1. Selecione: Marca
2. Digite: Mikrotik
3. Clique: Buscar
```

### Exemplo 2: Buscar hotspots de uma empresa específica
```
1. Selecione: Empresa
2. Digite: Nome da Empresa
3. Clique: Buscar
```

### Exemplo 3: Encontrar um serial específico
```
1. Selecione: Serial
2. Digite: AA1234 (ou parte dele)
3. Clique: Buscar
```

### Exemplo 4: Buscar modelos UniFi
```
1. Selecione: Modelo
2. Digite: UniFi
3. Clique: Buscar
4. Resultado: Todos os modelos que contenham "UniFi"
```

## ⚡ Atalhos de Teclado

- **Tab**: Navegar entre campos
- **Enter**: Executar busca
- **Esc** (no campo): Limpar o campo de busca

## 🎯 Resultados

### O que você verá:
- ✅ Apenas os hotspots que correspondem ao filtro
- ✅ Numeração correta das linhas
- ✅ Paginação funcional
- ✅ Todos os dados do hotspot

### Se não encontrar nada:
- Verifique se digitou corretamente
- Tente buscar apenas parte do nome
- Certifique-se de escolher o tipo correto

## 🔍 Tipos de Busca

### Busca Parcial (LIKE)
O sistema encontra resultados que **contenham** o termo buscado:
- Busca: "Mikro" → Encontra: "Mikrotik"
- Busca: "hAP" → Encontra: "hAP ac2", "hAP ac3"
- Busca: "UniFi" → Encontra: "UniFi AP AC Lite", "UniFi AP AC Pro"

### Case Insensitive
Não importa se você digita em maiúsculas ou minúsculas:
- "mikrotik" = "Mikrotik" = "MIKROTIK"

## 🎨 Interface

```
┌─────────────────────────────────────────────────────────────────┐
│ 🔍 Tipo: Marca ▼  │  Digite a marca do hotspot...  │ 🔍 Buscar │ ❌ │
└─────────────────────────────────────────────────────────────────┘
```

## ❓ Perguntas Frequentes

**P: Posso buscar em vários campos ao mesmo tempo?**
R: Não, escolha um tipo de filtro por vez. Isso torna a busca mais precisa.

**P: O filtro funciona com a paginação?**
R: Sim! Os filtros são mantidos ao navegar entre páginas.

**P: Como volto a ver todos os hotspots?**
R: Clique no botão "X" ou acesse a página sem filtros.

**P: A busca é exata ou parcial?**
R: É parcial! Digite apenas parte do que procura.

**P: Posso buscar por empresa mesmo que não saiba o nome completo?**
R: Sim! Digite parte do nome que o sistema encontra.

## 🎓 Casos de Uso

### 1. Auditor de Rede
"Preciso ver todos os hotspots Ubiquiti do cliente X"
- Tipo: Empresa → Digite: Cliente X
- Veja apenas hotspots dessa empresa
- Depois: Tipo: Marca → Digite: Ubiquiti

### 2. Técnico de Suporte
"Um cliente ligou reportando problema no serial XX1234..."
- Tipo: Serial → Digite: XX1234
- Encontre rapidamente o equipamento

### 3. Gerente de TI
"Quantos modelos hAP temos no sistema?"
- Tipo: Modelo → Digite: hAP
- Veja todos os modelos hAP listados

### 4. Administrador
"Preciso fazer manutenção em todos os Mikrotik"
- Tipo: Marca → Digite: Mikrotik
- Acesse rapidamente todos os equipamentos

---

**🎉 Aproveite o novo sistema de filtros!**

Qualquer dúvida, consulte a documentação completa em `FILTRO_AVANCADO.md`
