# 📁 LOCALIZAÇÃO FÍSICA DAS IMAGENS UPLOADADAS

**Data:** 18/10/2025

---

## 🎯 CAMINHO COMPLETO

```
/var/www/html/laravel/admin/freefi_admin/storage/app/public/midias/
```

---

## 📂 ESTRUTURA DE DIRETÓRIOS

```
freefi_admin/
│
├── storage/
│   └── app/
│       └── public/
│           ├── logos/              ← Logomarcas de empresas
│           └── midias/             ← 🎯 SEUS CRIATIVOS AQUI!
│               ├── f0932161d29feec7f5e13fe2730d4a4f.jpg  (86 KB)
│               ├── 2f3ce712b28765f2912f0b0ffc762c38.jpg  (33 KB)
│               ├── 7da28e92d091d48098eb572ffee796c0.jpg  (33 KB)
│               ├── 678e0306b50ca991c6ed2e806a6403d8.jpg  (15 KB)
│               └── d65560ef1ea4e4a72babbcfa2a3a1251.jpg  (15 KB)
│
└── public/
    └── storage/                    ← Link simbólico (atalho)
        ├── logos/
        └── midias/                 ← Mesmos arquivos via atalho
```

---

## 🗺️ MAPEAMENTO: BANCO DE DADOS → ARQUIVO

### Seu Criativo Principal

| Campo | Valor |
|-------|-------|
| **ID** | 6 |
| **Título** | "Grupo BH é São" |
| **Arquivo** | `f0932161d29feec7f5e13fe2730d4a4f.jpg` |
| **Tamanho** | 86 KB |
| **Hash MD5** | `f0932161d29feec7f5e13fe2730d4a4f` |

**Caminho completo:**
```
/var/www/html/laravel/admin/freefi_admin/storage/app/public/midias/f0932161d29feec7f5e13fe2730d4a4f.jpg
```

### Criativos de Teste

| ID | Arquivo (Hash MD5) | Tamanho |
|----|-------------------|---------|
| 4 | `d65560ef1ea4e4a72babbcfa2a3a1251.jpg` | 15 KB |
| 5 | `678e0306b50ca991c6ed2e806a6403d8.jpg` | 15 KB |
| 7 | `2f3ce712b28765f2912f0b0ffc762c38.jpg` | 33 KB |
| 8 | `7da28e92d091d48098eb572ffee796c0.jpg` | 33 KB |

**Total:** 5 imagens (192 KB)

---

## 🔍 COMO VISUALIZAR AS IMAGENS

### Método 1: Gerenciador de Arquivos (Nautilus/Dolphin)

**Abrir pasta:**
```bash
xdg-open /var/www/html/laravel/admin/freefi_admin/storage/app/public/midias/
```

**Ou manualmente:**
1. Abra o gerenciador de arquivos
2. Pressione `Ctrl + L` (para editar caminho)
3. Cole: `/var/www/html/laravel/admin/freefi_admin/storage/app/public/midias`
4. Pressione `Enter`
5. Clique duplo em qualquer `.jpg` para visualizar

---

### Método 2: Visualizador de Imagens (EOG)

**Abrir TODAS as imagens:**
```bash
eog /var/www/html/laravel/admin/freefi_admin/storage/app/public/midias/*.jpg
```

**Abrir apenas sua imagem (ID 6):**
```bash
eog /var/www/html/laravel/admin/freefi_admin/storage/app/public/midias/f0932161d29feec7f5e13fe2730d4a4f.jpg
```

**Navegação:**
- Use as setas `←` `→` para navegar entre imagens
- Pressione `F` para tela cheia
- Pressione `Esc` para sair

---

### Método 3: Navegador Web

**Sua imagem principal (ID 6):**
```
http://localhost:8082/storage/midias/f0932161d29feec7f5e13fe2730d4a4f.jpg
```

**Formato genérico:**
```
http://localhost:8082/storage/midias/{hash-md5}.jpg
```

**Exemplo de outras imagens:**
- http://localhost:8082/storage/midias/2f3ce712b28765f2912f0b0ffc762c38.jpg
- http://localhost:8082/storage/midias/7da28e92d091d48098eb572ffee796c0.jpg

---

### Método 4: Sistema de Criativos (Preview)

1. Acesse: http://localhost:8082/midias
2. Localize o criativo na lista (ID 6 - "Grupo BH é São")
3. Clique no ícone 🖼️ de preview
4. Imagem abre em modal

---

## 📋 COMANDOS RÁPIDOS

### Listar arquivos na pasta:
```bash
ls -lh /var/www/html/laravel/admin/freefi_admin/storage/app/public/midias/
```

### Contar quantas imagens:
```bash
ls -1 /var/www/html/laravel/admin/freefi_admin/storage/app/public/midias/ | wc -l
```

### Ver tamanho total:
```bash
du -sh /var/www/html/laravel/admin/freefi_admin/storage/app/public/midias/
```

### Copiar pasta para área de trabalho:
```bash
cp -r /var/www/html/laravel/admin/freefi_admin/storage/app/public/midias/ ~/Desktop/criativos_backup/
```

---

## 🔗 LINKS ALTERNATIVOS

Se você usar `public/storage/` ao invés de `storage/app/public/`, chegará no mesmo lugar devido ao link simbólico:

```bash
# Ambos são equivalentes:
/var/www/html/laravel/admin/freefi_admin/storage/app/public/midias/
/var/www/html/laravel/admin/freefi_admin/public/storage/midias/
```

**Verificar link:**
```bash
ls -la /var/www/html/laravel/admin/freefi_admin/public/ | grep storage
```

Deve mostrar:
```
storage -> /var/www/html/laravel/admin/freefi_admin/storage/app/public
```

---

## 🎨 INFORMAÇÕES TÉCNICAS

### Formato das Imagens

- **Formato:** JPEG
- **Dimensões:** 640x1100 pixels (redimensionadas automaticamente)
- **Qualidade:** 75% (padrão Intervention Image)
- **Esquema de cores:** RGB (3 componentes)

### Nome dos Arquivos

Todos os arquivos são nomeados com **hash MD5** (32 caracteres hexadecimais):

**Algoritmo:**
```php
$uniqueString = uniqid('', true) . microtime(true) . rand(1000, 9999);
$hashedName = md5($uniqueString);
$filename = $hashedName . '.jpg';
```

**Exemplo:**
```
f0932161d29feec7f5e13fe2730d4a4f.jpg
└─────────────┬─────────────┘
           Hash MD5 (32 chars)
```

**Vantagens:**
- ✅ Unicidade garantida (não haverá colisão)
- ✅ Segurança (nome imprevisível)
- ✅ Privacidade (não revela arquivo original)

---

## 📊 ESTATÍSTICAS

```
Total de arquivos:  5 imagens
Tamanho total:      192 KB
Formato:            JPEG
Dimensões:          640x1100 pixels
Compressão:         75% (Intervention Image)
```

### Distribuição por Tamanho

| Tamanho | Quantidade | Arquivos |
|---------|------------|----------|
| 86 KB   | 1          | f0932161... (ID 6) |
| 33 KB   | 2          | 2f3ce712..., 7da28e92... |
| 15 KB   | 2          | 678e0306..., d65560ef... |

---

## 🚀 ACESSO RÁPIDO

**Copie e cole no terminal:**

```bash
# Abrir pasta no gerenciador
xdg-open /var/www/html/laravel/admin/freefi_admin/storage/app/public/midias/

# Abrir todas as imagens
eog /var/www/html/laravel/admin/freefi_admin/storage/app/public/midias/*.jpg

# Navegar até a pasta
cd /var/www/html/laravel/admin/freefi_admin/storage/app/public/midias/
```

**Copie o caminho para o gerenciador:**
```
/var/www/html/laravel/admin/freefi_admin/storage/app/public/midias
```

---

**Última atualização:** 18/10/2025 14:45:00  
**Total de uploads:** 5 imagens  
**Sistema:** 100% funcional ✅
