<?php
namespace App\Http\Controllers;
use App\Models\Group;
use App\Models\Permission;
use Illuminate\Http\Request;

class GroupController extends Controller {
  public function index() {
    $groups = Group::orderBy('name')->get();
    return view('groups.index', compact('groups'));
  }
  public function create() { return view('groups.form'); }
  public function store(Request $request) {
    $data = $request->validate(['name'=>'required','description'=>'nullable']);
    Group::create($data);
    return redirect()->route('groups.index')->with('success','Grupo criado');
  }
  public function edit(Group $group) { return view('groups.form', compact('group')); }
  public function update(Request $request, Group $group) {
    $data = $request->validate(['name'=>'required','description'=>'nullable']);
    $group->update($data);
    return redirect()->route('groups.index')->with('success','Grupo atualizado');
  }
  public function destroy(Group $group) {
    $group->delete();
    return redirect()->route('groups.index')->with('success','Grupo excluído');
  }

  // Tela de matriz de permissões
  public function editPermissions(Group $group) {
    $permissions = Permission::orderBy('subsystem')->orderBy('action')->get()->groupBy('subsystem');
    $current = $group->permissions()->pluck('permissions.id')->toArray();
    return view('groups.permissions.matrix', compact('group','permissions','current'));
  }
  public function updatePermissions(Request $request, Group $group) {
    $ids = $request->input('permissions', []);
    $group->permissions()->sync($ids);
    return redirect()->route('groups.index')->with('success','Permissões do grupo atualizadas');
  }
}
