<?php
namespace App\Http\Controllers;
use App\Models\Permission;
use Illuminate\Http\Request;

class PermissionController extends Controller {
  public function index() {
    $permissions = Permission::orderBy('subsystem')->orderBy('action')->get();
    return view('permissions.index', compact('permissions'));
  }
  public function create() {
    return view('permissions.form');
  }
  public function store(Request $request) {
    $data = $request->validate([
      'subsystem'=>'required|string|max:100',
      'action'=>'required|string|max:100',
      'name'=>'required|string|max:255',
      'description'=>'nullable|string',
    ]);
    $data['slug'] = $data['subsystem'].'.'.$data['action'];
    Permission::create($data);
    return redirect()->route('permissions.index')->with('success','Permissão criada');
  }
  public function edit(Permission $permission) {
    return view('permissions.form', compact('permission'));
  }
  public function update(Request $request, Permission $permission) {
    $data = $request->validate([
      'subsystem'=>'required|string|max:100',
      'action'=>'required|string|max:100',
      'name'=>'required|string|max:255',
      'description'=>'nullable|string',
    ]);
    $data['slug'] = $data['subsystem'].'.'.$data['action'];
    $permission->update($data);
    return redirect()->route('permissions.index')->with('success','Permissão atualizada');
  }
  public function destroy(Permission $permission) {
    $permission->delete();
    return redirect()->route('permissions.index')->with('success','Permissão excluída');
  }
}
