<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

/**
 * Middleware para garantir que apenas SuperAdmins acessem determinadas rotas
 *
 * SuperAdmin: is_superadmin = 1
 * - Acesso total ao sistema
 * - Pode aprovar/rejeitar cadastros
 * - Gerencia todas as empresas
 * - Vê todos os dados
 *
 * Criado em: 08/11/2025
 * Documentação: tests/documentation/ACESSO-USUARIO-FRANQUIA-08-11-2025.md
 */
class SuperAdminOnly
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        // Verifica se o usuário está autenticado
        if (!Auth::check()) {
            return redirect()->route('login');
        }

        // Verifica se o usuário é SuperAdmin
        if (!Auth::user()->is_superadmin) {
            abort(403, 'Acesso negado. Esta área é restrita a SuperAdministradores.');
        }

        return $next($request);
    }
}
