<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ConfiguracaoPreco extends Model
{
    protected $table = 'configuracao_precos';

    protected $fillable = [
        'chave',
        'nome',
        'valor',
        'descricao',
        'ativo',
    ];

    protected $casts = [
        'valor' => 'decimal:2',
        'ativo' => 'boolean',
    ];

    /**
     * Obter valor por chave
     */
    public static function getValor(string $chave, $default = null)
    {
        $config = self::where('chave', $chave)
            ->where('ativo', true)
            ->first();

        return $config ? $config->valor : $default;
    }

    /**
     * Obter preço semanal
     */
    public static function getPrecoSemanal()
    {
        return self::getValor('preco_semanal', 150.00);
    }

    /**
     * Obter preço mensal
     */
    public static function getPrecoMensal()
    {
        return self::getValor('preco_mensal', 600.00);
    }

    /**
     * Calcular preço baseado na periodicidade
     */
    public static function calcularPreco(string $periodicidade, int $quantidade = 1)
    {
        $valorUnitario = $periodicidade === 'mensal'
            ? self::getPrecoMensal()
            : self::getPrecoSemanal();

        return $valorUnitario * $quantidade;
    }
}
