<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\PublicacaoClique>
 */
class PublicacaoCliqueFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'hotspot_id' => \App\Models\Hotspot::factory(),
            'publicacao_id' => \App\Models\Publicacao::factory(),
            'criativo_id' => \App\Models\Criativo::factory(),
            'ip_usuario' => fake()->ipv4(),
            'user_agent' => fake()->userAgent(),
            'clicked_at' => fake()->dateTimeBetween('-30 days', 'now'),
        ];
    }

    /**
     * Estado: Hoje
     */
    public function hoje(): static
    {
        return $this->state(fn (array $attributes) => [
            'clicked_at' => fake()->dateTimeBetween('today', 'now'),
        ]);
    }

    /**
     * Estado: Desktop
     */
    public function desktop(): static
    {
        return $this->state(fn (array $attributes) => [
            'user_agent' => fake()->chrome(),
        ]);
    }

    /**
     * Estado: Mobile
     */
    public function mobile(): static
    {
        return $this->state(fn (array $attributes) => [
            'user_agent' => 'Mozilla/5.0 (iPhone; CPU iPhone OS 14_0 like Mac OS X) AppleWebKit/605.1.15',
        ]);
    }

    /**
     * Estado: Horário comercial
     */
    public function horarioComercial(): static
    {
        return $this->state(fn (array $attributes) => [
            'clicked_at' => fake()->dateTimeBetween('today 08:00', 'today 18:00'),
        ]);
    }
}
