<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('empresas', function (Blueprint $table) {
            // Tipo de empresa (matriz, franquia, cliente)
            $table->enum('tipo_empresa', ['matriz', 'franquia', 'cliente'])
                  ->default('cliente')
                  ->after('name');
            
            // Hierarquia: empresa pai (franquia ou matriz)
            $table->foreignId('empresa_pai_id')
                  ->nullable()
                  ->after('tipo_empresa')
                  ->constrained('empresas')
                  ->onDelete('restrict'); // Não pode deletar se tiver filhos
            
            // Código de convite para registro de usuários
            $table->string('codigo_convite', 10)
                  ->unique()
                  ->nullable()
                  ->after('empresa_pai_id')
                  ->comment('Código para registro de funcionários da franquia (4 letras + 6 dígitos)');
            
            // Índices para performance
            $table->index('tipo_empresa');
            $table->index('empresa_pai_id');
            $table->index('codigo_convite');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('empresas', function (Blueprint $table) {
            $table->dropForeign(['empresa_pai_id']);
            $table->dropIndex(['tipo_empresa']);
            $table->dropIndex(['empresa_pai_id']);
            $table->dropIndex(['codigo_convite']);
            $table->dropColumn(['tipo_empresa', 'empresa_pai_id', 'codigo_convite']);
        });
    }
};
