<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('publicacoes', function (Blueprint $table) {
            $table->id();
            
            // Criativo sendo reutilizado (path/arquivo físico)
            $table->foreignId('criativo_id')
                  ->constrained('criativos')
                  ->onDelete('restrict');
            
            // Franquia que está vendendo
            $table->foreignId('franquia_id')
                  ->constrained('empresas')
                  ->onDelete('restrict');
            
            // Cliente que comprou
            $table->foreignId('cliente_id')
                  ->constrained('empresas')
                  ->onDelete('restrict');
            
            // Título da campanha/publicação
            $table->string('titulo');
            
            // Período do contrato
            $table->date('data_inicio');
            $table->date('data_fim');
            
            // Valores comerciais
            $table->decimal('valor_contrato', 10, 2)->nullable();
            $table->integer('impressoes_contratadas')->nullable();
            
            // Status da publicação
            $table->enum('status', ['ativa', 'pausada', 'expirada', 'cancelada'])
                  ->default('ativa');
            
            // Quem publicou (nullable para permitir criação sem usuário)
            $table->foreignId('publicada_por')
                  ->nullable()
                  ->constrained('users')
                  ->onDelete('set null');
            
            // Quando foi publicada (nullable até ser publicada)
            $table->timestamp('publicada_em')->nullable();
            
            // Userstamps (quem criou/atualizou/deletou)
            $table->foreignId('created_by')->nullable()->constrained('users')->onDelete('set null');
            $table->foreignId('updated_by')->nullable()->constrained('users')->onDelete('set null');
            $table->foreignId('deleted_by')->nullable()->constrained('users')->onDelete('set null');
            
            $table->timestamps();
            $table->softDeletes();
            
            // Índices para performance
            $table->index('criativo_id');
            $table->index('franquia_id');
            $table->index('cliente_id');
            $table->index('status');
            $table->index(['data_inicio', 'data_fim']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('publicacoes');
    }
};
