<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('franquia_formatos_permitidos', function (Blueprint $table) {
            $table->id();
            
            // Franquia
            $table->foreignId('franquia_id')
                  ->constrained('empresas')
                  ->onDelete('cascade');
            
            // Formato permitido
            $table->enum('formato', ['jpg', 'png', 'gif', 'mp4', 'html']);
            
            // Se está ativo ou não
            $table->boolean('ativo')->default(true);
            
            $table->timestamps();
            
            // Não pode ter formato duplicado para mesma franquia
            $table->unique(['franquia_id', 'formato']);
            
            // Índices
            $table->index('franquia_id');
            $table->index('ativo');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('franquia_formatos_permitidos');
    }
};
