<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('estatisticas_midia', function (Blueprint $table) {
            $table->id();
            
            // Publicação monitorada
            $table->foreignId('publicacao_id')
                  ->constrained('publicacoes')
                  ->onDelete('cascade');
            
            // Criativo (denormalizado para performance)
            $table->foreignId('criativo_id')
                  ->constrained('criativos')
                  ->onDelete('cascade');
            
            // Cliente e Franquia (denormalizado)
            $table->foreignId('cliente_id')
                  ->constrained('empresas')
                  ->onDelete('cascade');
            
            $table->foreignId('franquia_id')
                  ->constrained('empresas')
                  ->onDelete('cascade');
            
            // Hotspot onde foi exibida
            $table->foreignId('hotspot_id')
                  ->constrained('hotspots')
                  ->onDelete('cascade');
            
            // Data da estatística (agregado diário)
            $table->date('data');
            
            // Métricas
            $table->integer('total_impressoes')->default(0);
            $table->integer('total_cliques')->default(0);
            $table->integer('tempo_medio_visualizacao')->default(0)->comment('Em segundos');
            $table->integer('dispositivos_unicos')->default(0);
            
            $table->timestamps();
            
            // Índices para queries de relatórios
            $table->index('publicacao_id');
            $table->index('criativo_id');
            $table->index('cliente_id');
            $table->index('franquia_id');
            $table->index('hotspot_id');
            $table->index('data');
            $table->index(['cliente_id', 'data']);
            $table->index(['franquia_id', 'data']);
            
            // Não pode ter estatística duplicada para mesmo dia
            $table->unique(['publicacao_id', 'hotspot_id', 'data']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('estatisticas_midia');
    }
};
